# Makefile for UAE (Un*x Amiga Emulator)
#
# Copyright 1995,1996 Bernd Schmidt
# Copyright 1996 Ed Hanway

.SUFFIXES: .o .c .h .m

INCLUDES=-Iinclude

OBJS = main.o newcpu.o memory.o debug.o custom.o cia.o disk.o $(GFXOBJS) \
       autoconf.o os.o ersatz.o filesys.o hardfile.o keybuf.o expansion.o \
       readcpu.o cpudefs.o gfxutil.o gfxlib.o blitfunc.o blittable.o $(ASSEMBLYOBJS) \
       cpu0.o cpu1.o cpu2.o cpu3.o cpu4.o cpu5.o cpu6.o cpu7.o \
       cpu8.o cpu9.o cpuA.o cpuB.o cpuC.o cpuD.o cpuE.o cpuF.o cpustbl.o

all: sysconfig.h bebox

sysconfig.h: sysconfig.h.Be
	cp sysconfig.h.Be sysconfig.h

bebox:
	$(MAKE) -fMakefile.Be \
		CC='mwcc' \
		GFXOBJS='bebox.o nogui.o' \
		CFLAGS='-O7 -DPPC603=1 -D__unix -D__bebox__' \
		LDFLAGS='' \
		INCPATH='-I$(BEINCLUDES)' \
		progs

progs: uae readdisk

install:

readdisk: readdisk.o
	$(CC) readdisk.o -o readdisk $(LDFLAGS) $(DEBUGFLAGS)

uae: $(OBJS)
	$(CC) $(OBJS) -o uae $(GFXLDFLAGS) $(AFLDFLAGS) $(LDFLAGS) $(DEBUGFLAGS)

clean:
	-rm -f *.o uae readdisk
	-rm -f gencpu genblitter build68k cpudefs.c
	-rm -f cpu?.c blit.h
	-rm -f cputbl.h cpustbl.c
	-rm -f blitfunc.c blitfunc.h blittable.c

halfclean:
	-rm -f $(OBJS) $(GFXOBJS)

blit.h: genblitter
	./genblitter i >blit.h
blitfunc.c: genblitter blitfunc.h
	./genblitter f >blitfunc.c
blitfunc.h: genblitter
	./genblitter h >blitfunc.h
blittable.c: genblitter blitfunc.h
	./genblitter t >blittable.c

genblitter: genblitter.o
	$(CC) $(LDFLAGS) -o $@ $?
build68k: build68k.o
	$(CC) $(LDFLAGS) -o $@ $?
gencpu: gencpu.o readcpu.o cpudefs.o
	$(CC) $(LDFLAGS) -o $@ gencpu.o readcpu.o cpudefs.o

custom.o: blit.h

cpudefs.c: build68k table68k
	./build68k >cpudefs.c
cpustbl.c: gencpu
	./gencpu s >cpustbl.c
cputbl.c: gencpu
	./gencpu t >cputbl.c
cputbl.h: gencpu
	./gencpu h >cputbl.h

cpu0.c: gencpu
	./gencpu f 0 >cpu0.c
cpu1.c: gencpu
	./gencpu f 1 >cpu1.c
cpu2.c: gencpu
	./gencpu f 2 >cpu2.c
cpu3.c: gencpu
	./gencpu f 3 >cpu3.c
cpu4.c: gencpu
	./gencpu f 4 >cpu4.c
cpu5.c: gencpu
	./gencpu f 5 >cpu5.c
cpu6.c: gencpu
	./gencpu f 6 >cpu6.c
cpu7.c: gencpu
	./gencpu f 7 >cpu7.c
cpu8.c: gencpu
	./gencpu f 8 >cpu8.c
cpu9.c: gencpu
	./gencpu f 9 >cpu9.c
cpuA.c: gencpu
	./gencpu f 10 >cpuA.c
cpuB.c: gencpu
	./gencpu f 11 >cpuB.c
cpuC.c: gencpu
	./gencpu f 12 >cpuC.c
cpuD.c: gencpu
	./gencpu f 13 >cpuD.c
cpuE.c: gencpu
	./gencpu f 14 >cpuE.c
cpuF.c: gencpu
	./gencpu f 15 >cpuF.c

cpu0.o: cpu0.c
	$(CC) $(INCLUDES) -c $(INCDIRS) $(CFLAGS) $*.c
cpu1.o: cpu1.c
	$(CC) $(INCLUDES) -c $(INCDIRS) $(CFLAGS) $*.c
cpu2.o: cpu2.c
	$(CC) $(INCLUDES) -c $(INCDIRS) $(CFLAGS) $*.c
cpu3.o: cpu3.c
	$(CC) $(INCLUDES) -c $(INCDIRS) $(CFLAGS) $*.c
cpu4.o: cpu4.c
	$(CC) $(INCLUDES) -c $(INCDIRS) $(CFLAGS) $*.c
cpu5.o: cpu5.c
	$(CC) $(INCLUDES) -c $(INCDIRS) $(CFLAGS) $*.c
cpu6.o: cpu6.c
	$(CC) $(INCLUDES) -c $(INCDIRS) $(CFLAGS) $*.c
cpu7.o: cpu7.c
	$(CC) $(INCLUDES) -c $(INCDIRS) $(CFLAGS) $*.c
cpu8.o: cpu8.c
	$(CC) $(INCLUDES) -c $(INCDIRS) $(CFLAGS) $*.c
cpu9.o: cpu9.c
	$(CC) $(INCLUDES) -c $(INCDIRS) $(CFLAGS) $*.c
cpuA.o: cpuA.c
	$(CC) $(INCLUDES) -c $(INCDIRS) $(CFLAGS) $*.c
cpuB.o: cpuB.c
	$(CC) $(INCLUDES) -c $(INCDIRS) $(CFLAGS) $*.c
cpuC.o: cpuC.c
	$(CC) $(INCLUDES) -c $(INCDIRS) $(CFLAGS) $*.c
cpuD.o: cpuD.c
	$(CC) $(INCLUDES) -c $(INCDIRS) $(CFLAGS) $*.c
cpuE.o: cpuE.c
	$(CC) $(INCLUDES) -c $(INCDIRS) $(CFLAGS) $*.c
cpuF.o: cpuF.c
	$(CC) $(INCLUDES) -c $(INCDIRS) $(CFLAGS) $*.c

bebox.o: bebox.cpp
	$(CC) $(INCLUDES) -c $(INCDIRS) $(CFLAGS) $(DEBUGFLAGS) bebox.cpp
X86.o: X86.S
	$(CC) $(INCLUDES) -c $(INCDIRS) $(CFLAGS) $(DEBUGFLAGS) $(ASSEMBLYCFLAGS) X86.S

.m.o:
	$(CC) $(INCLUDES) -c $(INCDIRS) $(CFLAGS) $(DEBUGFLAGS) $*.m
.c.o:
	$(CC) $(INCLUDES) -c $(INCDIRS) $(CFLAGS) $(DEBUGFLAGS) $(ASSEMBLYCFLAGS) $*.c
.c.s:
	$(CC) $(INCLUDES) -S $(INCDIRS) $(CFLAGS) $*.c
.S.o:
	$(CC) $(INCLUDES) -c $(INCDIRS) $(CFLAGS) $(DEBUGFLAGS) $(ASSEMBLYCFLAGS) $*.S

# Saves recompiling...
touch:
	touch *.o; touch build68k; touch cpudefs.c; touch cpudefs.o; touch gencpu; touch genblitter; touch cpu*.c; touch cpu*.h; touch cpu*.o

# Some more dependencies...
cpu0.o: cputbl.h
cpu1.o: cputbl.h
cpu2.o: cputbl.h
cpu3.o: cputbl.h
cpu4.o: cputbl.h
cpu5.o: cputbl.h
cpu6.o: cputbl.h
cpu7.o: cputbl.h
cpu8.o: cputbl.h
cpu9.o: cputbl.h
cpuA.o: cputbl.h
cpuB.o: cputbl.h
cpuC.o: cputbl.h
cpuD.o: cputbl.h
cpuE.o: cputbl.h
cpuF.o: cputbl.h
cpustbl.o: cputbl.h
cputbl.o: cputbl.h

build68k.o: include/readcpu.h
readcpu.o: include/readcpu.h

main.o: config.h
cia.o: config.h
custom.o: config.h
newcpu.o: config.h
autoconf.o: config.h
expansion.o: config.h
xwin.o: config.h
svga.o: config.h
bebox.o: config.h
os.o: config.h
memory.o: config.h
debug.o: config.h
ersatz.o: config.h
disk.o: config.h
