/* To compile                */
/*  gcc joycal.c -o joycal   */

#include <linux/joystick.h>
#include <stdio.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/ioctl.h>
#include <errno.h>
#include <malloc.h>

static int JoyDevice;

struct JS_DATA_TYPE JoyPosition ()
{
    struct JS_DATA_TYPE js_data;
    
    while ((read (JoyDevice, &js_data, JS_RETURN) > 0) && js_data.buttons != 0x00);
    while ((read (JoyDevice, &js_data, JS_RETURN) > 0) && js_data.buttons == 0x00)
	printf ("    x = %5d, y = %5d\r", js_data.x, js_data.y);
    
    return (js_data);
}

void Calibrate (int Sensibility)
{
    
    long tmpl;
    int status;
    char fname[] = "/dev/js0";
    struct JS_DATA_TYPE js_data, JoyUpperLeft, JoyCenter, JoyLowerRight;
    
    JoyDevice = open (fname, O_RDONLY);
    if (JoyDevice < 0) {
	perror ("jscal");
	exit (1);
    }
    
    tmpl = 2;
    status = ioctl (JoyDevice, JS_SET_TIMELIMIT, &tmpl);
    if (status == -1) {
	perror ("jscal");
	exit (1);
    }
    
    js_data.x = 0;
    js_data.y = 0;
    status = ioctl (JoyDevice, JS_SET_CAL, &js_data);
    if (status == -1) {
	perror ("jscal");
	exit (1);
    }
 
    printf ("Center Joystick and push button.\n");
    JoyCenter = JoyPosition ();
    
    printf ("Move Joystick to upper left and push button.\n");
    JoyUpperLeft = JoyPosition ();
    
    printf ("Move Joystick to lower right and push button.\n");
    JoyLowerRight = JoyPosition ();
    
    printf ("                                              \n");
    
    printf ("Up:    %5d\n", JoyCenter.y - 
                          (JoyCenter.y - JoyUpperLeft.y) * Sensibility / 100);
    printf ("Down:  %5d\n", JoyCenter.y + 
                         (JoyLowerRight.y - JoyCenter.y) * Sensibility / 100);
    printf ("Left:  %5d\n", JoyCenter.x - 
                          (JoyCenter.x - JoyUpperLeft.x) * Sensibility / 100);
    printf ("Right: %5d\n", JoyCenter.x + 
                         (JoyLowerRight.x - JoyCenter.x) * Sensibility / 100);
    close (JoyDevice);
}


void main ()
{
    printf("\nCalibrating Joystick:\n\n");
    Calibrate (50);
}

