/*
 *	The C64 emulator
 *
 *	Copyright 1996 by ALE.
 *	written by Lutz Sammer.
 *
 *	Video driver for svgalib and linux.
 *-----------------------------------------------------------------------------
 * $Id: video_svga.h,v 1.3 1996/06/13 00:05:35 ari Exp root $
 * $Log: video_svga.h,v $
 * Revision 1.3  1996/06/13 00:05:35  ari
 * Added volatile for VideoIsDisplayed and removed hot polling!
 *
 * Revision 1.2  1996/06/12 23:34:00  johns
 * Add video-sync and overscan support.
 *
 * Revision 1.1  1996/05/03 17:36:47  johns
 * Initial revision
 *
 *-----------------------------------------------------------------------------
 */

#include <vga.h>

#define C64HSIZE	320
#define C64VSIZE	200

#ifdef OVERSCAN

#define VGAMODE		G640x480x256	/* SVGALIB graphic mode */
#define HSIZE		(1024)		/* byte_per_line of the video memory */
#define VSIZE		(C64VSIZE)

#define NEW_SVGA

#else

#define VGAMODE		G320x200x256	/* SVGALIB graphic mode */
#define HSIZE		(C64HSIZE)	/* byte_per_line of the video memory */
#define VSIZE		(C64VSIZE)

#endif

/*---------------------------------------------------------------------------*/

extern volatile int VideoIsDisplayed;	/* displayed */
extern unsigned char* VideoPointer;	/* current pointer in video memory */
extern unsigned char* graph_mem;	/* SVGALIB graphic memory */
#define VideoMemory	graph_mem	/* start pointer of video memory */

extern void	SetOverscanColor(unsigned char);

/*---------------------------------------------------------------------------*/

/*
**	Set overscan color.
*/
#define VideoSetOverscanColor(color) \
    SetOverscanColor(color)

/*
**	Update internal structures to monitor.
*/
#define VideoRefresh()

/*-----------------------------------------------------------------------------
 *	OVERSCAN dependend
 *---------------------------------------------------------------------------*/

#ifdef OVERSCAN	/* { */

/*
**	Called only for blank overscanlines.
*/
#define VideoFillOverscanLine(quad_color) \
    VideoFillLine(quad_color)

/*
**	Called only for open border overscanlines.
*/
#define VideoCopyOverscanLine(pointer) \
    VideoCopyLine(pointer)

#else	/* }{ OVERSCAN */

#define VideoFillOverscanLine(quad_color)	/* quad_color */
#define VideoCopyOverscanLine(pointer) 		/* pointer */

#endif	/* } !OVERSCAN */

/*---------------------------------------------------------------------------*/

#ifdef NEW_SVGA	/* { */
/*
**	FIXME: This code isn't optimised, just written!!!!
*/

/*
**	1 emulator pixel to video format.
*/
#define VIC2VIDEO(p) \
    (p)

/*
**	VideoPut: Put a byte into video memory.
*/
#define VideoPut(a,v) \
  do {									\
    int __x;								\
    __x=(unsigned)(a)+152-(unsigned)VideoMemory;			\
    vga_setpage(__x>>16);						\
    *(VideoMemory+(__x&0xFFFF))=(v);					\
  } while( 0 )

/*
**	Fill a scanline with 'quad_color'.
*/
#define VideoFillLine(quad_color) \
  do {									\
    int x;								\
    x=VideoPointer-VideoMemory+(108*HSIZE)+152;				\
    vga_setpage(x>>16);							\
    ((unsigned long*)(VideoMemory+(x&0xFFFF)))[0]=VicExterior;		\
    ((unsigned long*)(VideoMemory+(x&0xFFFF)))[1]=VicExterior;		\
    LongFill(VideoMemory+8+(x&0xFFFF),quad_color,C64HSIZE/4);		\
    ((unsigned long*)(VideoMemory+(x&0xFFFF)))[2+C64HSIZE/4]=VicExterior;\
    ((unsigned long*)(VideoMemory+(x&0xFFFF)))[3+C64HSIZE/4]=VicExterior;\
    VideoPointer+=HSIZE;						\
  } while( 0 )

/*
**	Copy a scanline from 'src' to video.
*/
#define VideoCopyLine(src) \
  do {									\
    int x;								\
    x=VideoPointer-VideoMemory+(108*HSIZE)+152;				\
    vga_setpage(x>>16);							\
    ((unsigned long*)(VideoMemory+(x&0xFFFF)))[0]=VicExterior;		\
    ((unsigned long*)(VideoMemory+(x&0xFFFF)))[1]=VicExterior;		\
    LongCopy(VideoMemory+8+(x&0xFFFF),src,C64HSIZE/4);			\
    ((unsigned long*)(VideoMemory+(x&0xFFFF)))[2+C64HSIZE/4]=VicExterior;\
    ((unsigned long*)(VideoMemory+(x&0xFFFF)))[3+C64HSIZE/4]=VicExterior;\
    VideoPointer+=HSIZE;						\
  } while( 0 )

#else	/* }{ NEW_SVGA */

/*
**	1 emulator pixel to video format.
*/
#define VIC2VIDEO(p) \
    (p)

/*
**	VideoPut: Put a byte into video memory.
*/
#define VideoPut(a,v) \
    (*(a)=(v))

/*
**	Fill a scanline with 'quad_color'.
*/
#define VideoFillLine(quad_color) \
  do {									\
    LongFill(VideoPointer,quad_color,C64HSIZE/4);			\
    VideoPointer+=HSIZE;						\
  } while( 0 )

/*
**	Copy a scanline from 'src' to video.
*/
#define VideoCopyLine(src) \
  do {									\
    LongCopy(VideoPointer,src,C64HSIZE/4);				\
    VideoPointer+=HSIZE;						\
  } while( 0 )

#endif	/* } !NEW_SVGA */

/*-----------------------------------------------------------------------------
 *	VIDEOSYNC support
 *---------------------------------------------------------------------------*/

#ifdef VIDEOSYNC	/* { */

extern volatile int VideoInterrupts;	/* be happy, were are quicker */

/*
**	Sync video.
*/
#define VideoSync() \
    do {							\
	while(							\
	    (VideoSyncSpeed && VideoInterrupts<VicRefreshRate)	\
	    || !VideoIsDisplayed ) {				\
		sigpause(0);					\
	}							\
	VideoInterrupts=0;					\
    } while( 0 )

#else	/* }{ VIDEOSYNC */

#define VideoSync() \
    while( !VideoIsDisplayed ) {/* must wait for display */	\
	sigpause(0);						\
    }

#endif	/* } !VIDEOSYNC */
