/*
**	The C64 emulator
**
**	Copyright 1996 by ALE.
**	written by Lutz Sammer.
**
**	Video driver for go32 (MSDOS verion of GNU-C)
**-----------------------------------------------------------------------------
** $Id: video_go32.h,v 1.1 1996/05/01 00:25:57 johns Exp root $
** $Log: video_go32.h,v $
** Revision 1.1  1996/05/01 00:25:57  johns
** Initial revision
**
**-----------------------------------------------------------------------------
*/

#define C64HSIZE	320
#define C64VSIZE	200

#undef UNIVBE

#ifdef OVERSCAN

#ifdef UNIVBE
/*
**	UNIVBE:	has a nice video mode 360x400!
*/
#define VGAMODE		0x158		/* BIOS graphic mode */
#define HSIZE		512		/* byte_per_line of the video memory */
#define VSIZE		400
#define VADD		68		/* to center emulator */
#define HADD		12		/* to center emulator */
#else
#define VGAMODE		0x101		/* BIOS graphic mode 640x480 */
#define HSIZE		1024		/* byte_per_line of the video memory */
#define VSIZE		400
#define VADD		108		/* to center emulator */
#define HADD		152		/* to center emulator */
#endif

#else

#define VGAMODE		0x13		/* BIOS graphic mode */
#define HSIZE		(C64HSIZE)	/* byte_per_line of the video memory */
#define VSIZE		(C64VSIZE)

#endif

/*---------------------------------------------------------------------------*/

extern unsigned char* VideoPointer;	/* current pointer in video memory */
#ifdef DPMI
extern unsigned int _core_select;
#define VideoMemory	((unsigned char*)0x000A0000)
#else
#define VideoMemory	((unsigned char*)0xE00A0000)
#endif

extern void	SetOverscanColor(unsigned char);

/*---------------------------------------------------------------------------*/

/*
**	Set overscan color.
*/
#define VideoSetOverscanColor(color) \
    SetOverscanColor(color)

/*
**	Update internal structures to monitor.
*/
#define VideoRefresh()

/*-----------------------------------------------------------------------------
 *	OVERSCAN dependend
 *---------------------------------------------------------------------------*/

#ifdef OVERSCAN	/* { */

/*
**	Called only for blank overscanlines.
*/
#define VideoFillOverscanLine(quad_color) \
    VideoFillLine(quad_color)

/*
**	Called only for open border overscanlines.
*/
#define VideoCopyOverscanLine(pointer) \
    VideoCopyLine(pointer)

#else	/* }{ OVERSCAN */

#define VideoFillOverscanLine(quad_color)	/* quad_color */
#define VideoCopyOverscanLine(pointer) 		/* pointer */

#endif	/* } !OVERSCAN */

/*---------------------------------------------------------------------------*/

/*
**	1 emulator pixel to video format.
*/
#define VIC2VIDEO(p) \
    (p)

#ifdef DPMI	/* { */

/*
**	COMMENT: can't use _farpokeb, didn't get compiled.
*/

/*
**	LongFill version for MSDOS with segment selector.
*/
#define dosmemlset(a,v,l) \
    asm("
	push	%%es
	movw	__core_select,%%es	/* Use real area selector */
	cld
	rep
	stosl				/* store ECX bytes to Real area */
	pop	%%es
	" : : "a" (v), "c" (l), "D" (a) : "ax", "cx", "di" )

/*
**	LongCopy version for MSDOS with segment selector.
*/
#define dosmemlmov(d,s,l) \
    asm("
	push	%%es
	movw	__core_select,%%es	/* Use real area selector */
	rep
	movsl				/* move ECX bytes to Real area */
	pop	%%es
	" : : "S" (s), "D" (d), "c" (l) : "cx", "di", "si")

#ifdef OVERSCAN	/* { */

extern void setpage(int);

/*
**	VideoPut: Put a byte into video memory.
*/
#define __VideoPut(a,v) \
    asm("
	push	%%es
	movw	__core_select,%%es	/* Use real area selector */
	stosb				/* store byte to Real area */
	pop	%%es
	" : : "a" (v), "D" (a) : "ax", "di" )

/*
**	__VideoLong: Put a long into video memory.
*/
#define __VideoLong(a,v) \
    asm("
	push	%%es
	movw	__core_select,%%es	/* Use real area selector */
	stosl				/* store byte to Real area */
	pop	%%es
	" : : "a" (v), "D" (a) : "ax", "di" )

/*
**	Setup ES.
*/
#define __VideoSetupES() \
    asm("
	push	%%es
	movw	__core_select,%%es	/* Use real area selector */
	" : : )

/*
**	Restore ES.
*/
#define __VideoRestoreES() \
    asm("
	pop	%%es
	" : : )

/*
**	VideoPut: Put a byte into video memory.
*/
#define VideoPut(a,v) \
  do {									\
    int __x;								\
    __x=(unsigned)(a)+HADD-(unsigned)VideoMemory;			\
    setpage(__x>>16);							\
    __VideoPut(VideoMemory+(__x&0xFFFF),(v));				\
  } while( 0 )

#if 0
/*
**	Fill a scanline with 'quad_color'.
*/
#define VideoFillLine(quad_color) \
  do {									\
    int x;								\
    unsigned char* p;							\
    x=VideoPointer-VideoMemory+(VADD*HSIZE)+HADD;			\
    p=VideoMemory+(x&0xFFFF);						\
    setpage(x>>16);							\
    __VideoLong(&((unsigned long*)(p))[0],VicExterior);			\
    __VideoLong(&((unsigned long*)(p))[1],VicExterior);			\
    dosmemlset(p+8,quad_color,C64HSIZE/4);				\
    __VideoLong(&((unsigned long*)(p))[2+C64HSIZE/4],VicExterior);	\
    __VideoLong(&((unsigned long*)(p))[3+C64HSIZE/4],VicExterior);	\
    VideoPointer+=HSIZE;						\
  } while( 0 )
#else
/*
**	Fill a scanline with 'quad_color'.
*/
#define VideoFillLine(quad_color) \
  do {									\
    int x;								\
    unsigned char* p;							\
    x=VideoPointer-VideoMemory+(VADD*HSIZE)+HADD;			\
    p=VideoMemory+(x&0xFFFF);						\
    setpage(x>>16);							\
    __VideoSetupES();							\
    asm("
	movl	_VicExterior,%%eax
	stosl
	stosl
	movl	%0,%%eax
	rep
	stosl				/* store ECX bytes to Real area */
	movl	_VicExterior,%%eax
	stosl
	stosl
	" : : "g" (quad_color), "c" (C64HSIZE/4), "D" (p)		\
	    : "ax", "cx", "di" );					\
    __VideoRestoreES();							\
    VideoPointer+=HSIZE;						\
  } while( 0 )

#endif

#if 0
/*
**	Copy a scanline from 'src' to video.
*/
#define VideoCopyLine(src) \
  do {									\
    int x;								\
    unsigned char* p;							\
    x=VideoPointer-VideoMemory+(VADD*HSIZE)+HADD;			\
    p=VideoMemory+(x&0xFFFF);						\
    setpage(x>>16);							\
    __VideoLong(&((unsigned long*)(p))[0],VicExterior);			\
    __VideoLong(&((unsigned long*)(p))[1],VicExterior);			\
    dosmemlmov(p+8,src,C64HSIZE/4);					\
    __VideoLong(&((unsigned long*)(p))[2+C64HSIZE/4],VicExterior);	\
    __VideoLong(&((unsigned long*)(p))[3+C64HSIZE/4],VicExterior);	\
    VideoPointer+=HSIZE;						\
  } while( 0 )
#else
/*
**	Copy a scanline from 'src' to video.
*/
#define VideoCopyLine(src) \
  do {									\
    int x;								\
    unsigned char* p;							\
    x=VideoPointer-VideoMemory+(VADD*HSIZE)+HADD;			\
    p=VideoMemory+(x&0xFFFF);						\
    setpage(x>>16);							\
    __VideoSetupES();							\
    asm("
	movl	_VicExterior,%%eax
	stosl
	stosl
	rep
	movsl				/* move ECX bytes to Real area */
	stosl
	stosl
	" : : "S" (src), "D" (p), "c" (C64HSIZE/4)			\
	    : "ax", "cx", "di", "si");					\
    __VideoRestoreES();							\
    VideoPointer+=HSIZE;						\
  } while( 0 )
#endif


#else	/* }{ OVERSCAN */

/*
**	VideoPut: Put a byte into video memory.
*/
#define VideoPut(a,v) \
    asm("
	push	%%es
	movw	__core_select,%%es	/* Use real area selector */
	stosb				/* store byte to Real area */
	pop	%%es
	" : : "a" (v), "D" (a) : "ax", "di" )

/*
**	Fill a scanline with 'quad_color'.
*/
#define VideoFillLine(quad_color) \
  do {									\
    dosmemlset(VideoPointer,quad_color,C64HSIZE/4);			\
    VideoPointer+=HSIZE;						\
  } while( 0 )

/*
**	Copy a scanline from 'src' to video.
*/
#define VideoCopyLine(src) \
  do {									\
    dosmemlmov(VideoPointer,src,C64HSIZE/4);				\
    VideoPointer+=HSIZE;						\
  } while( 0 )

#endif	/* } !OVERSCAN */

#else	/* }{ DPMI */

/*
**	Fill a scanline with 'quad_color'.
*/
#define VideoFillLine(quad_color) \
  do {									\
    LongFill(VideoPointer,quad_color,C64HSIZE/4);			\
    VideoPointer+=HSIZE;						\
  } while( 0 )

/*
**	Copy a scanline from 'src' to video.
*/
#define VideoCopyLine(src) \
  do {									\
    LongCopy(VideoPointer,src,C64HSIZE/4);				\
    VideoPointer+=HSIZE;						\
  } while( 0 )

#endif	/* } !DPMI */

/*-----------------------------------------------------------------------------
 *	VIDEOSYNC support
 *---------------------------------------------------------------------------*/

#ifdef VIDEOSYNC	/* { */

#include <sys/time.h>
#include <unistd.h>
extern long rawclock(void);

/*
**	Sync video, MSDOS hot polling.
**		BUG ALERT: Modified clock rate 50hz!
*/
#define VideoSync() \
    do {						\
	static unsigned long y;				\
	unsigned long x;				\
	if( VideoSyncSpeed ) {				\
	    do {					\
		x=rawclock();				\
	    } while( x-y<VicRefreshRate  );		\
	    y=x;					\
	}						\
    } while( 0 )

#else	/* }{ VIDEOSYNC */

#define VideoSync()			/* noop video-sync */

#endif	/* } !VIDEOSYNC */
