/*
**	The C64 emulator
**
**	Copyright 1996 by ALE.
**	written by Lutz Sammer.
**
**	Video driver for go32 (MSDOS verion of GNU-C)
**-----------------------------------------------------------------------------
** $Id: video_go32.c,v 1.3 1996/07/29 02:03:17 johns Exp root $
** $Log: video_go32.c,v $
** Revision 1.3  1996/07/29 02:03:17  johns
** Clear video memory, use VESA-SET-LOGICAL-SCAN-LINE-LENGTH with check.
**
** Revision 1.2  1996/06/09 20:04:01  johns
** Implemented Overscan support for dos.
**
** Revision 1.1  1996/05/04 00:16:37  johns
** Initial revision
**
**-----------------------------------------------------------------------------
*/

#include "config.h"

#ifdef GO32	/* { */

#include "c64.h"
#include "vic.h"
#include "sid.h"
#include "video_go32.h"

#include <stdio.h>
#include <go32.h>
#include <memory.h>
#include "int10.h"

extern void int10(REGISTERS *);

static int VideoGraphicMode;		/* Flag graphic mode on */

/*---------------------------------------------------------------------------*/

static struct {
    char Red,Green,Blue;
} CONST Palette[16] = {
    {0 , 0 , 0 },			/* 00 Black */
    {63, 63, 63},			/* 01 White */
    {39, 0 , 0 },			/* 02 Red */
    { 0, 47, 47},			/* 03 Turquoise 08 48 48 */
    {47,  0, 47},			/* 04 Violet 48 0 48 */
    {0,  39, 0 },			/* 05 Green */
    {0,  0,  39},			/* 06 Blue */
    {63, 63, 0 },			/* 07 Yellow */
    {63, 22, 0 },			/* 08 Orange 63 22 0 */
    {30, 14, 0 },			/* 09 Brown  31 15 0 */
    {63, 0 , 0 },			/* 0A Lite Red */
    {15, 15, 15},			/* 0B Gray 1 */
    {31, 31, 31},			/* 0C Gray 2 */
    {0,  63, 0 },			/* 0D Lite Green */
    {0,  0,  63},			/* 0E Lite Blue */
    {47, 47, 47} 			/* 0F Gray 3 */
};

/*
**	Load my own palette into DAC.
*/
static void InitPalette()
{
    int i;

    outb(0x3C8,0);
    for( i=0; i<256; ++i ) {
	outb(0x3C9,Palette[i&0xF].Red);
	outb(0x3C9,Palette[i&0xF].Green);
	outb(0x3C9,Palette[i&0xF].Blue);
    }
}


/*
**	Set asyncron overscan color.
*/
void SetOverscanColor(unsigned char c)
{
    inb(0x3DA);
    outb(0x3C0,0x31);
    outb(0x3C0,c);
}

/*---------------------------------------------------------------------------*/

#ifdef OVERSCAN

static int OldPage;

/*
**	Vesa page switch.
*/
void setpage(int page)
{
    REGISTERS rg;
    if( page==OldPage ) {
	return;
    }
    OldPage=page;
    memset(&rg,0,sizeof(rg));
    rg.ax=0x4F05;			/* VESA-CPU-MEMORY-CONTROL */
    rg.bx=0x0000;
    rg.dx=page;
    int10(&rg);
}

#endif

/*
**	Setup my vga-mode.
*/
static void SetupVideoMode(void)
{
    REGISTERS rg;
/*
    GrSetMode(GR_320_200_graphics);
*/
#ifdef OVERSCAN
    memset(&rg,0,sizeof(rg));
    rg.ax=0x4F02;			/* VESA-VIDEOMODE */
    rg.bx=VGAMODE;
    int10(&rg);
    if( rg.ax!=0x4F ) {
	printf("Failed set VIDEOMODE %02X\n",VGAMODE);
	Exit(-1);
    }

    rg.ax=0x4F06;			/* VESA-LOGICAL-SCAN-LINE-LENGTH */
    rg.bx=0;
    rg.cx=HSIZE;			/* in pixels !! */
    int10(&rg);
    if( rg.ax!=0x4F || rg.cx!=HSIZE ) {
	printf("Failed set LOGICAL-SCAN-LINE-LENGTH %d\n",HSIZE);
	printf("Current line length %d = %d bytes\n",rg.cx,rg.bx);

	/*
	**	Must doit by my own.
	*/
	outb(0x3D4,0x13);
	outb(0x3D5,(HSIZE>>3));		/* LINE-LENGTH */
    }

    OldPage=-1;

    {
	int i;
	for( i=0; i<8; ++i ) {
	    setpage(i);
	    dosmemlset(VideoMemory,0x00000000,(64*1024)/4);
	}
    }
#else
    memset(&rg,0,sizeof(rg));
    rg.ax=VGAMODE;
    int10(&rg);
#endif
}

/*---------------------------------------------------------------------------*/

/*
**	Setup video card for C64 emulator.
*/
void EnterVideo(int argc,char** argv,char* geometry)
{
    if( VideoGraphicMode ) {
	return;
    }
    SetupVideoMode();
    InitPalette();

#ifdef VIDEOSYNC
    if( VideoSyncSpeed ) {
	/*
	**	To support videosync, I must change TIMER0 to 50/60 Hz
	*/
	/*  8253 frq: f=1193180/frq Hz */
	outb(0x40,(119318000/FRAMES_PER_SECOND)/VideoSyncSpeed);
	outb(0x40,((119318000/FRAMES_PER_SECOND)/VideoSyncSpeed)>>8);
	/* FIXME: Must change timer!!! */
	/* setup timer irq wrapper and chain to old */
    }
#endif

    VideoGraphicMode=1;
}

/*
**	Restore video card.
*/
void LeaveVideo(void)
{
    REGISTERS rg;

    if( VideoGraphicMode ) {
/*
	GrSetMode(GR_default_text);
*/
	memset(&rg,0,sizeof(rg));
	rg.ax=0x03;
	int10(&rg);

	VideoGraphicMode=0;
    }
}

/*
**	Suspend video.
*/
void SuspendVideo(void)
{
    LeaveVideo();
}

/*
**	Resume video.
*/
void ResumeVideo(void)
{
    if( VideoGraphicMode ) {
	return;
    }
    SetupVideoMode();
    InitPalette();

    VideoGraphicMode=1;
    VicOverscanColor=-1;
    /*
    **	Contents automatic restored after 1/50s or 1/60s.
    */
}

#endif	/* } GO32 */
