/*
**	The C64 emulator
**
**	Copyright 1996 by ALE.
**	written by Lutz Sammer.
**
**-----------------------------------------------------------------------------
** $Id: vic.h,v 1.2 1996/07/13 00:49:46 johns Exp root $
** $Log: vic.h,v $
** Revision 1.2  1996/07/13 00:49:46  johns
** Corrected prototypes.
**
** Revision 1.1  1996/05/12 21:10:30  johns
** Initial revision
**
**-----------------------------------------------------------------------------
*/

#ifndef __VIC_H__	/* { */
#define __VIC_H__

/*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*/

#define NEW_SPRITES			/* try of new faster sprites */

/*
**	Until I find the correct value, this is a variable.
*/
#define VIC_FETCH	VicFetch	/* Vic fetch position */

extern	unsigned	VicAction;
extern	int		VicEmulateRate;
extern	int		VicRefreshRate;
extern	int		VicOverscanColor;
extern	unsigned char*	VicBank;
extern	unsigned char*	VicVRam;
extern	unsigned char*	VicBRam;
extern	unsigned char*	VicCRam;
extern	int		VicFetch;
extern	int		VicFetchAdd;

extern	unsigned char*	VicColorRam;
extern	int		VicOffset;
extern	int		VicYOffset;
extern	int		VicXOffset;
extern	int		VicRasterLine;
extern	int		VicScanLine;
extern	int		VicIrqRasterLine;
extern	unsigned	VicIrqAction;
extern	int		VicLastSprite;

extern	unsigned long	VicExterior;
extern	unsigned long	VicBackground0;
extern	unsigned long	VicBackground1;
extern	unsigned long	VicBackground2;
extern	unsigned long	VicBackground3;

extern	void		(*VicDisplayLine)(void);

extern	struct sprite {
    int X;				/* X Coordinate */
    int Y;				/* Y Coordinate */
    int Counter;			/* Displayed/DMA counter */
    unsigned long Color;		/* Sprite color */
#ifdef NEW_SPRITES
    int Advance;			/* Advance pointer */
#else
    int Stop;				/* Stop display */
#endif
} VicSprite[8];

extern unsigned char	VicSpriteDMA[];	/* sprite dma flags */
extern CONST unsigned long	QuadNibble[256];	/* Nibble quad.. */
extern	unsigned char	DispBuf[8+24+320+48 +8];
extern void (*VerticalRetraceHook)(void);/* Insert vertical retrace functions*/
extern void VerticalRetraceNoop(void);	/* vertical retrace noop */
extern char VicDrawOverscan;		/* redraw overscan area */
extern	int		VideoSyncSpeed;

/*
**	Video driver interface.
*/
extern	void	EnterVideo		(int,char**,char*);
extern	void	LeaveVideo		(void);
extern	void	SuspendVideo		(void);
extern	void	ResumeVideo		(void);

/*
**	Video:	vic.c
*/
extern	void	LedOn			(void);
extern	void	LedOff			(void);
extern	void	LedFlash		(void);

extern	void	TextDL			(void);
extern	void	MultiColorTextDL	(void);
extern	void	ExtendedColorTextDL	(void);
extern	void	BitmapDL		(void);
extern	void	MultiColorBitmapDL	(void);
extern	void	IllegalDL		(void);
extern	void	EmulRasterLineIrq	(void);
extern	void	(*EmulVic)		(void);
extern	void	EnterVic		(void);
extern	void	LeaveVic		(void);
extern	void	VicInfo			(void);

extern	void	VicText			(int,int,unsigned char*);
extern	void	VicMessage		(const char*,int);
extern	void	VicReset		(void);

/*
**	Sprites:	mob.c
*/
extern	void	Sprite2CI	(int,unsigned char CONST*,unsigned long*);
extern	void	Sprite2CDI	(int,unsigned char CONST*,unsigned short*);
extern	void	Sprite4CI	(int,unsigned char CONST*,unsigned short*);
extern	void	Sprite4CDI	(int,unsigned char CONST*,unsigned long*);
extern	void	Sprite2CB	(int,unsigned char CONST*,unsigned char*);
extern	void	Sprite2CDB	(int,unsigned char CONST*,unsigned char*);
extern	void	Sprite4CB	(int,unsigned char CONST*,unsigned char*);
extern	void	Sprite4CDB	(int,unsigned char CONST*,unsigned char*);
extern	void	Sprite		(int);

#endif /* } !__VIC_H__ */
