/*
**	The C64 emulator
**
**	Copyright 1996 by ALE.
**	written by Lutz Sammer.
**
**	Sid emulator header file.
**-----------------------------------------------------------------------------
** $Id: sid.h,v 1.1 1996/05/17 16:46:09 johns Exp root $
** $Log: sid.h,v $
** Revision 1.1  1996/05/17 16:46:09  johns
** Initial revision
**
**-----------------------------------------------------------------------------
*/

#ifndef __SID_H__	/* { */
#define __SID_H__

enum SidState {
    SID_OFF,
    SID_ATTACK,
    SID_DECAY,
    SID_SUSTAIN,
    SID_RELEASE,
};

extern	struct voice {
    int			On;		/* Flag TRUE: voice on */
    enum SidState	State;		/* State of channel */
    unsigned		Cycle;		/* Cycle of last state change */
} SidVoice[3];

extern	int	SidSoundOff;		/* Sound turned off */
extern	int	SidCycle;		/* Cycle until sid is handled */

/*
**	Sound:		sid.c
*/
extern	int	SidEnvelope	(int);
extern	void	SidInfo		(void);
extern	void	SidReset	(void);

#ifdef SID_NONE	/* { */

#define LeaveSound()
#define EnterSound()
#define SuspendSound()
#define ResumeSound()
#define EmulSid()
#define ToggleSound()

#else	/* }{ SID_NONE */

extern	void	EnterSound	(void);
extern	void	LeaveSound	(void);
extern	void	SuspendSound	(void);
extern	void	ResumeSound	(void);
extern	void	ToggleSound	(void);
extern	void	EmulSid		(void);

#endif	/* } !SID_NONE */

#if !defined(SID_OPL3) && !defined(SID_DSP)	/* { */

/*
**	Device driver hooks.
*/
#define SidFrqLo(voice,value)
#define SidFrqHi(voice,value)
#define SidPulLo(voice,value)
#define SidPulHi(voice,value)
#define SidCtrl(voice,value)
#define SidAtkDcy(voice,value)
#define SidStnRls(voice,value)
#define SidVolume(value)
#define SidWavRd()
#define SidEnvRd()

#endif	/* } !SID_OPL3 */

#if defined(SID_OPL3)	/* { */

/*
**	AdLib port.
*/
#define FM_PORT	0x388
#define SidWavRd()
#define SidEnvRd()

#endif	/* } SID_OPL3 */

#ifndef SidFrqLo
/*
**	Device driver hooks.
*/
extern void SidFrqLo(int,int);
extern void SidFrqHi(int,int);
extern void SidPulLo(int,int);
extern void SidPulHi(int,int);
extern void SidCtrl(int,int);
extern void SidAtkDcy(int,int);
extern void SidStnRls(int,int);
extern void SidVolume(int);
#endif

#ifndef SidWavRd
extern void SidWavRd();
extern void SidEnvRd();
#endif

#endif	/* } !__SID_H__ */
