

#include <stdio.h>

#define VERSION "XXXX"
#define PIC8	8
#define PIC24	24
#define MONO(r,g,b)	((r+g+b)/3)

/*******************************************/
int WritePBM(fp,pic,ptype,w,h,rmap,gmap,bmap,numcols,colorstyle,raw,comment)
     FILE *fp;
     unsigned char *pic;
     int   ptype, w,h;
     unsigned char *rmap, *gmap, *bmap;
     int   numcols, colorstyle, raw;
     char *comment;
{
  /* writes a PBM/PGM/PPM file to the already open stream
     if (raw), writes as RAW bytes, otherwise writes as ASCII
     'colorstyle' single-handedly determines the type of file written
     if colorstyle==0, (Full Color) a PPM file is written
     if colorstyle==1, (Greyscale)  a PGM file is written
     if colorstyle==2, (B/W stipple) a PBM file is written */

  int   magic;
  unsigned char *pix;
  int   i,j,len;

  /* calc the appropriate magic number for this file type */
  magic = 0;
  if      (colorstyle==0) magic = 3;
  else if (colorstyle==1) magic = 2;
  else if (colorstyle==2) magic = 1;

  if (raw && magic) magic+=3;


  /* write the header info */
  fprintf(fp,"P%d\n",magic);
  fprintf(fp,"# CREATOR: C64 Emulator %s\n",VERSION);

  if (comment) {      /* write comment lines */
    char *sp;

    sp = comment;
    while (*sp) {
      fprintf(fp, "# ");
      while (*sp && *sp != '\n') fputc(*sp++, fp);
      if (*sp == '\n') sp++;
      fputc('\n', fp);
    }
  }


  fprintf(fp,"%d %d\n",w,h);
  if (colorstyle!=2) fprintf(fp,"255\n");

  if (ferror(fp)) return -1;

  /* write the image data */

  if (colorstyle==0) {                  /* 24bit RGB, 3 bytes per pixel */
    for (i=0, pix=pic, len=0; i<h; i++) {
      for (j=0; j<w; j++) {
	if (raw) {
	  if (ptype==PIC8) {
	    putc(rmap[*pix],fp);  putc(gmap[*pix],fp);  putc(bmap[*pix],fp);
	  }
	  else {  /* PIC24 */
	    putc(pix[0],fp);  putc(pix[1],fp);  putc(pix[2],fp);
	  }
	}
	else {
	  if (ptype==PIC8)
	    fprintf(fp,"%3d %3d %3d ",rmap[*pix], gmap[*pix], bmap[*pix]);
	  else
	    fprintf(fp,"%3d %3d %3d ",pix[0], pix[1], pix[2]);

	  len+=12;
	  if (len>58) { fprintf(fp,"\n");  len=0; }
	}

	pix += (ptype==PIC24) ? 3 : 1;
      }
    }
  }


  else if (colorstyle==1) {             /* 8-bit greyscale */
    unsigned char rgb[256];
    if (ptype==PIC8)
      for (i=0; i<numcols; i++) rgb[i] = MONO(rmap[i],gmap[i],bmap[i]);

    for (i=0, pix=pic, len=0; i<w*h; i++) {

      if (raw) putc((ptype==PIC8) ? rgb[*pix] : MONO(pix[0],pix[1],pix[2]),fp);

      else {
	if (ptype==PIC8) fprintf(fp,"%3d ",rgb[*pix]);
	            else fprintf(fp,"%3d ",MONO(pix[0],pix[1],pix[2]));
	len += 4;
	if (len>66) { fprintf(fp,"\n");  len=0; }
      }

      pix += (ptype==PIC24) ? 3 : 1;
    }
  }

  else if (colorstyle==2) {             /* 1-bit B/W stipple */
    int bit,k,flipbw;
    char *str0, *str1;

    /* shouldn't happen */
    if (ptype == PIC24) abort(/*"PIC24 and B/W Stipple in WritePBM()\n"*/);

    /* if '0' is black, set flipbw */
    flipbw = (MONO(rmap[0],gmap[0],bmap[0]) < MONO(rmap[1],gmap[1],bmap[1]));

    str0 = (flipbw) ? "1 " : "0 ";
    str1 = (flipbw) ? "0 " : "1 ";

    for (i=0, pix=pic, len=0; i<h; i++) {
      for (j=0, bit=0, k=0; j<w; j++, pix++) {
	if (raw) {
	  k = (k << 1) | *pix;
	  bit++;
	  if (bit==8) {
	    if (flipbw) k = ~k;
	    fputc(k,fp);
	    bit = k = 0;
	  }
	}
	else {
	  if (*pix) fprintf(fp,str1);
	       else fprintf(fp,str0);
	  len+=2;
	  if (len>68) { fprintf(fp,"\n"); len=0; }
	}
      } /* j */
      if (raw && bit) {
	k = k << (8-bit);
	if (flipbw) k = ~k;
	fputc(k,fp);
      }
    }
  }

  if (ferror(fp)) return -1;

  return 0;
}

unsigned char RMAP[256] = {
    0 , 63, 39, 0, 47, 0,  0,  63, 63, 30, 63, 15, 31, 0,  0,  47,
    0 , 63, 39, 0, 47, 0,  0,  63, 63, 30, 63, 15, 31, 0,  0,  47,
    0 , 63, 39, 0, 47, 0,  0,  63, 63, 30, 63, 15, 31, 0,  0,  47,
    0 , 63, 39, 0, 47, 0,  0,  63, 63, 30, 63, 15, 31, 0,  0,  47,
    0 , 63, 39, 0, 47, 0,  0,  63, 63, 30, 63, 15, 31, 0,  0,  47,
    0 , 63, 39, 0, 47, 0,  0,  63, 63, 30, 63, 15, 31, 0,  0,  47,
    0 , 63, 39, 0, 47, 0,  0,  63, 63, 30, 63, 15, 31, 0,  0,  47,
    0 , 63, 39, 0, 47, 0,  0,  63, 63, 30, 63, 15, 31, 0,  0,  47,
    0 , 63, 39, 0, 47, 0,  0,  63, 63, 30, 63, 15, 31, 0,  0,  47,
    0 , 63, 39, 0, 47, 0,  0,  63, 63, 30, 63, 15, 31, 0,  0,  47,
    0 , 63, 39, 0, 47, 0,  0,  63, 63, 30, 63, 15, 31, 0,  0,  47,
    0 , 63, 39, 0, 47, 0,  0,  63, 63, 30, 63, 15, 31, 0,  0,  47,
    0 , 63, 39, 0, 47, 0,  0,  63, 63, 30, 63, 15, 31, 0,  0,  47,
    0 , 63, 39, 0, 47, 0,  0,  63, 63, 30, 63, 15, 31, 0,  0,  47,
    0 , 63, 39, 0, 47, 0,  0,  63, 63, 30, 63, 15, 31, 0,  0,  47,
    0 , 63, 39, 0, 47, 0,  0,  63, 63, 30, 63, 15, 31, 0,  0,  47
};

unsigned char GMAP[256] = {
     0 , 63, 0 , 47, 0, 39, 0, 63, 22, 14, 0 , 15, 31, 63, 0, 47,
     0 , 63, 0 , 47, 0, 39, 0, 63, 22, 14, 0 , 15, 31, 63, 0, 47,
     0 , 63, 0 , 47, 0, 39, 0, 63, 22, 14, 0 , 15, 31, 63, 0, 47,
     0 , 63, 0 , 47, 0, 39, 0, 63, 22, 14, 0 , 15, 31, 63, 0, 47,
     0 , 63, 0 , 47, 0, 39, 0, 63, 22, 14, 0 , 15, 31, 63, 0, 47,
     0 , 63, 0 , 47, 0, 39, 0, 63, 22, 14, 0 , 15, 31, 63, 0, 47,
     0 , 63, 0 , 47, 0, 39, 0, 63, 22, 14, 0 , 15, 31, 63, 0, 47,
     0 , 63, 0 , 47, 0, 39, 0, 63, 22, 14, 0 , 15, 31, 63, 0, 47,
     0 , 63, 0 , 47, 0, 39, 0, 63, 22, 14, 0 , 15, 31, 63, 0, 47,
     0 , 63, 0 , 47, 0, 39, 0, 63, 22, 14, 0 , 15, 31, 63, 0, 47,
     0 , 63, 0 , 47, 0, 39, 0, 63, 22, 14, 0 , 15, 31, 63, 0, 47,
     0 , 63, 0 , 47, 0, 39, 0, 63, 22, 14, 0 , 15, 31, 63, 0, 47,
     0 , 63, 0 , 47, 0, 39, 0, 63, 22, 14, 0 , 15, 31, 63, 0, 47,
     0 , 63, 0 , 47, 0, 39, 0, 63, 22, 14, 0 , 15, 31, 63, 0, 47,
     0 , 63, 0 , 47, 0, 39, 0, 63, 22, 14, 0 , 15, 31, 63, 0, 47,
     0 , 63, 0 , 47, 0, 39, 0, 63, 22, 14, 0 , 15, 31, 63, 0, 47
};

unsigned char BMAP[256] = {
     0, 63, 0 , 47, 47, 0 , 39, 0 , 0 , 0 , 0 , 15, 31, 0 , 63, 47,
     0, 63, 0 , 47, 47, 0 , 39, 0 , 0 , 0 , 0 , 15, 31, 0 , 63, 47,
     0, 63, 0 , 47, 47, 0 , 39, 0 , 0 , 0 , 0 , 15, 31, 0 , 63, 47,
     0, 63, 0 , 47, 47, 0 , 39, 0 , 0 , 0 , 0 , 15, 31, 0 , 63, 47,
     0, 63, 0 , 47, 47, 0 , 39, 0 , 0 , 0 , 0 , 15, 31, 0 , 63, 47,
     0, 63, 0 , 47, 47, 0 , 39, 0 , 0 , 0 , 0 , 15, 31, 0 , 63, 47,
     0, 63, 0 , 47, 47, 0 , 39, 0 , 0 , 0 , 0 , 15, 31, 0 , 63, 47,
     0, 63, 0 , 47, 47, 0 , 39, 0 , 0 , 0 , 0 , 15, 31, 0 , 63, 47,
     0, 63, 0 , 47, 47, 0 , 39, 0 , 0 , 0 , 0 , 15, 31, 0 , 63, 47,
     0, 63, 0 , 47, 47, 0 , 39, 0 , 0 , 0 , 0 , 15, 31, 0 , 63, 47,
     0, 63, 0 , 47, 47, 0 , 39, 0 , 0 , 0 , 0 , 15, 31, 0 , 63, 47,
     0, 63, 0 , 47, 47, 0 , 39, 0 , 0 , 0 , 0 , 15, 31, 0 , 63, 47,
     0, 63, 0 , 47, 47, 0 , 39, 0 , 0 , 0 , 0 , 15, 31, 0 , 63, 47,
     0, 63, 0 , 47, 47, 0 , 39, 0 , 0 , 0 , 0 , 15, 31, 0 , 63, 47,
     0, 63, 0 , 47, 47, 0 , 39, 0 , 0 , 0 , 0 , 15, 31, 0 , 63, 47,
     0, 63, 0 , 47, 47, 0 , 39, 0 , 0 , 0 , 0 , 15, 31, 0 , 63, 47
};

#if 0
unsigned char VMEM[320*200];

main()
{
    WritePBM(stdout,VMEM,PIC8,320,200,RMAP,GMAP,BMAP,8,0,1,"Hallo");
}
#endif
