/*
**	The C64 emulator
**
**	Copyright 1996 by ALE.
**	written by Lutz Sammer.
**
**	OPL3 sound driver header file.
**-----------------------------------------------------------------------------
** $Id: $
** $Log: $
**
**-----------------------------------------------------------------------------
*/

#ifndef __OPL3_H__	/* { */
#define __OPL3_H__

/* ripped out of kernel sound driver */

/*
**	AdLib mono port.
*/
#define FM_PORT	0x388

/*
**	AdLib ports delays.
*/
#define DELAY1() \
    do{						\
	int i;					\
	for( i=0; i<(IsOpl3 ? 2 : 6); ++i ) {	\
	    inb(FM_PORT);			\
	}					\
    }while( 0 )

#define DELAY2() \
    do{						\
	int i;					\
	for( i=0; i<(IsOpl3 ? 2 : 36); ++i ) {	\
	    inb(FM_PORT);			\
	}					\
    }while( 0 )

/*
**	Channels and operators.
**		Channel        1   2   3   4   5   6   7   8   9
**		Operator 1    00  01  02  08  09  0A  10  11  12
**		Operator 2    03  04  05  0B  0C  0D  13  14  15
*/
#define C1OP1	0x00
#define C1OP2	0x03
#define C2OP1	0x01
#define C2OP2	0x04
#define C3OP1	0x02
#define C3OP2	0x05
#define C4OP1	0x08
#define C4OP2	0x0B
#define C5OP1	0x09
#define C5OP2	0x0C
#define C6OP1	0x0A
#define C6OP2	0x0D
#define C7OP1	0x10
#define C7OP2	0x13
#define C8OP1	0x11
#define C8OP2	0x14
#define C9OP1	0x12
#define C9OP2	0x15

/*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*/

/*
**	Register numbers for the global registers
*/

#define TEST_REGISTER				0x01
#define   ENABLE_WAVE_SELECT		0x20

#define TIMER1_REGISTER				0x02
#define TIMER2_REGISTER				0x03
#define TIMER_CONTROL_REGISTER			0x04	/* Left side */
#define   IRQ_RESET			0x80
#define   TIMER1_MASK			0x40
#define   TIMER2_MASK			0x20
#define   TIMER1_START			0x01
#define   TIMER2_START			0x02

#define CONNECTION_SELECT_REGISTER		0x04	/* Right side */
#define   RIGHT_4OP_0			0x01
#define   RIGHT_4OP_1			0x02
#define   RIGHT_4OP_2			0x04
#define   LEFT_4OP_0			0x08
#define   LEFT_4OP_1			0x10
#define   LEFT_4OP_2			0x20

#define OPL3_MODE_REGISTER			0x05	/* Right side */
#define   OPL3_ENABLE			0x01
#define   OPL4_ENABLE			0x02

#define KBD_SPLIT_REGISTER			0x08	/* Left side */
#define   COMPOSITE_SINE_WAVE_MODE	0x80		/* Don't use with OPL-3? */
#define   KEYBOARD_SPLIT		0x40

#define PERCUSSION_REGISTER			0xbd	/* Left side only */
#define   TREMOLO_DEPTH			0x80
#define   VIBRATO_DEPTH			0x40
#define	  PERCUSSION_ENABLE		0x20
#define   BASSDRUM_ON			0x10
#define   SNAREDRUM_ON			0x08
#define   TOMTOM_ON			0x04
#define   CYMBAL_ON			0x02
#define   HIHAT_ON			0x01

/*
 *	Offsets to the register banks for operators. To get the
 *	register number just add the operator offset to the bank offset
 *
 *	AM/VIB/EG/KSR/Multiple (0x20 to 0x35)
 */
#define AM_VIB					0x20
#define   TREMOLO_ON			0x80
#define   VIBRATO_ON			0x40
#define   SUSTAIN_ON			0x20
#define   KSR				0x10 	/* Key scaling rate */
#define   MULTIPLE_MASK		0x0f	/* Frequency multiplier */

/*
 * Sustain level / Release rate (0x80 to 0x95)
 */
#define SUSTAIN_RELEASE				0x80
#define   SUSTAIN_MASK			0xf0
#define   RELEASE_MASK			0x0f

/*
 * Wave select (0xE0 to 0xF5)
 */
#define WAVE_SELECT			0xe0

/*
 *	Offsets to the register banks for voices. Just add to the
 *	voice number to get the register number.
 *
 *	F-Number low bits (0xA0 to 0xA8).
 */
#define FNUM_LOW				0xa0

/*
 *	F-number high bits / Key on / Block (octave) (0xB0 to 0xB8)
 */
#define KEYON_BLOCK					0xb0
#define	  KEYON_BIT				0x20
#define	  BLOCKNUM_MASK				0x1c
#define   FNUM_HIGH_MASK			0x03

/*
 *	Feedback / Connection (0xc0 to 0xc8)
 *
 *	These registers have two new bits when the OPL-3 mode
 *	is selected. These bits controls connecting the voice
 *	to the stereo channels. For 4 OP voices this bit is
 *	defined in the second half of the voice (add 3 to the
 *	register offset).
 *
 *	For 4 OP voices the connection bit is used in the
 *	both halfs (gives 4 ways to connect the operators).
 */
#define FEEDBACK_CONNECTION				0xc0
#define   FEEDBACK_MASK				0x0e	/* Valid just for 1st OP of a voice */
#define   CONNECTION_BIT			0x01
/*
 *	In the 4 OP mode there is four possible configurations how the
 *	operators can be connected together (in 2 OP modes there is just
 *	AM or FM). The 4 OP connection mode is defined by the rightmost
 *	bit of the FEEDBACK_CONNECTION (0xC0-0xC8) on the both halfs.
 *
 *	First half	Second half	Mode
 *
 *					 +---+
 *					 v   |
 *	0		0		>+-1-+--2--3--4-->
 *
 *
 *
 *					 +---+
 *					 |   |
 *	0		1		>+-1-+--2-+
 *						  |->
 *					>--3----4-+
 *
 *					 +---+
 *					 |   |
 *	1		0		>+-1-+-----+
 *						   |->
 *					>--2--3--4-+
 *
 *					 +---+
 *					 |   |
 *	1		1		>+-1-+--+
 *						|
 *					>--2--3-+->
 *						|
 *					>--4----+
 */
#define   STEREO_BITS				0x30	/* OPL-3 only */
#define     VOICE_TO_LEFT		0x10
#define     VOICE_TO_RIGHT		0x20

/*---------------------------------------------------------------------------*/

/*
**	KSL Key Scaling Level/Total level (0x40 to 0x55)
**		Volume: 0x00 loudest 0x3F softest!
*/
#define KSL_LEVEL			0x40
#define   KSL_MASK		0xC0	/* Envelope scaling bits */
#define   TOTAL_LEVEL_MASK	0x3F	/* Strength (volume) of OP */

/*
**	Attack / Decay rate (0x60 to 0x75)
**		Attack: 0x0 slowest - 0xF the fastest
**		Decay: 0x0 slowest - 0xF the fastest
*/
#define ATTACK_DECAY			0x60
#define   ATTACK_MASK		0xF0
#define   DECAY_MASK		0x0F

#endif	/* } !__OPL3_H__	*/
