/*
 *	The C64 emulator
 *
 *	Copyright 1992-96 by ALE.
 *	written by Lutz Sammer.
 *
 *	Mob - Sprite routines
 *------------------------------------------------------------------------------
 * $Id: mob.c,v 1.7 1996/07/21 16:09:57 johns Exp root $
 * $Log: mob.c,v $
 * Revision 1.7  1996/07/21 16:09:57  johns
 * Fixed bug: X tested only once.
 *
 * Revision 1.6  1995/02/13  11:27:22  ari
 * second linux port ( by ari ) integration
 *
 * Revision 1.5  1993/08/31  20:30:03  johns
 * go32 initial support
 *
 * Revision 1.4  1993/01/05  12:41:24  johns
 * Checkin before applying wuebbel patches
 *
 * Revision 1.3  1992/07/28  19:47:42  johns
 * Sprite routines speeded up.
 *
 * Revision 1.2  1992/07/20  04:23:33  johns
 * Missing functions for sprites behind written.
 * Byte oriented sprite functions for other machines written.
 * Correct cycle stealing for sprites written. Improved speed with sprites.
 *
 * Revision 1.1  1992/07/11  21:52:24  johns
 * Initial revision
 *
 *------------------------------------------------------------------------------
 */

#include "c64.h"
#include "vic.h"

/*
**	Sprites display modes:
**		2 Color sprite 1* Infront
**		2 Color sprite 2* Infront
**		4 Color sprite 1* Infront
**		4 Color sprite 2* Infront
**		2 Color sprite 1* Behind
**		2 Color sprite 2* Behind
**		4 Color sprite 1* Behind
**		4 Color sprite 2* Behind
*/

/*
**	FIXME:
**		Sprite priority: 7 6 5 4 3 2 1 0
**		Sprite mixed with priority and none.
**		Sprite 7 non visibile because of hide of Sprite 0
**			( Sprite 0 is behind )
**
**	Sprite 0	first	MMMbcccc
**
**	Video  -> Buffer \
**			  }- Combine -> Display
**	Sprite -> Buffer /
*/

/*
**	Video-data -> Sprite collision	XXXB CCCC
**	XXX	Sprite-number
**	B	Background data
**	CCCC	Color
*/
static CONST unsigned char Bits[256] = {
    0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00, /* 00 */
    0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00, /* 10 */
    0x02, 0x02, 0x02, 0x02,  0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02,  0x02, 0x02, 0x02, 0x02, /* 20 */
    0x02, 0x02, 0x02, 0x02,  0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02,  0x02, 0x02, 0x02, 0x02, /* 30 */
    0x04, 0x04, 0x04, 0x04,  0x04, 0x04, 0x04, 0x04,
    0x04, 0x04, 0x04, 0x04,  0x04, 0x04, 0x04, 0x04, /* 40 */
    0x04, 0x04, 0x04, 0x04,  0x04, 0x04, 0x04, 0x04,
    0x04, 0x04, 0x04, 0x04,  0x04, 0x04, 0x04, 0x04, /* 50 */
    0x08, 0x08, 0x08, 0x08,  0x08, 0x08, 0x08, 0x08,
    0x08, 0x08, 0x08, 0x08,  0x08, 0x08, 0x08, 0x08, /* 60 */
    0x08, 0x08, 0x08, 0x08,  0x08, 0x08, 0x08, 0x08,
    0x08, 0x08, 0x08, 0x08,  0x08, 0x08, 0x08, 0x08, /* 70 */
    0x10, 0x10, 0x10, 0x10,  0x10, 0x10, 0x10, 0x10,
    0x10, 0x10, 0x10, 0x10,  0x10, 0x10, 0x10, 0x10, /* 80 */
    0x10, 0x10, 0x10, 0x10,  0x10, 0x10, 0x10, 0x10,
    0x10, 0x10, 0x10, 0x10,  0x10, 0x10, 0x10, 0x10, /* 90 */
    0x20, 0x20, 0x20, 0x20,  0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20,  0x20, 0x20, 0x20, 0x20, /* A0 */
    0x20, 0x20, 0x20, 0x20,  0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20,  0x20, 0x20, 0x20, 0x20, /* B0 */
    0x40, 0x40, 0x40, 0x40,  0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40,  0x40, 0x40, 0x40, 0x40, /* C0 */
    0x40, 0x40, 0x40, 0x40,  0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40,  0x40, 0x40, 0x40, 0x40, /* D0 */
    0x80, 0x80, 0x80, 0x80,  0x80, 0x80, 0x80, 0x80,
    0x80, 0x80, 0x80, 0x80,  0x80, 0x80, 0x80, 0x80, /* E0 */
    0x80, 0x80, 0x80, 0x80,  0x80, 0x80, 0x80, 0x80,
    0x80, 0x80, 0x80, 0x80,  0x80, 0x80, 0x80, 0x80, /* F0 */
};

/*
**	Video-data -> New video data
**
**	XXXB CCCC -> xxxBcccc	New sprite number xxx + sprite color cccc
**	XXX0 CCCC -> xxx0CCCC	New sprite number xxx + old color
*/
static CONST unsigned char BgTrans[256] = {
    0x00, 0x01, 0x02, 0x03,  0x04, 0x05, 0x06, 0x07,
    0x08, 0x09, 0x0A, 0x0B,  0x0C, 0x0D, 0x0E, 0x0F, /* 00 */
    0x10, 0x10, 0x10, 0x10,  0x10, 0x10, 0x10, 0x10,
    0x10, 0x10, 0x10, 0x10,  0x10, 0x10, 0x10, 0x10, /* 10 */
    0x00, 0x01, 0x02, 0x03,  0x04, 0x05, 0x06, 0x07,
    0x08, 0x09, 0x0A, 0x0B,  0x0C, 0x0D, 0x0E, 0x0F, /* 20 */
    0x10, 0x10, 0x10, 0x10,  0x10, 0x10, 0x10, 0x10,
    0x10, 0x10, 0x10, 0x10,  0x10, 0x10, 0x10, 0x10, /* 30 */
    0x00, 0x01, 0x02, 0x03,  0x04, 0x05, 0x06, 0x07,
    0x08, 0x09, 0x0A, 0x0B,  0x0C, 0x0D, 0x0E, 0x0F, /* 40 */
    0x10, 0x10, 0x10, 0x10,  0x10, 0x10, 0x10, 0x10,
    0x10, 0x10, 0x10, 0x10,  0x10, 0x10, 0x10, 0x10, /* 50 */
    0x00, 0x01, 0x02, 0x03,  0x04, 0x05, 0x06, 0x07,
    0x08, 0x09, 0x0A, 0x0B,  0x0C, 0x0D, 0x0E, 0x0F, /* 60 */
    0x10, 0x10, 0x10, 0x10,  0x10, 0x10, 0x10, 0x10,
    0x10, 0x10, 0x10, 0x10,  0x10, 0x10, 0x10, 0x10, /* 70 */
    0x00, 0x01, 0x02, 0x03,  0x04, 0x05, 0x06, 0x07,
    0x08, 0x09, 0x0A, 0x0B,  0x0C, 0x0D, 0x0E, 0x0F, /* 80 */
    0x10, 0x10, 0x10, 0x10,  0x10, 0x10, 0x10, 0x10,
    0x10, 0x10, 0x10, 0x10,  0x10, 0x10, 0x10, 0x10, /* 90 */
    0x00, 0x01, 0x02, 0x03,  0x04, 0x05, 0x06, 0x07,
    0x08, 0x09, 0x0A, 0x0B,  0x0C, 0x0D, 0x0E, 0x0F, /* A0 */
    0x10, 0x10, 0x10, 0x10,  0x10, 0x10, 0x10, 0x10,
    0x10, 0x10, 0x10, 0x10,  0x10, 0x10, 0x10, 0x10, /* B0 */
    0x00, 0x01, 0x02, 0x03,  0x04, 0x05, 0x06, 0x07,
    0x08, 0x09, 0x0A, 0x0B,  0x0C, 0x0D, 0x0E, 0x0F, /* C0 */
    0x10, 0x10, 0x10, 0x10,  0x10, 0x10, 0x10, 0x10,
    0x10, 0x10, 0x10, 0x10,  0x10, 0x10, 0x10, 0x10, /* D0 */
    0x00, 0x01, 0x02, 0x03,  0x04, 0x05, 0x06, 0x07,
    0x08, 0x09, 0x0A, 0x0B,  0x0C, 0x0D, 0x0E, 0x0F, /* E0 */
    0x10, 0x10, 0x10, 0x10,  0x10, 0x10, 0x10, 0x10,
    0x10, 0x10, 0x10, 0x10,  0x10, 0x10, 0x10, 0x10, /* F0 */
};

/*
**	sprite-data -> video data
**
**	Background: nnn0 CCCC -> nnn0CCCC  Sprite number nnn + Sprite color CCCC
**	Foreground: nnn0 CCCC -> nnn00000  Sprite number nnn
*/
static CONST unsigned char SpMask[256] = {
    0xE0, 0xE0, 0xE0, 0xE0,  0xE0, 0xE0, 0xE0, 0xE0,
    0xE0, 0xE0, 0xE0, 0xE0,  0xE0, 0xE0, 0xE0, 0xE0, /* 00 */
    0xEF, 0xEF, 0xEF, 0xEF,  0xEF, 0xEF, 0xEF, 0xEF,
    0xEF, 0xEF, 0xEF, 0xEF,  0xEF, 0xEF, 0xEF, 0xEF, /* 10 */
    0xE0, 0xE0, 0xE0, 0xE0,  0xE0, 0xE0, 0xE0, 0xE0,
    0xE0, 0xE0, 0xE0, 0xE0,  0xE0, 0xE0, 0xE0, 0xE0, /* 20 */
    0xEF, 0xEF, 0xEF, 0xEF,  0xEF, 0xEF, 0xEF, 0xEF,
    0xEF, 0xEF, 0xEF, 0xEF,  0xEF, 0xEF, 0xEF, 0xEF, /* 30 */
    0xE0, 0xE0, 0xE0, 0xE0,  0xE0, 0xE0, 0xE0, 0xE0,
    0xE0, 0xE0, 0xE0, 0xE0,  0xE0, 0xE0, 0xE0, 0xE0, /* 40 */
    0xEF, 0xEF, 0xEF, 0xEF,  0xEF, 0xEF, 0xEF, 0xEF,
    0xEF, 0xEF, 0xEF, 0xEF,  0xEF, 0xEF, 0xEF, 0xEF, /* 50 */
    0xE0, 0xE0, 0xE0, 0xE0,  0xE0, 0xE0, 0xE0, 0xE0,
    0xE0, 0xE0, 0xE0, 0xE0,  0xE0, 0xE0, 0xE0, 0xE0, /* 60 */
    0xEF, 0xEF, 0xEF, 0xEF,  0xEF, 0xEF, 0xEF, 0xEF,
    0xEF, 0xEF, 0xEF, 0xEF,  0xEF, 0xEF, 0xEF, 0xEF, /* 70 */
    0xE0, 0xE0, 0xE0, 0xE0,  0xE0, 0xE0, 0xE0, 0xE0,
    0xE0, 0xE0, 0xE0, 0xE0,  0xE0, 0xE0, 0xE0, 0xE0, /* 80 */
    0xEF, 0xEF, 0xEF, 0xEF,  0xEF, 0xEF, 0xEF, 0xEF,
    0xEF, 0xEF, 0xEF, 0xEF,  0xEF, 0xEF, 0xEF, 0xEF, /* 90 */
    0xE0, 0xE0, 0xE0, 0xE0,  0xE0, 0xE0, 0xE0, 0xE0,
    0xE0, 0xE0, 0xE0, 0xE0,  0xE0, 0xE0, 0xE0, 0xE0, /* A0 */
    0xEF, 0xEF, 0xEF, 0xEF,  0xEF, 0xEF, 0xEF, 0xEF,
    0xEF, 0xEF, 0xEF, 0xEF,  0xEF, 0xEF, 0xEF, 0xEF, /* B0 */
    0xE0, 0xE0, 0xE0, 0xE0,  0xE0, 0xE0, 0xE0, 0xE0,
    0xE0, 0xE0, 0xE0, 0xE0,  0xE0, 0xE0, 0xE0, 0xE0, /* C0 */
    0xEF, 0xEF, 0xEF, 0xEF,  0xEF, 0xEF, 0xEF, 0xEF,
    0xEF, 0xEF, 0xEF, 0xEF,  0xEF, 0xEF, 0xEF, 0xEF, /* D0 */
    0xE0, 0xE0, 0xE0, 0xE0,  0xE0, 0xE0, 0xE0, 0xE0,
    0xE0, 0xE0, 0xE0, 0xE0,  0xE0, 0xE0, 0xE0, 0xE0, /* E0 */
    0xEF, 0xEF, 0xEF, 0xEF,  0xEF, 0xEF, 0xEF, 0xEF,
    0xEF, 0xEF, 0xEF, 0xEF,  0xEF, 0xEF, 0xEF, 0xEF, /* F0 */
};

/*
 *      Sprite 2 Colors Behind
 *
 *      Non transparent data replaces background data
 */
/* static */ void Sprite2CB(int i,unsigned char CONST* data,unsigned char* v)
{
    unsigned char color;
    unsigned char c;
    unsigned char bc;
    unsigned char sc;

    color=VicSprite[i].Color;
    bc=0x10;
    sc=0x00;

#define PIXEL(x,p) \
    if( c&(1<<(p-1)) ) {                /* Non transparent */           \
	unsigned char il;                                               \
									\
	il=v[x*8+8-p];                                                  \
	bc&=il;                         /* Background collision */      \
	sc|=Bits[il];                   /* Sprite collision */          \
	v[x*8+8-p]=BgTrans[il]|(color&SpMask[il]);                      \
    }

#define BYTE(x) \
    c=data[x];                          /* Sprite data */                \
    PIXEL(x,8); PIXEL(x,7); PIXEL(x,6); PIXEL(x,5);                     \
    PIXEL(x,4); PIXEL(x,3); PIXEL(x,2); PIXEL(x,1)

    BYTE(0);                            /* 1 Byte */
    BYTE(1);                            /* 2 Byte */
    BYTE(2);                            /* 3 Byte */

    if( bc!=0x10 ) {                    /* Look for foreground collision */
	VIC[0x1F]|=1<<i;
    }
    if( sc ) {                          /* Look for sprite-sprite collision */
	VIC[0x1E]|=sc|(1<<i);
    }
#undef BYTE
#undef PIXEL
}

/*
 *      Sprite 2 Colors Double Sized Behind
 *
 *      Non transparent data replaces background data
 */
/* static */ void Sprite2CDB(int i,unsigned char CONST* data,unsigned char* v)
{
    unsigned char color;
    unsigned char c;
    unsigned char bc;
    unsigned char sc;

    color=VicSprite[i].Color;
    bc=0x10;
    sc=0x00;

#define PIXEL(x,p) \
    if( c&(1<<(p-1)) ) {                /* Non transparent */           \
	unsigned char il;                                               \
									\
	il=v[x*16+0+16-p*2];                                            \
	bc&=il;                         /* Background collision */      \
	sc|=Bits[il];                   /* Sprite collision */          \
	v[x*16+0+16-p*2]=BgTrans[il]|(color&SpMask[il]);                \
	il=v[x*16+1+16-p*2];                                            \
	bc&=il;                         /* Background collision */      \
	sc|=Bits[il];                   /* Sprite collision */          \
	v[x*16+1+16-p*2]=BgTrans[il]|(color&SpMask[il]);                \
    }

#define BYTE(x) \
    c=data[x];                          /* Sprite data */                \
    PIXEL(x,8); PIXEL(x,7); PIXEL(x,6); PIXEL(x,5);                     \
    PIXEL(x,4); PIXEL(x,3); PIXEL(x,2); PIXEL(x,1)

    BYTE(0);                            /* 1 Byte */
    BYTE(1);                            /* 2 Byte */
    BYTE(2);                            /* 3 Byte */

    if( bc!=0x10 ) {                    /* Look for foreground collision */
	VIC[0x1F]|=1<<i;
    }
    if( sc ) {                          /* Look for sprite-sprite collision */
	VIC[0x1E]|=sc|(1<<i);
    }
#undef BYTE
#undef PIXEL
}

/*
 *      Sprite 4 Colors Behind
 *
 *      Non transparent data replaces background data
 */
/* static */ void Sprite4CB(int i,unsigned char CONST* data,unsigned char* v)
{
    unsigned char color[4];
    unsigned char c;
    unsigned char bc;
    unsigned char sc;

    color[1]=VIC[0x25]|(i<<5);          /* Sprite Multicolor 0 */
    color[2]=VicSprite[i].Color;
    color[3]=VIC[0x26]|(i<<5);          /* Sprite Multicolor 1 */

    bc=0x10;
    sc=0x00;

#define PIXEL(x,p) \
    if( c&(3<<(p*2-2)) ) {              /* Non transparent */           \
	unsigned char il;                                               \
									\
	il=v[x*8+0+8-p*2];                                              \
	bc&=il;                         /* Background collision */      \
	sc|=Bits[il];                   /* Sprite collision */          \
	v[x*8+0+8-p*2]=BgTrans[il]|(color[(c>>(p*2-2))&3]&SpMask[il]);  \
									\
	il=v[x*8+1+8-p*2];                                              \
	bc&=il;                         /* Background collision */      \
	sc|=Bits[il];                   /* Sprite collision */          \
	v[x*8+1+8-p*2]=BgTrans[il]|(color[(c>>(p*2-2))&3]&SpMask[il]);  \
    }

#define BYTE(x) \
    c=data[x];                          /* Sprite data */                \
    PIXEL(x,4); PIXEL(x,3); PIXEL(x,2); PIXEL(x,1);

    BYTE(0);                            /* 1 Byte */
    BYTE(1);                            /* 2 Byte */
    BYTE(2);                            /* 3 Byte */

    if( bc!=0x10 ) {                    /* Look for foreground collision */
	VIC[0x1F]|=1<<i;
    }
    if( sc ) {                          /* Look for sprite-sprite collision */
	VIC[0x1E]|=sc|(1<<i);
    }
#undef BYTE
#undef PIXEL
}

/*
 *      Sprite 4 Colors Double Sized Behind
 *
 *      Non transparent data replaces background data
 */
/* static */ void Sprite4CDB(int i,unsigned char CONST* data,unsigned char* v)
{
    unsigned char color[4];
    unsigned char c;
    unsigned char bc;
    unsigned char sc;

    color[1]=VIC[0x25]|(i<<5);          /* Sprite Multicolor 0 */
    color[2]=VicSprite[i].Color;
    color[3]=VIC[0x26]|(i<<5);          /* Sprite Multicolor 1 */

    bc=0x10;
    sc=0x00;

#define PIXEL(x,p) \
    if( c&(3<<(p*2-2)) ) {              /* Non transparent */           \
	unsigned char il;                                               \
									\
	il=v[x*16+0+16-p*4];                                            \
	bc&=il;                         /* Background collision */      \
	sc|=Bits[il];                   /* Sprite collision */          \
	v[x*16+0+16-p*4]=BgTrans[il]|(color[(c>>(p*2-2))&3]&SpMask[il]);\
									\
	il=v[x*16+1+16-p*4];                                            \
	bc&=il;                         /* Background collision */      \
	sc|=Bits[il];                   /* Sprite collision */          \
	v[x*16+1+16-p*4]=BgTrans[il]|(color[(c>>(p*2-2))&3]&SpMask[il]);\
									\
	il=v[x*16+2+16-p*4];                                            \
	bc&=il;                         /* Background collision */      \
	sc|=Bits[il];                   /* Sprite collision */          \
	v[x*16+2+16-p*4]=BgTrans[il]|(color[(c>>(p*2-2))&3]&SpMask[il]);\
									\
	il=v[x*16+3+16-p*4];                                            \
	bc&=il;                         /* Background collision */      \
	sc|=Bits[il];                   /* Sprite collision */          \
	v[x*16+3+16-p*4]=BgTrans[il]|(color[(c>>(p*2-2))&3]&SpMask[il]);\
    }

#define BYTE(x) \
    c=data[x];                          /* Sprite data */                \
    PIXEL(x,4); PIXEL(x,3); PIXEL(x,2); PIXEL(x,1)

    BYTE(0);                            /* 1 Byte */
    BYTE(1);                            /* 2 Byte */
    BYTE(2);                            /* 3 Byte */

    if( bc!=0x10 ) {                    /* Look for foreground collision */
	VIC[0x1F]|=1<<i;
    }
    if( sc ) {                          /* Look for sprite-sprite collision */
	VIC[0x1E]|=sc|(1<<i);
    }
#undef BYTE
#undef PIXEL
}

#if defined(M_UNIX) || defined(__GO32__) || defined(__linux__) || defined(PCSOLARIS)  /* { */

CONST unsigned long BMask[256] = {
    0xFFFFFFFF, 0x10FFFFFF, 0xFF10FFFF, 0x1010FFFF,  
    0xFFFF10FF, 0x10FF10FF, 0xFF1010FF, 0x101010FF,
    0xFFFFFF10, 0x10FFFF10, 0xFF10FF10, 0x1010FF10,
    0xFFFF1010, 0x10FF1010, 0xFF101010, 0x10101010,
    0xFFFFFFFF, 0x10FFFFFF, 0xFF10FFFF, 0x1010FFFF,
    0xFFFF10FF, 0x10FF10FF, 0xFF1010FF, 0x101010FF,
    0xFFFFFF10, 0x10FFFF10, 0xFF10FF10, 0x1010FF10,
    0xFFFF1010, 0x10FF1010, 0xFF101010, 0x10101010,
    0xFFFFFFFF, 0x10FFFFFF, 0xFF10FFFF, 0x1010FFFF,
    0xFFFF10FF, 0x10FF10FF, 0xFF1010FF, 0x101010FF,
    0xFFFFFF10, 0x10FFFF10, 0xFF10FF10, 0x1010FF10,
    0xFFFF1010, 0x10FF1010, 0xFF101010, 0x10101010,
    0xFFFFFFFF, 0x10FFFFFF, 0xFF10FFFF, 0x1010FFFF,
    0xFFFF10FF, 0x10FF10FF, 0xFF1010FF, 0x101010FF,
    0xFFFFFF10, 0x10FFFF10, 0xFF10FF10, 0x1010FF10,
    0xFFFF1010, 0x10FF1010, 0xFF101010, 0x10101010,
    0xFFFFFFFF, 0x10FFFFFF, 0xFF10FFFF, 0x1010FFFF,
    0xFFFF10FF, 0x10FF10FF, 0xFF1010FF, 0x101010FF,
    0xFFFFFF10, 0x10FFFF10, 0xFF10FF10, 0x1010FF10,
    0xFFFF1010, 0x10FF1010, 0xFF101010, 0x10101010,
    0xFFFFFFFF, 0x10FFFFFF, 0xFF10FFFF, 0x1010FFFF,
    0xFFFF10FF, 0x10FF10FF, 0xFF1010FF, 0x101010FF,
    0xFFFFFF10, 0x10FFFF10, 0xFF10FF10, 0x1010FF10,
    0xFFFF1010, 0x10FF1010, 0xFF101010, 0x10101010,
    0xFFFFFFFF, 0x10FFFFFF, 0xFF10FFFF, 0x1010FFFF,
    0xFFFF10FF, 0x10FF10FF, 0xFF1010FF, 0x101010FF,
    0xFFFFFF10, 0x10FFFF10, 0xFF10FF10, 0x1010FF10,
    0xFFFF1010, 0x10FF1010, 0xFF101010, 0x10101010,
    0xFFFFFFFF, 0x10FFFFFF, 0xFF10FFFF, 0x1010FFFF,
    0xFFFF10FF, 0x10FF10FF, 0xFF1010FF, 0x101010FF,
    0xFFFFFF10, 0x10FFFF10, 0xFF10FF10, 0x1010FF10,
    0xFFFF1010, 0x10FF1010, 0xFF101010, 0x10101010,
    0xFFFFFFFF, 0x10FFFFFF, 0xFF10FFFF, 0x1010FFFF,
    0xFFFF10FF, 0x10FF10FF, 0xFF1010FF, 0x101010FF,
    0xFFFFFF10, 0x10FFFF10, 0xFF10FF10, 0x1010FF10,
    0xFFFF1010, 0x10FF1010, 0xFF101010, 0x10101010,
    0xFFFFFFFF, 0x10FFFFFF, 0xFF10FFFF, 0x1010FFFF,
    0xFFFF10FF, 0x10FF10FF, 0xFF1010FF, 0x101010FF,
    0xFFFFFF10, 0x10FFFF10, 0xFF10FF10, 0x1010FF10,
    0xFFFF1010, 0x10FF1010, 0xFF101010, 0x10101010,
    0xFFFFFFFF, 0x10FFFFFF, 0xFF10FFFF, 0x1010FFFF,
    0xFFFF10FF, 0x10FF10FF, 0xFF1010FF, 0x101010FF,
    0xFFFFFF10, 0x10FFFF10, 0xFF10FF10, 0x1010FF10,
    0xFFFF1010, 0x10FF1010, 0xFF101010, 0x10101010,
    0xFFFFFFFF, 0x10FFFFFF, 0xFF10FFFF, 0x1010FFFF,
    0xFFFF10FF, 0x10FF10FF, 0xFF1010FF, 0x101010FF,
    0xFFFFFF10, 0x10FFFF10, 0xFF10FF10, 0x1010FF10,
    0xFFFF1010, 0x10FF1010, 0xFF101010, 0x10101010,
    0xFFFFFFFF, 0x10FFFFFF, 0xFF10FFFF, 0x1010FFFF,
    0xFFFF10FF, 0x10FF10FF, 0xFF1010FF, 0x101010FF,
    0xFFFFFF10, 0x10FFFF10, 0xFF10FF10, 0x1010FF10,
    0xFFFF1010, 0x10FF1010, 0xFF101010, 0x10101010,
    0xFFFFFFFF, 0x10FFFFFF, 0xFF10FFFF, 0x1010FFFF,
    0xFFFF10FF, 0x10FF10FF, 0xFF1010FF, 0x101010FF,
    0xFFFFFF10, 0x10FFFF10, 0xFF10FF10, 0x1010FF10,
    0xFFFF1010, 0x10FF1010, 0xFF101010, 0x10101010,
    0xFFFFFFFF, 0x10FFFFFF, 0xFF10FFFF, 0x1010FFFF,
    0xFFFF10FF, 0x10FF10FF, 0xFF1010FF, 0x101010FF,
    0xFFFFFF10, 0x10FFFF10, 0xFF10FF10, 0x1010FF10,
    0xFFFF1010, 0x10FF1010, 0xFF101010, 0x10101010,
    0xFFFFFFFF, 0x10FFFFFF, 0xFF10FFFF, 0x1010FFFF,
    0xFFFF10FF, 0x10FF10FF, 0xFF1010FF, 0x101010FF,
    0xFFFFFF10, 0x10FFFF10, 0xFF10FF10, 0x1010FF10,
    0xFFFF1010, 0x10FF1010, 0xFF101010, 0x10101010,
};

CONST unsigned long BMaskH[256] = {
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0x10FFFFFF, 0x10FFFFFF, 0x10FFFFFF, 0x10FFFFFF,
    0x10FFFFFF, 0x10FFFFFF, 0x10FFFFFF, 0x10FFFFFF,
    0x10FFFFFF, 0x10FFFFFF, 0x10FFFFFF, 0x10FFFFFF,
    0x10FFFFFF, 0x10FFFFFF, 0x10FFFFFF, 0x10FFFFFF,
    0xFF10FFFF, 0xFF10FFFF, 0xFF10FFFF, 0xFF10FFFF,
    0xFF10FFFF, 0xFF10FFFF, 0xFF10FFFF, 0xFF10FFFF,
    0xFF10FFFF, 0xFF10FFFF, 0xFF10FFFF, 0xFF10FFFF,
    0xFF10FFFF, 0xFF10FFFF, 0xFF10FFFF, 0xFF10FFFF,
    0x1010FFFF, 0x1010FFFF, 0x1010FFFF, 0x1010FFFF,
    0x1010FFFF, 0x1010FFFF, 0x1010FFFF, 0x1010FFFF,
    0x1010FFFF, 0x1010FFFF, 0x1010FFFF, 0x1010FFFF,
    0x1010FFFF, 0x1010FFFF, 0x1010FFFF, 0x1010FFFF,
    0xFFFF10FF, 0xFFFF10FF, 0xFFFF10FF, 0xFFFF10FF,
    0xFFFF10FF, 0xFFFF10FF, 0xFFFF10FF, 0xFFFF10FF,
    0xFFFF10FF, 0xFFFF10FF, 0xFFFF10FF, 0xFFFF10FF,
    0xFFFF10FF, 0xFFFF10FF, 0xFFFF10FF, 0xFFFF10FF,
    0x10FF10FF, 0x10FF10FF, 0x10FF10FF, 0x10FF10FF,
    0x10FF10FF, 0x10FF10FF, 0x10FF10FF, 0x10FF10FF,
    0x10FF10FF, 0x10FF10FF, 0x10FF10FF, 0x10FF10FF,
    0x10FF10FF, 0x10FF10FF, 0x10FF10FF, 0x10FF10FF,
    0xFF1010FF, 0xFF1010FF, 0xFF1010FF, 0xFF1010FF,
    0xFF1010FF, 0xFF1010FF, 0xFF1010FF, 0xFF1010FF,
    0xFF1010FF, 0xFF1010FF, 0xFF1010FF, 0xFF1010FF,
    0xFF1010FF, 0xFF1010FF, 0xFF1010FF, 0xFF1010FF,
    0x101010FF, 0x101010FF, 0x101010FF, 0x101010FF,
    0x101010FF, 0x101010FF, 0x101010FF, 0x101010FF,
    0x101010FF, 0x101010FF, 0x101010FF, 0x101010FF,
    0x101010FF, 0x101010FF, 0x101010FF, 0x101010FF,
    0xFFFFFF10, 0xFFFFFF10, 0xFFFFFF10, 0xFFFFFF10,
    0xFFFFFF10, 0xFFFFFF10, 0xFFFFFF10, 0xFFFFFF10,
    0xFFFFFF10, 0xFFFFFF10, 0xFFFFFF10, 0xFFFFFF10,
    0xFFFFFF10, 0xFFFFFF10, 0xFFFFFF10, 0xFFFFFF10,
    0x10FFFF10, 0x10FFFF10, 0x10FFFF10, 0x10FFFF10,
    0x10FFFF10, 0x10FFFF10, 0x10FFFF10, 0x10FFFF10,
    0x10FFFF10, 0x10FFFF10, 0x10FFFF10, 0x10FFFF10,
    0x10FFFF10, 0x10FFFF10, 0x10FFFF10, 0x10FFFF10,
    0xFF10FF10, 0xFF10FF10, 0xFF10FF10, 0xFF10FF10,
    0xFF10FF10, 0xFF10FF10, 0xFF10FF10, 0xFF10FF10,
    0xFF10FF10, 0xFF10FF10, 0xFF10FF10, 0xFF10FF10,
    0xFF10FF10, 0xFF10FF10, 0xFF10FF10, 0xFF10FF10,
    0x1010FF10, 0x1010FF10, 0x1010FF10, 0x1010FF10,
    0x1010FF10, 0x1010FF10, 0x1010FF10, 0x1010FF10,
    0x1010FF10, 0x1010FF10, 0x1010FF10, 0x1010FF10,
    0x1010FF10, 0x1010FF10, 0x1010FF10, 0x1010FF10,
    0xFFFF1010, 0xFFFF1010, 0xFFFF1010, 0xFFFF1010,
    0xFFFF1010, 0xFFFF1010, 0xFFFF1010, 0xFFFF1010,
    0xFFFF1010, 0xFFFF1010, 0xFFFF1010, 0xFFFF1010,
    0xFFFF1010, 0xFFFF1010, 0xFFFF1010, 0xFFFF1010,
    0x10FF1010, 0x10FF1010, 0x10FF1010, 0x10FF1010,
    0x10FF1010, 0x10FF1010, 0x10FF1010, 0x10FF1010,
    0x10FF1010, 0x10FF1010, 0x10FF1010, 0x10FF1010,
    0x10FF1010, 0x10FF1010, 0x10FF1010, 0x10FF1010,
    0xFF101010, 0xFF101010, 0xFF101010, 0xFF101010,
    0xFF101010, 0xFF101010, 0xFF101010, 0xFF101010,
    0xFF101010, 0xFF101010, 0xFF101010, 0xFF101010,
    0xFF101010, 0xFF101010, 0xFF101010, 0xFF101010,
    0x10101010, 0x10101010, 0x10101010, 0x10101010,
    0x10101010, 0x10101010, 0x10101010, 0x10101010,
    0x10101010, 0x10101010, 0x10101010, 0x10101010,
    0x10101010, 0x10101010, 0x10101010, 0x10101010,
};

CONST unsigned long SMask[256] = {
    0x00000000, 0xFF000000, 0x00FF0000, 0xFFFF0000,
    0x0000FF00, 0xFF00FF00, 0x00FFFF00, 0xFFFFFF00,
    0x000000FF, 0xFF0000FF, 0x00FF00FF, 0xFFFF00FF,
    0x0000FFFF, 0xFF00FFFF, 0x00FFFFFF, 0xFFFFFFFF,
    0x00000000, 0xFF000000, 0x00FF0000, 0xFFFF0000,
    0x0000FF00, 0xFF00FF00, 0x00FFFF00, 0xFFFFFF00,
    0x000000FF, 0xFF0000FF, 0x00FF00FF, 0xFFFF00FF,
    0x0000FFFF, 0xFF00FFFF, 0x00FFFFFF, 0xFFFFFFFF,
    0x00000000, 0xFF000000, 0x00FF0000, 0xFFFF0000,
    0x0000FF00, 0xFF00FF00, 0x00FFFF00, 0xFFFFFF00,
    0x000000FF, 0xFF0000FF, 0x00FF00FF, 0xFFFF00FF,
    0x0000FFFF, 0xFF00FFFF, 0x00FFFFFF, 0xFFFFFFFF,
    0x00000000, 0xFF000000, 0x00FF0000, 0xFFFF0000,
    0x0000FF00, 0xFF00FF00, 0x00FFFF00, 0xFFFFFF00,
    0x000000FF, 0xFF0000FF, 0x00FF00FF, 0xFFFF00FF,
    0x0000FFFF, 0xFF00FFFF, 0x00FFFFFF, 0xFFFFFFFF,
    0x00000000, 0xFF000000, 0x00FF0000, 0xFFFF0000,
    0x0000FF00, 0xFF00FF00, 0x00FFFF00, 0xFFFFFF00,
    0x000000FF, 0xFF0000FF, 0x00FF00FF, 0xFFFF00FF,
    0x0000FFFF, 0xFF00FFFF, 0x00FFFFFF, 0xFFFFFFFF,
    0x00000000, 0xFF000000, 0x00FF0000, 0xFFFF0000,
    0x0000FF00, 0xFF00FF00, 0x00FFFF00, 0xFFFFFF00,
    0x000000FF, 0xFF0000FF, 0x00FF00FF, 0xFFFF00FF,
    0x0000FFFF, 0xFF00FFFF, 0x00FFFFFF, 0xFFFFFFFF,
    0x00000000, 0xFF000000, 0x00FF0000, 0xFFFF0000,
    0x0000FF00, 0xFF00FF00, 0x00FFFF00, 0xFFFFFF00,
    0x000000FF, 0xFF0000FF, 0x00FF00FF, 0xFFFF00FF,
    0x0000FFFF, 0xFF00FFFF, 0x00FFFFFF, 0xFFFFFFFF,
    0x00000000, 0xFF000000, 0x00FF0000, 0xFFFF0000,
    0x0000FF00, 0xFF00FF00, 0x00FFFF00, 0xFFFFFF00,
    0x000000FF, 0xFF0000FF, 0x00FF00FF, 0xFFFF00FF,
    0x0000FFFF, 0xFF00FFFF, 0x00FFFFFF, 0xFFFFFFFF,
    0x00000000, 0xFF000000, 0x00FF0000, 0xFFFF0000,
    0x0000FF00, 0xFF00FF00, 0x00FFFF00, 0xFFFFFF00,
    0x000000FF, 0xFF0000FF, 0x00FF00FF, 0xFFFF00FF,
    0x0000FFFF, 0xFF00FFFF, 0x00FFFFFF, 0xFFFFFFFF,
    0x00000000, 0xFF000000, 0x00FF0000, 0xFFFF0000,
    0x0000FF00, 0xFF00FF00, 0x00FFFF00, 0xFFFFFF00,
    0x000000FF, 0xFF0000FF, 0x00FF00FF, 0xFFFF00FF,
    0x0000FFFF, 0xFF00FFFF, 0x00FFFFFF, 0xFFFFFFFF,
    0x00000000, 0xFF000000, 0x00FF0000, 0xFFFF0000,
    0x0000FF00, 0xFF00FF00, 0x00FFFF00, 0xFFFFFF00,
    0x000000FF, 0xFF0000FF, 0x00FF00FF, 0xFFFF00FF,
    0x0000FFFF, 0xFF00FFFF, 0x00FFFFFF, 0xFFFFFFFF,
    0x00000000, 0xFF000000, 0x00FF0000, 0xFFFF0000,
    0x0000FF00, 0xFF00FF00, 0x00FFFF00, 0xFFFFFF00,
    0x000000FF, 0xFF0000FF, 0x00FF00FF, 0xFFFF00FF,
    0x0000FFFF, 0xFF00FFFF, 0x00FFFFFF, 0xFFFFFFFF,
    0x00000000, 0xFF000000, 0x00FF0000, 0xFFFF0000,
    0x0000FF00, 0xFF00FF00, 0x00FFFF00, 0xFFFFFF00,
    0x000000FF, 0xFF0000FF, 0x00FF00FF, 0xFFFF00FF,
    0x0000FFFF, 0xFF00FFFF, 0x00FFFFFF, 0xFFFFFFFF,
    0x00000000, 0xFF000000, 0x00FF0000, 0xFFFF0000,
    0x0000FF00, 0xFF00FF00, 0x00FFFF00, 0xFFFFFF00,
    0x000000FF, 0xFF0000FF, 0x00FF00FF, 0xFFFF00FF,
    0x0000FFFF, 0xFF00FFFF, 0x00FFFFFF, 0xFFFFFFFF,
    0x00000000, 0xFF000000, 0x00FF0000, 0xFFFF0000,
    0x0000FF00, 0xFF00FF00, 0x00FFFF00, 0xFFFFFF00,
    0x000000FF, 0xFF0000FF, 0x00FF00FF, 0xFFFF00FF,
    0x0000FFFF, 0xFF00FFFF, 0x00FFFFFF, 0xFFFFFFFF,
    0x00000000, 0xFF000000, 0x00FF0000, 0xFFFF0000,
    0x0000FF00, 0xFF00FF00, 0x00FFFF00, 0xFFFFFF00,
    0x000000FF, 0xFF0000FF, 0x00FF00FF, 0xFFFF00FF,
    0x0000FFFF, 0xFF00FFFF, 0x00FFFFFF, 0xFFFFFFFF,
};

CONST unsigned long SMaskH[256] = {
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
    0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
    0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
    0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
    0x00FF0000, 0x00FF0000, 0x00FF0000, 0x00FF0000,
    0x00FF0000, 0x00FF0000, 0x00FF0000, 0x00FF0000,
    0x00FF0000, 0x00FF0000, 0x00FF0000, 0x00FF0000,
    0x00FF0000, 0x00FF0000, 0x00FF0000, 0x00FF0000,
    0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000,
    0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000,
    0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000,
    0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000,
    0x0000FF00, 0x0000FF00, 0x0000FF00, 0x0000FF00,
    0x0000FF00, 0x0000FF00, 0x0000FF00, 0x0000FF00,
    0x0000FF00, 0x0000FF00, 0x0000FF00, 0x0000FF00,
    0x0000FF00, 0x0000FF00, 0x0000FF00, 0x0000FF00,
    0xFF00FF00, 0xFF00FF00, 0xFF00FF00, 0xFF00FF00,
    0xFF00FF00, 0xFF00FF00, 0xFF00FF00, 0xFF00FF00,
    0xFF00FF00, 0xFF00FF00, 0xFF00FF00, 0xFF00FF00,
    0xFF00FF00, 0xFF00FF00, 0xFF00FF00, 0xFF00FF00,
    0x00FFFF00, 0x00FFFF00, 0x00FFFF00, 0x00FFFF00,
    0x00FFFF00, 0x00FFFF00, 0x00FFFF00, 0x00FFFF00,
    0x00FFFF00, 0x00FFFF00, 0x00FFFF00, 0x00FFFF00,
    0x00FFFF00, 0x00FFFF00, 0x00FFFF00, 0x00FFFF00,
    0xFFFFFF00, 0xFFFFFF00, 0xFFFFFF00, 0xFFFFFF00,
    0xFFFFFF00, 0xFFFFFF00, 0xFFFFFF00, 0xFFFFFF00,
    0xFFFFFF00, 0xFFFFFF00, 0xFFFFFF00, 0xFFFFFF00,
    0xFFFFFF00, 0xFFFFFF00, 0xFFFFFF00, 0xFFFFFF00,
    0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF,
    0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF,
    0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF,
    0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF,
    0xFF0000FF, 0xFF0000FF, 0xFF0000FF, 0xFF0000FF,
    0xFF0000FF, 0xFF0000FF, 0xFF0000FF, 0xFF0000FF,
    0xFF0000FF, 0xFF0000FF, 0xFF0000FF, 0xFF0000FF,
    0xFF0000FF, 0xFF0000FF, 0xFF0000FF, 0xFF0000FF,
    0x00FF00FF, 0x00FF00FF, 0x00FF00FF, 0x00FF00FF,
    0x00FF00FF, 0x00FF00FF, 0x00FF00FF, 0x00FF00FF,
    0x00FF00FF, 0x00FF00FF, 0x00FF00FF, 0x00FF00FF,
    0x00FF00FF, 0x00FF00FF, 0x00FF00FF, 0x00FF00FF,
    0xFFFF00FF, 0xFFFF00FF, 0xFFFF00FF, 0xFFFF00FF,
    0xFFFF00FF, 0xFFFF00FF, 0xFFFF00FF, 0xFFFF00FF,
    0xFFFF00FF, 0xFFFF00FF, 0xFFFF00FF, 0xFFFF00FF,
    0xFFFF00FF, 0xFFFF00FF, 0xFFFF00FF, 0xFFFF00FF,
    0x0000FFFF, 0x0000FFFF, 0x0000FFFF, 0x0000FFFF,
    0x0000FFFF, 0x0000FFFF, 0x0000FFFF, 0x0000FFFF,
    0x0000FFFF, 0x0000FFFF, 0x0000FFFF, 0x0000FFFF,
    0x0000FFFF, 0x0000FFFF, 0x0000FFFF, 0x0000FFFF,
    0xFF00FFFF, 0xFF00FFFF, 0xFF00FFFF, 0xFF00FFFF,
    0xFF00FFFF, 0xFF00FFFF, 0xFF00FFFF, 0xFF00FFFF,
    0xFF00FFFF, 0xFF00FFFF, 0xFF00FFFF, 0xFF00FFFF,
    0xFF00FFFF, 0xFF00FFFF, 0xFF00FFFF, 0xFF00FFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
};

/*
**	Sprite 2 Colors Infront
*/
/* static */ void Sprite2CI(int i,unsigned char CONST* data,unsigned long* v)
{
    unsigned long color;
    unsigned char c;
    unsigned long il;
    unsigned long cl;
    unsigned long bc;
    unsigned char sc;

    color=VicSprite[i].Color;
    bc=0;
    sc=0;

#define BYTE(x) \
    c=data[x];				/**** X Byte ****/		\
    il=v[x*2];                          /** High nibble **/             \
    bc|=~il&SMaskH[c];                  /* Foreground collision */      \
    cl=il&SMaskH[c];                                                    \
    sc|=Bits[(cl>> 0)&0xFF]                                             \
	| Bits[(cl>> 8)&0xFF]                                           \
	| Bits[(cl>>16)&0xFF]                                           \
	| Bits[(cl>>24)&0xFF];                                          \
    v[x*2]=(color&SMaskH[c])|(il&BMaskH[c]);                            \
									\
    il=v[x*2+1];                        /** Low nibble **/              \
    bc|=~il&SMask[c];                   /* Foreground collision */      \
    cl=il&SMask[c];                                                     \
    sc|=Bits[(cl>> 0)&0xFF]                                             \
	| Bits[(cl>> 8)&0xFF]                                           \
	| Bits[(cl>>16)&0xFF]                                           \
	| Bits[(cl>>24)&0xFF];                                          \
    v[x*2+1]=(color&SMask[c])|(il&BMask[c]);

    BYTE(0);                            /* 1 Byte */
    BYTE(1);                            /* 2 Byte */
    BYTE(2);                            /* 3 Byte */

    if( bc&0x10101010 ) {               /* Look for foreground collision */
	VIC[0x1F]|=1<<i;
    }
    if( sc ) {
	VIC[0x1E]|=sc|(1<<i);
    }
#undef BYTE
#undef NIBBLE
}

/*
 *      Sprite 2 Colors Double sized Infront
 */
/* static */ void Sprite2CDI(int i,unsigned char CONST* data,unsigned short* v)
{
    unsigned color;
    unsigned char c;
    unsigned char sc;
    unsigned bc;

    color=VicSprite[i].Color;
    bc=0x1010;
    sc=0;

#define PIXEL(x,p) \
    if( c&(1<<(p-1)) ) {                /* Non transparent */           \
	unsigned il;                                                    \
									\
	il=v[x*8+8-p];                                                  \
	bc&=il;                         /* Foreground collision */      \
	sc|=Bits[(il>>8)&0xFF]                                          \
	    | Bits[(il>>0)&0xFF];       /* Sprite collision */          \
	v[x*8+8-p]=color|(il&0x1010);                                   \
    }

#define BYTE(x) \
    c=data[x];                          /* Sprite data */                \
    PIXEL(x,8); PIXEL(x,7); PIXEL(x,6); PIXEL(x,5);                     \
    PIXEL(x,4); PIXEL(x,3); PIXEL(x,2); PIXEL(x,1)

    BYTE(0);                            /* 1 Byte */
    BYTE(1);                            /* 2 Byte */
    BYTE(2);                            /* 3 Byte */

    if( bc!=0x1010 ) {                  /* Look for foreground collision */
	VIC[0x1F]|=1<<i;
    }
    if( sc ) {
	VIC[0x1E]|=sc|(1<<i);
    }
#undef BYTE
#undef PIXEL
}

/*
**	Sprite 4 Colors Infront
*/
/*static*/ void Sprite4CI(int i,unsigned char CONST* data,unsigned short* v)
{
    unsigned char c;
    unsigned char sc;
    unsigned /*short*/ bc;
    unsigned /*short*/ color[4];

    bc=0x1010;
    sc=0;

    color[1]=QuadNibble[VIC[0x25]]|(i<<5)|(i<<13);
    color[2]=VicSprite[i].Color;
    color[3]=QuadNibble[VIC[0x26]]|(i<<5)|(i<<13);

#define PIXEL(x,p) \
    if( c&(3<<(p*2-2)) ) {		/* Non transparent */		\
	unsigned /*short*/ il;						\
									\
	il=v[x*4+4-p];							\
	bc&=il;				/* Foreground collision */	\
	sc|=Bits[(il>>8)&0xFF]						\
	    | Bits[(il>>0)&0xFF];	/* Sprite collision */		\
	v[x*4+4-p]=color[(c>>(p*2-2))&3]|(il&0x1010);			\
    }

#define BYTE(x) \
    c=data[x];			/* Sprite data */			\
    PIXEL(x,4); PIXEL(x,3); PIXEL(x,2); PIXEL(x,1);

    BYTE(0);				/* 1 Byte */
    BYTE(1);				/* 2 Byte */
    BYTE(2);				/* 3 Byte */

    if( bc!=0x1010 ) {			/* Look for foreground collision */
	VIC[0x1F]|=1<<i;
    }
    if( sc ) {				/* Set mob collision */
	VIC[0x1E]|=sc|(1<<i);
    }

#undef BYTE
#undef PIXEL
}

/*
 *      Sprite 4 Colors Double sized Infront
 */
/* static */ void Sprite4CDI(int i,unsigned char CONST* data,unsigned long* v)
{
    unsigned c;
    unsigned long il;
    unsigned long bc;
    unsigned char sc[8];
    unsigned long color[4];

    bc=0x10101010;
    sc[0]=sc[1]=sc[2]=sc[3]=sc[4]=sc[5]=sc[6]=sc[7]=0;

    color[1]=QuadNibble[VIC[0x25]]|(i<<5)|(i<<13)|(i<<21)|(i<<29);
    color[2]=VicSprite[i].Color;
    color[3]=QuadNibble[VIC[0x26]]|(i<<5)|(i<<13)|(i<<21)|(i<<29);

#define PIXEL(x,p) \
    if( c&(3<<(p*2-2)) ) {              /* Non transparent */           \
	il=v[x*4+4-p];                                                  \
	bc&=il;                         /* Foreground collision */      \
	sc[(il>>5)&7]=1;                                                \
	sc[(il>>13)&7]=1;                                               \
	sc[(il>>21)&7]=1;                                               \
	sc[(il>>29)&7]=1;               /* Sprite collision */          \
	v[x*4+4-p]=color[(c>>(p*2-2))&3]|(il&0x10101010);               \
    }

#define BYTE(x) \
    c=data[x];                          /* Sprite data */                \
    PIXEL(x,4); PIXEL(x,3); PIXEL(x,2); PIXEL(x,1);

    BYTE(0);                            /* 1 Byte */
    BYTE(1);                            /* 2 Byte */
    BYTE(2);                            /* 3 Byte */

#undef BYTE
#undef PIXEL

    if( bc!=0x10101010 ) {              /* Look for foreground collision */
	VIC[0x1F]|=1<<i;
    }
    il=(sc[1]<<1)|(sc[2]<<2)|(sc[3]<<3)|(sc[4]<<4)|(sc[5]<<5)|(sc[6]<<6)|(sc[7]<<7);
    if( il ) {
	VIC[0x1E]|=il|(1<<i);
    }
#undef BYTE
#undef PIXEL
}

#endif  /* } M_UNIX ... */

#ifdef SPARC    /* { SPARC */

/*
 *      Sprite 2 Colors Infront
 */
/* static */ void Sprite2CI(int i,unsigned char CONST* data,unsigned long* v)
{
    unsigned char color;
    unsigned char c;
    unsigned char bc;
    unsigned char sc;

    color=VicSprite[i].Color;
    bc=0x10;
    sc=0x00;

#define PIXEL(x,p) \
    if( c&(1<<(p-1)) ) {                /* Non transparent */           \
	unsigned char il;                                               \
									\
	il=v[x*8+8-p];                                                  \
	bc&=il;                         /* Background collision */      \
	sc|=Bits[il];                   /* Sprite collision */          \
	v[x*8+8-p]=(il&0x10)|color;                                     \
    }

#define BYTE(x) \
    c=data[x];                          /* Sprite data */                \
    PIXEL(x,8); PIXEL(x,7); PIXEL(x,6); PIXEL(x,5);                     \
    PIXEL(x,4); PIXEL(x,3); PIXEL(x,2); PIXEL(x,1)

    BYTE(0);                            /* 1 Byte */
    BYTE(1);                            /* 2 Byte */
    BYTE(2);                            /* 3 Byte */

    if( bc!=0x10 ) {                    /* Look for foreground collision */
	VIC[0x1F]|=1<<i;
    }
    if( sc ) {                          /* Look for sprite-sprite collision */
	VIC[0x1E]|=sc|(1<<i);
    }
#undef BYTE
#undef PIXEL
}

/*
 *      Sprite 2 Colors Double Sized Infront
 */
/* static */ void Sprite2CDI(int i,unsigned char CONST* data,unsigned long* v)
{
    unsigned char color;
    unsigned char c;
    unsigned char bc;
    unsigned char sc;

    color=VicSprite[i].Color;
    bc=0x10;
    sc=0x00;

#define PIXEL(x,p) \
    if( c&(1<<(p-1)) ) {                /* Non transparent */           \
	unsigned char il;                                               \
									\
	il=v[x*16+0+16-p*2];                                            \
	bc&=il;                         /* Background collision */      \
	sc|=Bits[il];                   /* Sprite collision */          \
	v[x*16+0+16-p*2]=(il&0x10)|color;                               \
									\
	il=v[x*16+1+16-p*2];                                            \
	bc&=il;                         /* Background collision */      \
	sc|=Bits[il];                   /* Sprite collision */          \
	v[x*16+1+16-p*2]=(il&0x10)|color;                               \
    }

#define BYTE(x) \
    c=data[x];                          /* Sprite data */                \
    PIXEL(x,8); PIXEL(x,7); PIXEL(x,6); PIXEL(x,5);                     \
    PIXEL(x,4); PIXEL(x,3); PIXEL(x,2); PIXEL(x,1)

    BYTE(0);                            /* 1 Byte */
    BYTE(1);                            /* 2 Byte */
    BYTE(2);                            /* 3 Byte */

    if( bc!=0x10 ) {                    /* Look for foreground collision */
	VIC[0x1F]|=1<<i;
    }
    if( sc ) {                          /* Look for sprite-sprite collision */
	VIC[0x1E]|=sc|(1<<i);
    }
#undef BYTE
#undef PIXEL
}

/*
 *      Sprite 4 Colors Infront
 */
/* static */ void Sprite4CI(int i,unsigned char CONST* data,unsigned long* v)
{
    unsigned char color[4];
    unsigned char c;
    unsigned char bc;
    unsigned char sc;

    color[1]=VIC[0x25]|(i<<5);          /* Sprite Multicolor 0 */
    // color[2]=VicSprite[i].Color;
    color[2]=QuadNibble[VIC[0x2E]];
    color[3]=VIC[0x26]|(i<<5);          /* Sprite Multicolor 1 */

    bc=0x10;
    sc=0x00;

#define PIXEL(x,p) \
    if( c&(3<<(p*2-2)) ) {              /* Non transparent */           \
	unsigned char il;                                               \
									\
	il=v[x*8+0+8-p*2];                                              \
	bc&=il;                         /* Background collision */      \
	sc|=Bits[il];                   /* Sprite collision */          \
	v[x*8+0+8-p*2]=(il&0x10)|color[(c>>(p*2-2))&3];                 \
									\
	il=v[x*8+1+8-p*2];                                              \
	bc&=il;                         /* Background collision */      \
	sc|=Bits[il];                   /* Sprite collision */          \
	v[x*8+1+8-p*2]=(il&0x10)|color[(c>>(p*2-2))&3];                 \
    }

#define BYTE(x) \
    c=data[x];                          /* Sprite data */                \
    PIXEL(x,4); PIXEL(x,3); PIXEL(x,2); PIXEL(x,1);

    BYTE(0);                            /* 1 Byte */
    BYTE(1);                            /* 2 Byte */
    BYTE(2);                            /* 3 Byte */

    if( bc!=0x10 ) {                    /* Look for foreground collision */
	VIC[0x1F]|=1<<i;
    }
    if( sc ) {                          /* Look for sprite-sprite collision */
	VIC[0x1E]|=sc|(1<<i);
    }
#undef BYTE
#undef PIXEL
}

/*
 *      Sprite 4 Colors Double Sized Infront
 *
 *      Non transparent data replaces background data
 */
/* static */ void Sprite4CDI(int i,unsigned char CONST* data,unsigned long* v)
{
    unsigned char color[4];
    unsigned char c;
    unsigned char bc;
    unsigned char sc;

    color[1]=VIC[0x25]|(i<<5);          /* Sprite Multicolor 0 */
    color[2]=VicSprite[i].Color;
    color[3]=VIC[0x26]|(i<<5);          /* Sprite Multicolor 1 */

    bc=0x10;
    sc=0x00;

#define PIXEL(x,p) \
    if( c&(3<<(p*2-2)) ) {              /* Non transparent */           \
	unsigned char il;                                               \
									\
	il=v[x*16+0+16-p*4];                                            \
	bc&=il;                         /* Background collision */      \
	sc|=Bits[il];                   /* Sprite collision */          \
	v[x*16+0+16-p*4]=(il&0x10)|color[(c>>(p*2-2))&3];               \
									\
	il=v[x*16+1+16-p*4];                                            \
	bc&=il;                         /* Background collision */      \
	sc|=Bits[il];                   /* Sprite collision */          \
	v[x*16+1+16-p*4]=(il&0x10)|color[(c>>(p*2-2))&3];               \
									\
	il=v[x*16+2+16-p*4];                                            \
	bc&=il;                         /* Background collision */      \
	sc|=Bits[il];                   /* Sprite collision */          \
	v[x*16+2+16-p*4]=(il&0x10)|color[(c>>(p*2-2))&3];               \
									\
	il=v[x*16+3+16-p*4];                                            \
	bc&=il;                         /* Background collision */      \
	sc|=Bits[il];                   /* Sprite collision */          \
	v[x*16+3+16-p*4]=(il&0x10)|color[(c>>(p*2-2))&3];               \
    }

#define BYTE(x) \
    c=data[x];                          /* Sprite data */                \
    PIXEL(x,4); PIXEL(x,3); PIXEL(x,2); PIXEL(x,1)

    BYTE(0);                            /* 1 Byte */
    BYTE(1);                            /* 2 Byte */
    BYTE(2);                            /* 3 Byte */

    if( bc!=0x10 ) {                    /* Look for foreground collision */
	VIC[0x1F]|=1<<i;
    }
    if( sc ) {                          /* Look for sprite-sprite collision */
	VIC[0x1E]|=sc|(1<<i);
    }
#undef BYTE
#undef PIXEL
}

#endif  /* } SPARC */

/*
**	| 3 Cycles BA | Slot 0 | Slot 1 | Slot 2 | Slot 3 | ...
**	|  X   X   X  |  0  0  |  1  1  | ...... | ...... | ...
**	|  X   X   X  |  0  0  |  X  X  |  2  2  | ...... | ...
**	|  X   X   X  |  0  0  |  F  X  |  X  X  |  3  3  | ...
*/
static int CONST VicSpriteCycles[] = {
    5,					/*  0   First 3 bus acknowledge */
    2,					/*  1   next */
    4,					/*  2 1 free */
    5,					/*  3 2 free */
    5,					/*  4 3 free */
    5,					/*  5 4 free */
    5,					/*  6 5 free */
    5,					/*  7 6 free */

    5,					/*  8 7 free */
    5,					/*  9 8 free */
    5,					/* 10 9 free */
    5,					/* 11 10 free */
};

#ifndef NEW_SPRITES

#if 1

/*
**	Sprite Start Line $32 Dot $18
*/
void Sprite(int i)
{
    int o,x,y;
    int bit;
    unsigned char* d;
    unsigned char* v;

    bit=1<<i;				/* Sprite bit */

#if 0

    y=VIC[0x01+i*2]+1;
    if( y+((VIC[0x17]&(bit)) ? 42 : 21)<=VicRasterLine || y>VicRasterLine ) {
	return;
    }

#else

#if 0
    y=VicSprite[i].Y;
#endif
    if( VicSprite[i].Counter ) {
	y=VicSprite[i].Counter;
	o=VicRasterLine-y;
	if( o>=VicSprite[i].Stop ) {
	    VicSprite[i].Counter=0;
	}
    } else {
	VicSprite[i].Counter=y=VicSprite[i].Y|(VicRasterLine&0x100);
	if( VIC[0x17]&bit ) {		/* Sprite expanded in Y */
	    VicSprite[i].Stop=41;
	} else {
	    VicSprite[i].Stop=20;
	}
	o=0;
    }
#endif

    Cycle+=VicSpriteCycles[VicLastSprite-i];
    VicLastSprite=i;

    /* FIXME:
    x=VicSprite[i].X;
    */
    x=VIC[0x00+i*2];
    if( VIC[0x10]&bit )
	x+=0x100;
    if( /*x+24<0x18 ||*/ x>0x18+320 ) {
	return;
    }

    if( VIC[0x17]&(bit) ) {		/* Sprite expanded in Y */
	d=VicBank+VicVRam[0x3F8+i]*64
	    +((VicRasterLine-y)/2)*3;	/* Address of sprite */
    } else {
	d=VicBank+VicVRam[0x3F8+i]*64
	    +(VicRasterLine-y)*3;	/* Address of sprite */
    }

    v=DispBuf+8+x-VicXOffset;
    if( VIC[0x1B]&bit ) {		/* Data has priority */
	if( VIC[0x1D]&bit ) {		/* Sprite expand X */
	    if( VIC[0x1C]&bit ) {	/* Sprite multi color */
		Sprite4CDB(i,d,(void*)v);
	    } else {
		Sprite2CDB(i,d,(void*)v);
	    }
	} else {
	    if( VIC[0x1C]&bit ) {	/* Sprite multi color */
		Sprite4CB(i,d,(void*)v);
	    } else {
		Sprite2CB(i,d,(void*)v);
	    }
	}
    } else {
	if( VIC[0x1D]&bit ) {		/* Sprite expand X */
	    if( VIC[0x1C]&bit ) {	/* Sprite multi color */
		Sprite4CDI(i,d,(void*)v);
	    } else {
		Sprite2CDI(i,d,(void*)v);
	    }
	} else {
	    if( VIC[0x1C]&bit ) {	/* Sprite multi color */
		Sprite4CI(i,d,(void*)v);
	    } else {
		Sprite2CI(i,d,(void*)v);
	    }
	}
    }
}

#else

/*
**	Sprite dispatcher:
**		0:	VIC[0x1D]	Expand X
**		1:	VIC[0x1C]	Multi color
**		2:	VIC[0x1B]	Data priority
*/
static void (*SpriteTable[8])(int,unsigned char CONST*,void*) = {
    Sprite2CB,
    Sprite2CDB,
    Sprite4CB,
    Sprite4CDB,
    Sprite2CI,
    Sprite2CDI,
    Sprite4CI,
    Sprite4CDI,
};

/*
**	Sprite Start Line $32 Dot $18
*/
void Sprite(int i)
{
    int o,x,y;
    int bit;
    unsigned char* d;
    unsigned char* v;

    bit=1<<i;				/* Sprite bit */

    if( VicSprite[i].Counter ) {
	y=VicSprite[i].Counter;
	o=VicRasterLine-y;
	if( o>=VicSprite[i].Stop ) {
	    VicSprite[i].Counter=0;
	}
    } else {
	VicSprite[i].Counter=y=VicSprite[i].Y|(VicRasterLine&0x100);
	if( VIC[0x17]&bit ) {		/* Sprite expanded in Y */
	    VicSprite[i].Stop=41;
	} else {
	    VicSprite[i].Stop=20;
	}
	o=0;
    }

    Cycle+=VicSpriteCycles[VicLastSprite-i];
    VicLastSprite=i;

    x=VIC[0x00+i*2];
    if( VIC[0x10]&bit )
	x+=0x100;
    if( x>0x18+320 ) {
	return;
    }

    if( VIC[0x17]&(bit) ) {		/* Sprite expanded in Y */
	d=VicBank+VicVRam[0x3F8+i]*64
	    +((VicRasterLine-y)/2)*3;	/* Address of sprite */
    } else {
	d=VicBank+VicVRam[0x3F8+i]*64
	    +(VicRasterLine-y)*3;	/* Address of sprite */
    }

    v=DispBuf+8+x-VicXOffset;

    x=(((VIC[0x1B]>>i)&1)<<2)|(((VIC[0x1C]>>i)&1)<<1)|((VIC[0x1D]>>i)&1);
    SpriteTable[x](i,d,(void*)v);
}

#endif

#else

/*
**	Sprite Start Line $32 Dot $18
*/
void Sprite(int i)
{
    int x;
    int bit;
    unsigned char* d;
    unsigned char* v;

#if 0
    Cycle+=VicSpriteCycles[VicLastSprite-i];
    VicLastSprite=i;
#endif

    bit=1<<i;				/* Sprite bit */
    x=VicSprite[i].X;

    if( VicSprite[i].Y==(VicRasterLine&0xFF) ) {
	VicSprite[i].Advance=0;
	VicSprite[i].Counter=0;
    }

    if( x<=0x18+320 ) {			/* inside visibile range */

	v=DispBuf+8+x-VicXOffset;

	d=VicBank+VicVRam[0x3F8+i]*64+VicSprite[i].Counter;

	if( VIC[0x1B]&bit ) {		/* Data has priority */
	    if( VIC[0x1D]&bit ) {	/* Sprite expand X */
		if( VIC[0x1C]&bit ) {	/* Sprite multi color */
		    Sprite4CDB(i,d,(void*)v);
		} else {
		    Sprite2CDB(i,d,(void*)v);
		}
	    } else {
		if( VIC[0x1C]&bit ) {	/* Sprite multi color */
		    Sprite4CB(i,d,(void*)v);
		} else {
		    Sprite2CB(i,d,(void*)v);
		}
	    }
	} else {
	    if( VIC[0x1D]&bit ) {	/* Sprite expand X */
		if( VIC[0x1C]&bit ) {	/* Sprite multi color */
		    Sprite4CDI(i,d,(void*)v);
		} else {
		    Sprite2CDI(i,d,(void*)v);
		}
	    } else {
		if( VIC[0x1C]&bit ) {	/* Sprite multi color */
		    Sprite4CI(i,d,(void*)v);
		} else {
		    Sprite2CI(i,d,(void*)v);
		}
	    }
	}
    }

    VicSpriteDMA[VicRasterLine&0xFF]&=~bit;
    if( !(VIC[0x17]&bit)
	    || VicSprite[i].Advance ) {	/* Sprite expanded in Y */
	VicSprite[i].Advance=0;
	VicSprite[i].Counter+=3;
	VicSprite[i].Counter&=63;	/* later round about possible */
	/*
	**	Look for DMA end.
	*/
	if( VicSprite[i].Counter==63 ) {
	    // extern int SpriteDMA;

	    // SpriteDMA&=~bit;
	    if( VIC[0x15]&bit )
		VicSpriteDMA[VicSprite[i].Y]|=bit;
	    VicSprite[i].Counter=0;
	    return;
	}
    } else {
	VicSprite[i].Advance=1;
    }
    VicSpriteDMA[(VicRasterLine+1)&0xFF]|=bit;
}

#endif
