/*
 *	The C64 emulator
 *
 *	Copyright 1992-96 by ALE.
 *	written by Lutz Sammer, Andreas Arens, Frank Wuebbeling
 *
 *	Machine dependend header file
 *-----------------------------------------------------------------------------
 * $Id: md.h,v 1.11 1996/07/07 00:14:50 johns Exp root $
 * $Log: md.h,v $
 * Revision 1.11  1996/07/07 00:14:50  johns
 * PCSOLARIS changes from Frank Wuebbel.
 *
 * Revision 1.10  1996/05/12 21:04:23  johns
 * Cleanup, Binary file open added.
 *
 * Revision 1.9  1995/02/13  11:28:07  ari
 * second linux port integration
 *
 * Revision 1.8  1995/02/06  23:56:41  johns
 * GO32 DPMI keyboard support
 *
 * Revision 1.7  1994/12/18  00:32:11  root
 * non-gcc feature macro support, icc support
 *
 * Revision 1.6  1993/08/31  20:30:45  johns
 * go32 initial support
 *
 * Revision 1.5  1993/06/13  12:25:36  johns
 * cleanup
 *
 * Revision 1.4  1993/01/05  12:42:43  johns
 * Checkin before wuebbel patches
 *
 * Revision 1.3  1992/07/28  19:47:42  johns
 * Sparc changes added.
 *
 * Revision 1.2  1992/07/20  04:30:20  johns
 *
 * Revision 1.1  1992/07/11  21:52:24  johns
 * Initial revision
 *
 *-----------------------------------------------------------------------------
 */

#ifdef _M_UNIX
#   ifndef M_UNIX
#	define M_UNIX
#   endif
#endif
#ifdef _M_I386
#   ifndef M_I386
#	define M_I386
#   endif
#endif

/*
**	Machine config
*/
#ifndef LITTLE_ENDIAN
#   ifdef M_I386
#	define LITTLE_ENDIAN 1
#   endif

#   ifdef __linux__
#	ifdef i386
#	    define LITTLE_ENDIAN 1
#	endif
#   endif
#endif

#ifdef __GO32__
#   define LITTLE_ENDIAN 1
#   define DPMI 1
#endif

#ifdef sun
#   ifdef i386
#	define LITTLE_ENDIAN 1
#	define __USES_AS__
#   else
#	define BIG_ENDIAN 1
#   endif
#endif
#ifdef sparc
#   define SPARC
#endif

#ifdef __GNUC__	/* { */

#ifndef alloca
#define alloca(x)	__builtin_alloca(x)
#endif
#define CONST		const
#define VOLATILE	volatile

/*
**	Assembler macros:
*/
#if M_I386 && M_UNIX || defined(__GO32__) || defined(__linux__) || defined(PCSOLARIS) /* { */

#ifdef __USES_AS__	/* { */
/* ATT assembler.. */

extern inline int inb(int port)
{
    int ret;
    asm volatile("xorl %%eax,%%eax\n\tinb (%%dx)" : "=a" (ret) : "d" (port));
    return ret;
}

#define outb(port,val)		\
    asm("outb (%%dx)" : : "a" (val), "d" (port))
#define outw(port,val)		\
    asm("outw (%%dx)" : : "a" (val), "d" (port))
#define outi(port,idx,val)	\
    asm("outw (%%dx)" : : "a" ((idx)|(val)<<8), "d" (port))

#define LongFill(a,v,l)		\
    asm("rep\nstosl" : : "a" (v), "c" (l), "D" (a) : "ax", "cx", "di")
#define LongCopy(d,s,l)		\
    asm("rep\nmovsl" : : "S" (s), "D" (d), "c" (l) : "cx", "di", "si")

#else	/* }{ __USES_AS__ */

extern inline int inb(int port)
{
    int ret;
    asm volatile("xorl %%eax,%%eax\n\tinb %%dx,%%al" : "=a" (ret) : "d" (port));
    return ret;
}

#define outb(port,val)		\
    asm("outb %%al,%%dx" : : "a" (val), "d" (port))
#define outw(port,val)		\
    asm("outw %%ax,%%dx" : : "a" (val), "d" (port))
#define outi(port,idx,val)	\
    asm("outw %%ax,%%dx" : : "a" ((idx)|(val)<<8), "d" (port))

#define LongFill(a,v,l)		\
    asm("rep\nstosl" : : "a" (v), "c" (l), "D" (a) : "ax", "cx", "di")
#define LongCopy(d,s,l)		\
    asm("rep\nmovsl" : : "S" (s), "D" (d), "c" (l) : "cx", "di", "si")

#endif	/* } !__USES_AS__ */

#endif	/* } !M_I386 && !M_UNIX && !__GO32__ ... */

#else	/* }{ __GNUC__ */

#ifdef __ICC /* { */

#define CONST		const
#define VOLATILE	volatile

#define inb(port)	do_in_byte(port)
#define outb(port,val)	do_out_byte(port,val)
#define outw(port,val)	do_out_word(port,val)
#define outi(p,l,h)	do_out_word(p,(l)|((h)<<8))
#define LongFill(a,v,l)	memset(a,v,(l)*4)
#define LongCopy(d,s,l)	memcpy(d,s,(l)*4)

#else	/* }{ __ICC */
/* msdos or other x86 compiler */

#define inb		inp
#define outb		outp
#define outi(p,l,h)	outpw(p,(l)|((h)<<8))
#define LongFill(a,v,l)	memset(a,v,(l)*4)
#define LongCopy(d,s,l)	memcpy(d,s,(l)*4)

#endif	/* } !__ICC */

#endif	/* } !__GNUC__ */

/*---------------------------------------------------------------------------*/

/*
**	Fetch 6502 word
*/
#ifdef BIG_ENDIAN
#   define WORD_FETCH(adr)	((adr)[0]|((adr)[1]<<8))
#endif
#ifdef LITTLE_ENDIAN
#   define WORD_FETCH(adr)	(*(unsigned short*)(adr))
#endif

/*---------------------------------------------------------------------------*/

/*
**	Binary file open
*/
#ifdef __GO32__
#define BINARY_FILE	O_BINARY
#else
#define BINARY_FILE	0
#endif

/*---------------------------------------------------------------------------*/

#ifndef CONST
#   define CONST
#endif
#ifndef VOLATILE
#   define VOLATILE
#endif
