/
/	The C64 emulator
/
/	Copyright 1992-96 by ALE.
/	written by Lutz Sammer.
/	DOS/linux port by Andreas Arens.
/
/	MultiColorTextDL: Multicolor text display line
/------------------------------------------------------------------------------
/ $Id: mctdl.S,v 1.4 1996/04/14 18:23:33 johns stab $
/ $Log: mctdl.S,v $
/ Revision 1.4  1996/04/14 18:23:33  johns
/ Cleaned up
/
/ Revision 1.3  1995/02/13  11:26:32  ari
/ Linux changes
/
/ Revision 1.2  1993/08/31  20:26:10  ari
/ GO32 changes
/
/ Revision 1.1  1992/07/13  04:36:26  johns
/ Initial revision
/
/------------------------------------------------------------------------------
/
/

#if defined(__GO32__) || defined(__ELF__) || defined(__COFF__) || defined(__M_COFF__)
#define ALSIZE16 16
#define ALSIZE64 64
#else
#define ALSIZE16 4
#define ALSIZE64 6
#endif

#if defined(__ELF__) || defined(__COFF__) || defined(__M_COFF__)
#define SYMBOL_NAME(X) X
#define SYMBOL_NAME_LABEL(X) X##:
#else	/* __GO32__ || __A_OUT__ */
#define SYMBOL_NAME(X) _##X
#define SYMBOL_NAME_LABEL(X) _##X##:
#endif

	.text

	.align	ALSIZE16
	.globl	SYMBOL_NAME(MultiColorTextDL)
SYMBOL_NAME_LABEL(MultiColorTextDL)
	pushl	%ebp
	pushl	%edi
	pushl	%esi
	pushl	%ebx

	movl	SYMBOL_NAME(VicCRam),%esi
	addl	SYMBOL_NAME(VicScanLine),%esi	/* %esi Character rom */

	movl	$SYMBOL_NAME(DispBuf)+32,%edi	/* %edi Display buffer */

	movb	SYMBOL_NAME(VicBackground0),%dl	/* %dl Color 0 */
	movb	SYMBOL_NAME(VIC)+34,%dh		/* %dh Color 1 */
	orb	$16,%dh
	movb	SYMBOL_NAME(VIC)+35,%bl		/* %bl Color 2 */

	xorl	%ebp,%ebp			/* %ebp Index */
	xorl	%ecx,%ecx
	jmp	LC1

	.align	ALSIZE16
LC1:
	movl	SYMBOL_NAME(VicColorRam),%eax	/* Color ram */
	movb	(%eax,%ebp),%bh			/* %bh Color 3 */

	movb	%bh,%cl
	shrb	$4,%bh
	andb	$7,%bh

	movl	%esi,%eax
	addl	SYMBOL_NAME(VicLineBuffer)(,%ebp,4),%eax
	movb	(%eax),%al			/* Bitmask */
	andb	$128,%cl
	andl	$255,%eax

	addl	%ecx,%eax			/* Bit 7 -> 8 */
	addl	%ecx,%eax

	sall	$6,%eax				/* *64 */
	addl	$LC3,%eax
	jmp	%eax
	.align	ALSIZE64
LC3:
LXs00:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	incl	%ebp
	addl	$8,%edi
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs01:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%dl,6(%edi)
	movb	%bh,7(%edi)
	incl	%ebp
	addl	$8,%edi
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs02:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%bh,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs03:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs04:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%dl,4(%edi)
	movb	%bh,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs05:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%dl,4(%edi)
	movb	%bh,5(%edi)
	movb	%dl,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs06:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%dl,4(%edi)
	movb	%bh,5(%edi)
	movb	%bh,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs07:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%dl,4(%edi)
	movb	%bh,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs08:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%bh,4(%edi)
	movb	%dl,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs09:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%bh,4(%edi)
	movb	%dl,5(%edi)
	movb	%dl,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs0A:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%bh,4(%edi)
	movb	%dl,5(%edi)
	movb	%bh,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs0B:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%bh,4(%edi)
	movb	%dl,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs0C:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs0D:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%dl,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs0E:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%bh,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs0F:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs10:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%dl,2(%edi)
	movb	%bh,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs11:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%dl,2(%edi)
	movb	%bh,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%dl,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp 	LC2
	.align  ALSIZE64
LXs12:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%dl,2(%edi)
	movb	%bh,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%bh,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs13:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%dl,2(%edi)
	movb	%bh,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs14:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%dl,2(%edi)
	movb	%bh,3(%edi)
	movb	%dl,4(%edi)
	movb	%bh,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs15:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%dl,2(%edi)
	movb	%bh,3(%edi)
	movb	%dl,4(%edi)
	movb	%bh,5(%edi)
	movb	%dl,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs16:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%dl,2(%edi)
	movb	%bh,3(%edi)
	movb	%dl,4(%edi)
	movb	%bh,5(%edi)
	movb	%bh,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs17:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%dl,2(%edi)
	movb	%bh,3(%edi)
	movb	%dl,4(%edi)
	movb	%bh,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs18:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%dl,2(%edi)
	movb	%bh,3(%edi)
	movb	%bh,4(%edi)
	movb	%dl,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs19:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%dl,2(%edi)
	movb	%bh,3(%edi)
	movb	%bh,4(%edi)
	movb	%dl,5(%edi)
	movb	%dl,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs1A:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%dl,2(%edi)
	movb	%bh,3(%edi)
	movb	%bh,4(%edi)
	movb	%dl,5(%edi)
	movb	%bh,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs1B:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%dl,2(%edi)
	movb	%bh,3(%edi)
	movb	%bh,4(%edi)
	movb	%dl,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs1C:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%dl,2(%edi)
	movb	%bh,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs1D:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%dl,2(%edi)
	movb	%bh,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%dl,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs1E:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%dl,2(%edi)
	movb	%bh,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%bh,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs1F:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%dl,2(%edi)
	movb	%bh,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs20:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%bh,2(%edi)
	movb	%dl,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs21:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%bh,2(%edi)
	movb	%dl,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%dl,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs22:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%bh,2(%edi)
	movb	%dl,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%bh,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs23:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%bh,2(%edi)
	movb	%dl,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs24:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%bh,2(%edi)
	movb	%dl,3(%edi)
	movb	%dl,4(%edi)
	movb	%bh,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs25:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%bh,2(%edi)
	movb	%dl,3(%edi)
	movb	%dl,4(%edi)
	movb	%bh,5(%edi)
	movb	%dl,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs26:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%bh,2(%edi)
	movb	%dl,3(%edi)
	movb	%dl,4(%edi)
	movb	%bh,5(%edi)
	movb	%bh,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs27:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%bh,2(%edi)
	movb	%dl,3(%edi)
	movb	%dl,4(%edi)
	movb	%bh,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs28:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%bh,2(%edi)
	movb	%dl,3(%edi)
	movb	%bh,4(%edi)
	movb	%dl,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs29:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%bh,2(%edi)
	movb	%dl,3(%edi)
	movb	%bh,4(%edi)
	movb	%dl,5(%edi)
	movb	%dl,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs2A:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%bh,2(%edi)
	movb	%dl,3(%edi)
	movb	%bh,4(%edi)
	movb	%dl,5(%edi)
	movb	%bh,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs2B:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%bh,2(%edi)
	movb	%dl,3(%edi)
	movb	%bh,4(%edi)
	movb	%dl,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs2C:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%bh,2(%edi)
	movb	%dl,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs2D:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%bh,2(%edi)
	movb	%dl,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%dl,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs2E:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%bh,2(%edi)
	movb	%dl,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%bh,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs2F:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%bh,2(%edi)
	movb	%dl,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs30:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs31:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%dl,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs32:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%bh,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs33:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs34:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%dl,4(%edi)
	movb	%bh,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs35:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%dl,4(%edi)
	movb	%bh,5(%edi)
	movb	%dl,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs36:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%dl,4(%edi)
	movb	%bh,5(%edi)
	movb	%bh,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs37:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%dl,4(%edi)
	movb	%bh,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs38:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%bh,4(%edi)
	movb	%dl,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs39:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%bh,4(%edi)
	movb	%dl,5(%edi)
	movb	%dl,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs3A:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%bh,4(%edi)
	movb	%dl,5(%edi)
	movb	%bh,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs3B:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%bh,4(%edi)
	movb	%dl,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs3C:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs3D:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%dl,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs3E:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%bh,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs3F:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs40:
	movb	%dl,(%edi)
	movb	%bh,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs41:
	movb	%dl,(%edi)
	movb	%bh,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%dl,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs42:
	movb	%dl,(%edi)
	movb	%bh,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%bh,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs43:
	movb	%dl,(%edi)
	movb	%bh,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs44:
	movb	%dl,(%edi)
	movb	%bh,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%dl,4(%edi)
	movb	%bh,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs45:
	movb	%dl,(%edi)
	movb	%bh,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%dl,4(%edi)
	movb	%bh,5(%edi)
	movb	%dl,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs46:
	movb	%dl,(%edi)
	movb	%bh,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%dl,4(%edi)
	movb	%bh,5(%edi)
	movb	%bh,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs47:
	movb	%dl,(%edi)
	movb	%bh,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%dl,4(%edi)
	movb	%bh,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs48:
	movb	%dl,(%edi)
	movb	%bh,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%bh,4(%edi)
	movb	%dl,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs49:
	movb	%dl,(%edi)
	movb	%bh,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%bh,4(%edi)
	movb	%dl,5(%edi)
	movb	%dl,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs4A:
	movb	%dl,(%edi)
	movb	%bh,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%bh,4(%edi)
	movb	%dl,5(%edi)
	movb	%bh,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs4B:
	movb	%dl,(%edi)
	movb	%bh,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%bh,4(%edi)
	movb	%dl,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs4C:
	movb	%dl,(%edi)
	movb	%bh,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs4D:
	movb	%dl,(%edi)
	movb	%bh,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%dl,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs4E:
	movb	%dl,(%edi)
	movb	%bh,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%bh,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs4F:
	movb	%dl,(%edi)
	movb	%bh,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs50:
	movb	%dl,(%edi)
	movb	%bh,1(%edi)
	movb	%dl,2(%edi)
	movb	%bh,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs51:
	movb	%dl,(%edi)
	movb	%bh,1(%edi)
	movb	%dl,2(%edi)
	movb	%bh,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%dl,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs52:
	movb	%dl,(%edi)
	movb	%bh,1(%edi)
	movb	%dl,2(%edi)
	movb	%bh,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%bh,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs53:
	movb	%dl,(%edi)
	movb	%bh,1(%edi)
	movb	%dl,2(%edi)
	movb	%bh,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs54:
	movb	%dl,(%edi)
	movb	%bh,1(%edi)
	movb	%dl,2(%edi)
	movb	%bh,3(%edi)
	movb	%dl,4(%edi)
	movb	%bh,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs55:
	movb	%dl,(%edi)
	movb	%bh,1(%edi)
	movb	%dl,2(%edi)
	movb	%bh,3(%edi)
	movb	%dl,4(%edi)
	movb	%bh,5(%edi)
	movb	%dl,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs56:
	movb	%dl,(%edi)
	movb	%bh,1(%edi)
	movb	%dl,2(%edi)
	movb	%bh,3(%edi)
	movb	%dl,4(%edi)
	movb	%bh,5(%edi)
	movb	%bh,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs57:
	movb	%dl,(%edi)
	movb	%bh,1(%edi)
	movb	%dl,2(%edi)
	movb	%bh,3(%edi)
	movb	%dl,4(%edi)
	movb	%bh,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs58:
	movb	%dl,(%edi)
	movb	%bh,1(%edi)
	movb	%dl,2(%edi)
	movb	%bh,3(%edi)
	movb	%bh,4(%edi)
	movb	%dl,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs59:
	movb	%dl,(%edi)
	movb	%bh,1(%edi)
	movb	%dl,2(%edi)
	movb	%bh,3(%edi)
	movb	%bh,4(%edi)
	movb	%dl,5(%edi)
	movb	%dl,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs5A:
	movb	%dl,(%edi)
	movb	%bh,1(%edi)
	movb	%dl,2(%edi)
	movb	%bh,3(%edi)
	movb	%bh,4(%edi)
	movb	%dl,5(%edi)
	movb	%bh,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs5B:
	movb	%dl,(%edi)
	movb	%bh,1(%edi)
	movb	%dl,2(%edi)
	movb	%bh,3(%edi)
	movb	%bh,4(%edi)
	movb	%dl,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs5C:
	movb	%dl,(%edi)
	movb	%bh,1(%edi)
	movb	%dl,2(%edi)
	movb	%bh,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs5D:
	movb	%dl,(%edi)
	movb	%bh,1(%edi)
	movb	%dl,2(%edi)
	movb	%bh,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%dl,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs5E:
	movb	%dl,(%edi)
	movb	%bh,1(%edi)
	movb	%dl,2(%edi)
	movb	%bh,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%bh,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs5F:
	movb	%dl,(%edi)
	movb	%bh,1(%edi)
	movb	%dl,2(%edi)
	movb	%bh,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs60:
	movb	%dl,(%edi)
	movb	%bh,1(%edi)
	movb	%bh,2(%edi)
	movb	%dl,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs61:
	movb	%dl,(%edi)
	movb	%bh,1(%edi)
	movb	%bh,2(%edi)
	movb	%dl,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%dl,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs62:
	movb	%dl,(%edi)
	movb	%bh,1(%edi)
	movb	%bh,2(%edi)
	movb	%dl,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%bh,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs63:
	movb	%dl,(%edi)
	movb	%bh,1(%edi)
	movb	%bh,2(%edi)
	movb	%dl,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs64:
	movb	%dl,(%edi)
	movb	%bh,1(%edi)
	movb	%bh,2(%edi)
	movb	%dl,3(%edi)
	movb	%dl,4(%edi)
	movb	%bh,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs65:
	movb	%dl,(%edi)
	movb	%bh,1(%edi)
	movb	%bh,2(%edi)
	movb	%dl,3(%edi)
	movb	%dl,4(%edi)
	movb	%bh,5(%edi)
	movb	%dl,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs66:
	movb	%dl,(%edi)
	movb	%bh,1(%edi)
	movb	%bh,2(%edi)
	movb	%dl,3(%edi)
	movb	%dl,4(%edi)
	movb	%bh,5(%edi)
	movb	%bh,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs67:
	movb	%dl,(%edi)
	movb	%bh,1(%edi)
	movb	%bh,2(%edi)
	movb	%dl,3(%edi)
	movb	%dl,4(%edi)
	movb	%bh,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs68:
	movb	%dl,(%edi)
	movb	%bh,1(%edi)
	movb	%bh,2(%edi)
	movb	%dl,3(%edi)
	movb	%bh,4(%edi)
	movb	%dl,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs69:
	movb	%dl,(%edi)
	movb	%bh,1(%edi)
	movb	%bh,2(%edi)
	movb	%dl,3(%edi)
	movb	%bh,4(%edi)
	movb	%dl,5(%edi)
	movb	%dl,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs6A:
	movb	%dl,(%edi)
	movb	%bh,1(%edi)
	movb	%bh,2(%edi)
	movb	%dl,3(%edi)
	movb	%bh,4(%edi)
	movb	%dl,5(%edi)
	movb	%bh,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs6B:
	movb	%dl,(%edi)
	movb	%bh,1(%edi)
	movb	%bh,2(%edi)
	movb	%dl,3(%edi)
	movb	%bh,4(%edi)
	movb	%dl,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs6C:
	movb	%dl,(%edi)
	movb	%bh,1(%edi)
	movb	%bh,2(%edi)
	movb	%dl,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs6D:
	movb	%dl,(%edi)
	movb	%bh,1(%edi)
	movb	%bh,2(%edi)
	movb	%dl,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%dl,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs6E:
	movb	%dl,(%edi)
	movb	%bh,1(%edi)
	movb	%bh,2(%edi)
	movb	%dl,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%bh,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs6F:
	movb	%dl,(%edi)
	movb	%bh,1(%edi)
	movb	%bh,2(%edi)
	movb	%dl,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs70:
	movb	%dl,(%edi)
	movb	%bh,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs71:
	movb	%dl,(%edi)
	movb	%bh,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%dl,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs72:
	movb	%dl,(%edi)
	movb	%bh,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%bh,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs73:
	movb	%dl,(%edi)
	movb	%bh,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs74:
	movb	%dl,(%edi)
	movb	%bh,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%dl,4(%edi)
	movb	%bh,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs75:
	movb	%dl,(%edi)
	movb	%bh,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%dl,4(%edi)
	movb	%bh,5(%edi)
	movb	%dl,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs76:
	movb	%dl,(%edi)
	movb	%bh,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%dl,4(%edi)
	movb	%bh,5(%edi)
	movb	%bh,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs77:
	movb	%dl,(%edi)
	movb	%bh,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%dl,4(%edi)
	movb	%bh,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs78:
	movb	%dl,(%edi)
	movb	%bh,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%bh,4(%edi)
	movb	%dl,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs79:
	movb	%dl,(%edi)
	movb	%bh,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%bh,4(%edi)
	movb	%dl,5(%edi)
	movb	%dl,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs7A:
	movb	%dl,(%edi)
	movb	%bh,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%bh,4(%edi)
	movb	%dl,5(%edi)
	movb	%bh,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs7B:
	movb	%dl,(%edi)
	movb	%bh,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%bh,4(%edi)
	movb	%dl,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs7C:
	movb	%dl,(%edi)
	movb	%bh,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs7D:
	movb	%dl,(%edi)
	movb	%bh,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%dl,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs7E:
	movb	%dl,(%edi)
	movb	%bh,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%bh,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs7F:
	movb	%dl,(%edi)
	movb	%bh,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs80:
	movb	%bh,(%edi)
	movb	%dl,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs81:
	movb	%bh,(%edi)
	movb	%dl,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%dl,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs82:
	movb	%bh,(%edi)
	movb	%dl,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%bh,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs83:
	movb	%bh,(%edi)
	movb	%dl,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs84:
	movb	%bh,(%edi)
	movb	%dl,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%dl,4(%edi)
	movb	%bh,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs85:
	movb	%bh,(%edi)
	movb	%dl,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%dl,4(%edi)
	movb	%bh,5(%edi)
	movb	%dl,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs86:
	movb	%bh,(%edi)
	movb	%dl,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%dl,4(%edi)
	movb	%bh,5(%edi)
	movb	%bh,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs87:
	movb	%bh,(%edi)
	movb	%dl,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%dl,4(%edi)
	movb	%bh,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs88:
	movb	%bh,(%edi)
	movb	%dl,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%bh,4(%edi)
	movb	%dl,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs89:
	movb	%bh,(%edi)
	movb	%dl,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%bh,4(%edi)
	movb	%dl,5(%edi)
	movb	%dl,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs8A:
	movb	%bh,(%edi)
	movb	%dl,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%bh,4(%edi)
	movb	%dl,5(%edi)
	movb	%bh,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs8B:
	movb	%bh,(%edi)
	movb	%dl,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%bh,4(%edi)
	movb	%dl,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs8C:
	movb	%bh,(%edi)
	movb	%dl,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs8D:
	movb	%bh,(%edi)
	movb	%dl,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%dl,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs8E:
	movb	%bh,(%edi)
	movb	%dl,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%bh,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs8F:
	movb	%bh,(%edi)
	movb	%dl,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs90:
	movb	%bh,(%edi)
	movb	%dl,1(%edi)
	movb	%dl,2(%edi)
	movb	%bh,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs91:
	movb	%bh,(%edi)
	movb	%dl,1(%edi)
	movb	%dl,2(%edi)
	movb	%bh,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%dl,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs92:
	movb	%bh,(%edi)
	movb	%dl,1(%edi)
	movb	%dl,2(%edi)
	movb	%bh,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%bh,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs93:
	movb	%bh,(%edi)
	movb	%dl,1(%edi)
	movb	%dl,2(%edi)
	movb	%bh,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs94:
	movb	%bh,(%edi)
	movb	%dl,1(%edi)
	movb	%dl,2(%edi)
	movb	%bh,3(%edi)
	movb	%dl,4(%edi)
	movb	%bh,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs95:
	movb	%bh,(%edi)
	movb	%dl,1(%edi)
	movb	%dl,2(%edi)
	movb	%bh,3(%edi)
	movb	%dl,4(%edi)
	movb	%bh,5(%edi)
	movb	%dl,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs96:
	movb	%bh,(%edi)
	movb	%dl,1(%edi)
	movb	%dl,2(%edi)
	movb	%bh,3(%edi)
	movb	%dl,4(%edi)
	movb	%bh,5(%edi)
	movb	%bh,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs97:
	movb	%bh,(%edi)
	movb	%dl,1(%edi)
	movb	%dl,2(%edi)
	movb	%bh,3(%edi)
	movb	%dl,4(%edi)
	movb	%bh,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs98:
	movb	%bh,(%edi)
	movb	%dl,1(%edi)
	movb	%dl,2(%edi)
	movb	%bh,3(%edi)
	movb	%bh,4(%edi)
	movb	%dl,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs99:
	movb	%bh,(%edi)
	movb	%dl,1(%edi)
	movb	%dl,2(%edi)
	movb	%bh,3(%edi)
	movb	%bh,4(%edi)
	movb	%dl,5(%edi)
	movb	%dl,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs9A:
	movb	%bh,(%edi)
	movb	%dl,1(%edi)
	movb	%dl,2(%edi)
	movb	%bh,3(%edi)
	movb	%bh,4(%edi)
	movb	%dl,5(%edi)
	movb	%bh,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs9B:
	movb	%bh,(%edi)
	movb	%dl,1(%edi)
	movb	%dl,2(%edi)
	movb	%bh,3(%edi)
	movb	%bh,4(%edi)
	movb	%dl,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs9C:
	movb	%bh,(%edi)
	movb	%dl,1(%edi)
	movb	%dl,2(%edi)
	movb	%bh,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs9D:
	movb	%bh,(%edi)
	movb	%dl,1(%edi)
	movb	%dl,2(%edi)
	movb	%bh,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%dl,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs9E:
	movb	%bh,(%edi)
	movb	%dl,1(%edi)
	movb	%dl,2(%edi)
	movb	%bh,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%bh,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXs9F:
	movb	%bh,(%edi)
	movb	%dl,1(%edi)
	movb	%dl,2(%edi)
	movb	%bh,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXsA0:
	movb	%bh,(%edi)
	movb	%dl,1(%edi)
	movb	%bh,2(%edi)
	movb	%dl,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXsA1:
	movb	%bh,(%edi)
	movb	%dl,1(%edi)
	movb	%bh,2(%edi)
	movb	%dl,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%dl,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXsA2:
	movb	%bh,(%edi)
	movb	%dl,1(%edi)
	movb	%bh,2(%edi)
	movb	%dl,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%bh,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXsA3:
	movb	%bh,(%edi)
	movb	%dl,1(%edi)
	movb	%bh,2(%edi)
	movb	%dl,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXsA4:
	movb	%bh,(%edi)
	movb	%dl,1(%edi)
	movb	%bh,2(%edi)
	movb	%dl,3(%edi)
	movb	%dl,4(%edi)
	movb	%bh,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXsA5:
	movb	%bh,(%edi)
	movb	%dl,1(%edi)
	movb	%bh,2(%edi)
	movb	%dl,3(%edi)
	movb	%dl,4(%edi)
	movb	%bh,5(%edi)
	movb	%dl,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXsA6:
	movb	%bh,(%edi)
	movb	%dl,1(%edi)
	movb	%bh,2(%edi)
	movb	%dl,3(%edi)
	movb	%dl,4(%edi)
	movb	%bh,5(%edi)
	movb	%bh,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXsA7:
	movb	%bh,(%edi)
	movb	%dl,1(%edi)
	movb	%bh,2(%edi)
	movb	%dl,3(%edi)
	movb	%dl,4(%edi)
	movb	%bh,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXsA8:
	movb	%bh,(%edi)
	movb	%dl,1(%edi)
	movb	%bh,2(%edi)
	movb	%dl,3(%edi)
	movb	%bh,4(%edi)
	movb	%dl,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXsA9:
	movb	%bh,(%edi)
	movb	%dl,1(%edi)
	movb	%bh,2(%edi)
	movb	%dl,3(%edi)
	movb	%bh,4(%edi)
	movb	%dl,5(%edi)
	movb	%dl,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXsAA:
	movb	%bh,(%edi)
	movb	%dl,1(%edi)
	movb	%bh,2(%edi)
	movb	%dl,3(%edi)
	movb	%bh,4(%edi)
	movb	%dl,5(%edi)
	movb	%bh,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXsAB:
	movb	%bh,(%edi)
	movb	%dl,1(%edi)
	movb	%bh,2(%edi)
	movb	%dl,3(%edi)
	movb	%bh,4(%edi)
	movb	%dl,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXsAC:
	movb	%bh,(%edi)
	movb	%dl,1(%edi)
	movb	%bh,2(%edi)
	movb	%dl,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXsAD:
	movb	%bh,(%edi)
	movb	%dl,1(%edi)
	movb	%bh,2(%edi)
	movb	%dl,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%dl,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXsAE:
	movb	%bh,(%edi)
	movb	%dl,1(%edi)
	movb	%bh,2(%edi)
	movb	%dl,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%bh,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXsAF:
	movb	%bh,(%edi)
	movb	%dl,1(%edi)
	movb	%bh,2(%edi)
	movb	%dl,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXsB0:
	movb	%bh,(%edi)
	movb	%dl,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXsB1:
	movb	%bh,(%edi)
	movb	%dl,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%dl,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXsB2:
	movb	%bh,(%edi)
	movb	%dl,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%bh,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXsB3:
	movb	%bh,(%edi)
	movb	%dl,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXsB4:
	movb	%bh,(%edi)
	movb	%dl,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%dl,4(%edi)
	movb	%bh,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXsB5:
	movb	%bh,(%edi)
	movb	%dl,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%dl,4(%edi)
	movb	%bh,5(%edi)
	movb	%dl,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXsB6:
	movb	%bh,(%edi)
	movb	%dl,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%dl,4(%edi)
	movb	%bh,5(%edi)
	movb	%bh,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXsB7:
	movb	%bh,(%edi)
	movb	%dl,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%dl,4(%edi)
	movb	%bh,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXsB8:
	movb	%bh,(%edi)
	movb	%dl,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%bh,4(%edi)
	movb	%dl,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXsB9:
	movb	%bh,(%edi)
	movb	%dl,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%bh,4(%edi)
	movb	%dl,5(%edi)
	movb	%dl,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXsBA:
	movb	%bh,(%edi)
	movb	%dl,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%bh,4(%edi)
	movb	%dl,5(%edi)
	movb	%bh,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXsBB:
	movb	%bh,(%edi)
	movb	%dl,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%bh,4(%edi)
	movb	%dl,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXsBC:
	movb	%bh,(%edi)
	movb	%dl,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXsBD:
	movb	%bh,(%edi)
	movb	%dl,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%dl,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXsBE:
	movb	%bh,(%edi)
	movb	%dl,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%bh,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXsBF:
	movb	%bh,(%edi)
	movb	%dl,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXsC0:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXsC1:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%dl,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXsC2:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%bh,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXsC3:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXsC4:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%dl,4(%edi)
	movb	%bh,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXsC5:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%dl,4(%edi)
	movb	%bh,5(%edi)
	movb	%dl,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXsC6:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%dl,4(%edi)
	movb	%bh,5(%edi)
	movb	%bh,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXsC7:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%dl,4(%edi)
	movb	%bh,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXsC8:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%bh,4(%edi)
	movb	%dl,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXsC9:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%bh,4(%edi)
	movb	%dl,5(%edi)
	movb	%dl,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXsCA:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%bh,4(%edi)
	movb	%dl,5(%edi)
	movb	%bh,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXsCB:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%bh,4(%edi)
	movb	%dl,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXsCC:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXsCD:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%dl,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXsCE:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%bh,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXsCF:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXsD0:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%dl,2(%edi)
	movb	%bh,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXsD1:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%dl,2(%edi)
	movb	%bh,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%dl,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXsD2:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%dl,2(%edi)
	movb	%bh,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%bh,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXsD3:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%dl,2(%edi)
	movb	%bh,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXsD4:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%dl,2(%edi)
	movb	%bh,3(%edi)
	movb	%dl,4(%edi)
	movb	%bh,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXsD5:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%dl,2(%edi)
	movb	%bh,3(%edi)
	movb	%dl,4(%edi)
	movb	%bh,5(%edi)
	movb	%dl,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXsD6:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%dl,2(%edi)
	movb	%bh,3(%edi)
	movb	%dl,4(%edi)
	movb	%bh,5(%edi)
	movb	%bh,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXsD7:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%dl,2(%edi)
	movb	%bh,3(%edi)
	movb	%dl,4(%edi)
	movb	%bh,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXsD8:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%dl,2(%edi)
	movb	%bh,3(%edi)
	movb	%bh,4(%edi)
	movb	%dl,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXsD9:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%dl,2(%edi)
	movb	%bh,3(%edi)
	movb	%bh,4(%edi)
	movb	%dl,5(%edi)
	movb	%dl,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXsDA:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%dl,2(%edi)
	movb	%bh,3(%edi)
	movb	%bh,4(%edi)
	movb	%dl,5(%edi)
	movb	%bh,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXsDB:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%dl,2(%edi)
	movb	%bh,3(%edi)
	movb	%bh,4(%edi)
	movb	%dl,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXsDC:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%dl,2(%edi)
	movb	%bh,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXsDD:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%dl,2(%edi)
	movb	%bh,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%dl,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXsDE:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%dl,2(%edi)
	movb	%bh,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%bh,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXsDF:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%dl,2(%edi)
	movb	%bh,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXsE0:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%bh,2(%edi)
	movb	%dl,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXsE1:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%bh,2(%edi)
	movb	%dl,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%dl,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXsE2:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%bh,2(%edi)
	movb	%dl,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%bh,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXsE3:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%bh,2(%edi)
	movb	%dl,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXsE4:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%bh,2(%edi)
	movb	%dl,3(%edi)
	movb	%dl,4(%edi)
	movb	%bh,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXsE5:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%bh,2(%edi)
	movb	%dl,3(%edi)
	movb	%dl,4(%edi)
	movb	%bh,5(%edi)
	movb	%dl,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXsE6:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%bh,2(%edi)
	movb	%dl,3(%edi)
	movb	%dl,4(%edi)
	movb	%bh,5(%edi)
	movb	%bh,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXsE7:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%bh,2(%edi)
	movb	%dl,3(%edi)
	movb	%dl,4(%edi)
	movb	%bh,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXsE8:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%bh,2(%edi)
	movb	%dl,3(%edi)
	movb	%bh,4(%edi)
	movb	%dl,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXsE9:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%bh,2(%edi)
	movb	%dl,3(%edi)
	movb	%bh,4(%edi)
	movb	%dl,5(%edi)
	movb	%dl,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXsEA:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%bh,2(%edi)
	movb	%dl,3(%edi)
	movb	%bh,4(%edi)
	movb	%dl,5(%edi)
	movb	%bh,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXsEB:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%bh,2(%edi)
	movb	%dl,3(%edi)
	movb	%bh,4(%edi)
	movb	%dl,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXsEC:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%bh,2(%edi)
	movb	%dl,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXsED:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%bh,2(%edi)
	movb	%dl,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%dl,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXsEE:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%bh,2(%edi)
	movb	%dl,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%bh,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXsEF:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%bh,2(%edi)
	movb	%dl,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXsF0:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXsF1:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%dl,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXsF2:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%bh,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXsF3:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXsF4:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%dl,4(%edi)
	movb	%bh,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXsF5:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%dl,4(%edi)
	movb	%bh,5(%edi)
	movb	%dl,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXsF6:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%dl,4(%edi)
	movb	%bh,5(%edi)
	movb	%bh,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXsF7:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%dl,4(%edi)
	movb	%bh,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXsF8:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%bh,4(%edi)
	movb	%dl,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXsF9:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%bh,4(%edi)
	movb	%dl,5(%edi)
	movb	%dl,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXsFA:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%bh,4(%edi)
	movb	%dl,5(%edi)
	movb	%bh,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXsFB:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%bh,4(%edi)
	movb	%dl,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXsFC:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXsFD:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%dl,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXsFE:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%bh,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXsFF:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LLXm00:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm01:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%dh,6(%edi)
	movb	%dh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm02:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%bl,6(%edi)
	movb	%bl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm03:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm04:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%dh,4(%edi)
	movb	%dh,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm05:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%dh,4(%edi)
	movb	%dh,5(%edi)
	movb	%dh,6(%edi)
	movb	%dh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm06:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%dh,4(%edi)
	movb	%dh,5(%edi)
	movb	%bl,6(%edi)
	movb	%bl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm07:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%dh,4(%edi)
	movb	%dh,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm08:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%bl,4(%edi)
	movb	%bl,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm09:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%bl,4(%edi)
	movb	%bl,5(%edi)
	movb	%dh,6(%edi)
	movb	%dh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm0A:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%bl,4(%edi)
	movb	%bl,5(%edi)
	movb	%bl,6(%edi)
	movb	%bl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm0B:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%bl,4(%edi)
	movb	%bl,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm0C:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm0D:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%dh,6(%edi)
	movb	%dh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm0E:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%bl,6(%edi)
	movb	%bl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm0F:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm10:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%dh,2(%edi)
	movb	%dh,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm11:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%dh,2(%edi)
	movb	%dh,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%dh,6(%edi)
	movb	%dh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm12:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%dh,2(%edi)
	movb	%dh,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%bl,6(%edi)
	movb	%bl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm13:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%dh,2(%edi)
	movb	%dh,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm14:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%dh,2(%edi)
	movb	%dh,3(%edi)
	movb	%dh,4(%edi)
	movb	%dh,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm15:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%dh,2(%edi)
	movb	%dh,3(%edi)
	movb	%dh,4(%edi)
	movb	%dh,5(%edi)
	movb	%dh,6(%edi)
	movb	%dh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm16:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%dh,2(%edi)
	movb	%dh,3(%edi)
	movb	%dh,4(%edi)
	movb	%dh,5(%edi)
	movb	%bl,6(%edi)
	movb	%bl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm17:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%dh,2(%edi)
	movb	%dh,3(%edi)
	movb	%dh,4(%edi)
	movb	%dh,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm18:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%dh,2(%edi)
	movb	%dh,3(%edi)
	movb	%bl,4(%edi)
	movb	%bl,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm19:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%dh,2(%edi)
	movb	%dh,3(%edi)
	movb	%bl,4(%edi)
	movb	%bl,5(%edi)
	movb	%dh,6(%edi)
	movb	%dh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm1A:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%dh,2(%edi)
	movb	%dh,3(%edi)
	movb	%bl,4(%edi)
	movb	%bl,5(%edi)
	movb	%bl,6(%edi)
	movb	%bl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm1B:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%dh,2(%edi)
	movb	%dh,3(%edi)
	movb	%bl,4(%edi)
	movb	%bl,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm1C:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%dh,2(%edi)
	movb	%dh,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm1D:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%dh,2(%edi)
	movb	%dh,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%dh,6(%edi)
	movb	%dh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm1E:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%dh,2(%edi)
	movb	%dh,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%bl,6(%edi)
	movb	%bl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm1F:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%dh,2(%edi)
	movb	%dh,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm20:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%bl,2(%edi)
	movb	%bl,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm21:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%bl,2(%edi)
	movb	%bl,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%dh,6(%edi)
	movb	%dh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm22:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%bl,2(%edi)
	movb	%bl,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%bl,6(%edi)
	movb	%bl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm23:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%bl,2(%edi)
	movb	%bl,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm24:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%bl,2(%edi)
	movb	%bl,3(%edi)
	movb	%dh,4(%edi)
	movb	%dh,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm25:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%bl,2(%edi)
	movb	%bl,3(%edi)
	movb	%dh,4(%edi)
	movb	%dh,5(%edi)
	movb	%dh,6(%edi)
	movb	%dh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm26:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%bl,2(%edi)
	movb	%bl,3(%edi)
	movb	%dh,4(%edi)
	movb	%dh,5(%edi)
	movb	%bl,6(%edi)
	movb	%bl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm27:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%bl,2(%edi)
	movb	%bl,3(%edi)
	movb	%dh,4(%edi)
	movb	%dh,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm28:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%bl,2(%edi)
	movb	%bl,3(%edi)
	movb	%bl,4(%edi)
	movb	%bl,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm29:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%bl,2(%edi)
	movb	%bl,3(%edi)
	movb	%bl,4(%edi)
	movb	%bl,5(%edi)
	movb	%dh,6(%edi)
	movb	%dh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm2A:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%bl,2(%edi)
	movb	%bl,3(%edi)
	movb	%bl,4(%edi)
	movb	%bl,5(%edi)
	movb	%bl,6(%edi)
	movb	%bl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm2B:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%bl,2(%edi)
	movb	%bl,3(%edi)
	movb	%bl,4(%edi)
	movb	%bl,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm2C:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%bl,2(%edi)
	movb	%bl,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm2D:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%bl,2(%edi)
	movb	%bl,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%dh,6(%edi)
	movb	%dh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm2E:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%bl,2(%edi)
	movb	%bl,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%bl,6(%edi)
	movb	%bl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm2F:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%bl,2(%edi)
	movb	%bl,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm30:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm31:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%dh,6(%edi)
	movb	%dh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm32:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%bl,6(%edi)
	movb	%bl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm33:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm34:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%dh,4(%edi)
	movb	%dh,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm35:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%dh,4(%edi)
	movb	%dh,5(%edi)
	movb	%dh,6(%edi)
	movb	%dh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm36:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%dh,4(%edi)
	movb	%dh,5(%edi)
	movb	%bl,6(%edi)
	movb	%bl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm37:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%dh,4(%edi)
	movb	%dh,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm38:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%bl,4(%edi)
	movb	%bl,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm39:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%bl,4(%edi)
	movb	%bl,5(%edi)
	movb	%dh,6(%edi)
	movb	%dh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm3A:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%bl,4(%edi)
	movb	%bl,5(%edi)
	movb	%bl,6(%edi)
	movb	%bl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm3B:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%bl,4(%edi)
	movb	%bl,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm3C:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm3D:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%dh,6(%edi)
	movb	%dh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm3E:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%bl,6(%edi)
	movb	%bl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm3F:
	movb	%dl,(%edi)
	movb	%dl,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm40:
	movb	%dh,(%edi)
	movb	%dh,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm41:
	movb	%dh,(%edi)
	movb	%dh,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%dh,6(%edi)
	movb	%dh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm42:
	movb	%dh,(%edi)
	movb	%dh,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%bl,6(%edi)
	movb	%bl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm43:
	movb	%dh,(%edi)
	movb	%dh,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm44:
	movb	%dh,(%edi)
	movb	%dh,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%dh,4(%edi)
	movb	%dh,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm45:
	movb	%dh,(%edi)
	movb	%dh,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%dh,4(%edi)
	movb	%dh,5(%edi)
	movb	%dh,6(%edi)
	movb	%dh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm46:
	movb	%dh,(%edi)
	movb	%dh,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%dh,4(%edi)
	movb	%dh,5(%edi)
	movb	%bl,6(%edi)
	movb	%bl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm47:
	movb	%dh,(%edi)
	movb	%dh,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%dh,4(%edi)
	movb	%dh,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm48:
	movb	%dh,(%edi)
	movb	%dh,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%bl,4(%edi)
	movb	%bl,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm49:
	movb	%dh,(%edi)
	movb	%dh,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%bl,4(%edi)
	movb	%bl,5(%edi)
	movb	%dh,6(%edi)
	movb	%dh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm4A:
	movb	%dh,(%edi)
	movb	%dh,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%bl,4(%edi)
	movb	%bl,5(%edi)
	movb	%bl,6(%edi)
	movb	%bl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm4B:
	movb	%dh,(%edi)
	movb	%dh,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%bl,4(%edi)
	movb	%bl,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm4C:
	movb	%dh,(%edi)
	movb	%dh,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm4D:
	movb	%dh,(%edi)
	movb	%dh,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%dh,6(%edi)
	movb	%dh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm4E:
	movb	%dh,(%edi)
	movb	%dh,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%bl,6(%edi)
	movb	%bl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm4F:
	movb	%dh,(%edi)
	movb	%dh,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm50:
	movb	%dh,(%edi)
	movb	%dh,1(%edi)
	movb	%dh,2(%edi)
	movb	%dh,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm51:
	movb	%dh,(%edi)
	movb	%dh,1(%edi)
	movb	%dh,2(%edi)
	movb	%dh,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%dh,6(%edi)
	movb	%dh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm52:
	movb	%dh,(%edi)
	movb	%dh,1(%edi)
	movb	%dh,2(%edi)
	movb	%dh,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%bl,6(%edi)
	movb	%bl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm53:
	movb	%dh,(%edi)
	movb	%dh,1(%edi)
	movb	%dh,2(%edi)
	movb	%dh,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm54:
	movb	%dh,(%edi)
	movb	%dh,1(%edi)
	movb	%dh,2(%edi)
	movb	%dh,3(%edi)
	movb	%dh,4(%edi)
	movb	%dh,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm55:
	movb	%dh,(%edi)
	movb	%dh,1(%edi)
	movb	%dh,2(%edi)
	movb	%dh,3(%edi)
	movb	%dh,4(%edi)
	movb	%dh,5(%edi)
	movb	%dh,6(%edi)
	movb	%dh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm56:
	movb	%dh,(%edi)
	movb	%dh,1(%edi)
	movb	%dh,2(%edi)
	movb	%dh,3(%edi)
	movb	%dh,4(%edi)
	movb	%dh,5(%edi)
	movb	%bl,6(%edi)
	movb	%bl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm57:
	movb	%dh,(%edi)
	movb	%dh,1(%edi)
	movb	%dh,2(%edi)
	movb	%dh,3(%edi)
	movb	%dh,4(%edi)
	movb	%dh,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm58:
	movb	%dh,(%edi)
	movb	%dh,1(%edi)
	movb	%dh,2(%edi)
	movb	%dh,3(%edi)
	movb	%bl,4(%edi)
	movb	%bl,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm59:
	movb	%dh,(%edi)
	movb	%dh,1(%edi)
	movb	%dh,2(%edi)
	movb	%dh,3(%edi)
	movb	%bl,4(%edi)
	movb	%bl,5(%edi)
	movb	%dh,6(%edi)
	movb	%dh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm5A:
	movb	%dh,(%edi)
	movb	%dh,1(%edi)
	movb	%dh,2(%edi)
	movb	%dh,3(%edi)
	movb	%bl,4(%edi)
	movb	%bl,5(%edi)
	movb	%bl,6(%edi)
	movb	%bl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm5B:
	movb	%dh,(%edi)
	movb	%dh,1(%edi)
	movb	%dh,2(%edi)
	movb	%dh,3(%edi)
	movb	%bl,4(%edi)
	movb	%bl,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm5C:
	movb	%dh,(%edi)
	movb	%dh,1(%edi)
	movb	%dh,2(%edi)
	movb	%dh,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm5D:
	movb	%dh,(%edi)
	movb	%dh,1(%edi)
	movb	%dh,2(%edi)
	movb	%dh,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%dh,6(%edi)
	movb	%dh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm5E:
	movb	%dh,(%edi)
	movb	%dh,1(%edi)
	movb	%dh,2(%edi)
	movb	%dh,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%bl,6(%edi)
	movb	%bl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm5F:
	movb	%dh,(%edi)
	movb	%dh,1(%edi)
	movb	%dh,2(%edi)
	movb	%dh,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm60:
	movb	%dh,(%edi)
	movb	%dh,1(%edi)
	movb	%bl,2(%edi)
	movb	%bl,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm61:
	movb	%dh,(%edi)
	movb	%dh,1(%edi)
	movb	%bl,2(%edi)
	movb	%bl,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%dh,6(%edi)
	movb	%dh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm62:
	movb	%dh,(%edi)
	movb	%dh,1(%edi)
	movb	%bl,2(%edi)
	movb	%bl,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%bl,6(%edi)
	movb	%bl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm63:
	movb	%dh,(%edi)
	movb	%dh,1(%edi)
	movb	%bl,2(%edi)
	movb	%bl,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm64:
	movb	%dh,(%edi)
	movb	%dh,1(%edi)
	movb	%bl,2(%edi)
	movb	%bl,3(%edi)
	movb	%dh,4(%edi)
	movb	%dh,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm65:
	movb	%dh,(%edi)
	movb	%dh,1(%edi)
	movb	%bl,2(%edi)
	movb	%bl,3(%edi)
	movb	%dh,4(%edi)
	movb	%dh,5(%edi)
	movb	%dh,6(%edi)
	movb	%dh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm66:
	movb	%dh,(%edi)
	movb	%dh,1(%edi)
	movb	%bl,2(%edi)
	movb	%bl,3(%edi)
	movb	%dh,4(%edi)
	movb	%dh,5(%edi)
	movb	%bl,6(%edi)
	movb	%bl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm67:
	movb	%dh,(%edi)
	movb	%dh,1(%edi)
	movb	%bl,2(%edi)
	movb	%bl,3(%edi)
	movb	%dh,4(%edi)
	movb	%dh,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm68:
	movb	%dh,(%edi)
	movb	%dh,1(%edi)
	movb	%bl,2(%edi)
	movb	%bl,3(%edi)
	movb	%bl,4(%edi)
	movb	%bl,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm69:
	movb	%dh,(%edi)
	movb	%dh,1(%edi)
	movb	%bl,2(%edi)
	movb	%bl,3(%edi)
	movb	%bl,4(%edi)
	movb	%bl,5(%edi)
	movb	%dh,6(%edi)
	movb	%dh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm6A:
	movb	%dh,(%edi)
	movb	%dh,1(%edi)
	movb	%bl,2(%edi)
	movb	%bl,3(%edi)
	movb	%bl,4(%edi)
	movb	%bl,5(%edi)
	movb	%bl,6(%edi)
	movb	%bl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm6B:
	movb	%dh,(%edi)
	movb	%dh,1(%edi)
	movb	%bl,2(%edi)
	movb	%bl,3(%edi)
	movb	%bl,4(%edi)
	movb	%bl,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm6C:
	movb	%dh,(%edi)
	movb	%dh,1(%edi)
	movb	%bl,2(%edi)
	movb	%bl,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm6D:
	movb	%dh,(%edi)
	movb	%dh,1(%edi)
	movb	%bl,2(%edi)
	movb	%bl,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%dh,6(%edi)
	movb	%dh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm6E:
	movb	%dh,(%edi)
	movb	%dh,1(%edi)
	movb	%bl,2(%edi)
	movb	%bl,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%bl,6(%edi)
	movb	%bl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm6F:
	movb	%dh,(%edi)
	movb	%dh,1(%edi)
	movb	%bl,2(%edi)
	movb	%bl,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm70:
	movb	%dh,(%edi)
	movb	%dh,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm71:
	movb	%dh,(%edi)
	movb	%dh,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%dh,6(%edi)
	movb	%dh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm72:
	movb	%dh,(%edi)
	movb	%dh,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%bl,6(%edi)
	movb	%bl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm73:
	movb	%dh,(%edi)
	movb	%dh,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm74:
	movb	%dh,(%edi)
	movb	%dh,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%dh,4(%edi)
	movb	%dh,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm75:
	movb	%dh,(%edi)
	movb	%dh,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%dh,4(%edi)
	movb	%dh,5(%edi)
	movb	%dh,6(%edi)
	movb	%dh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm76:
	movb	%dh,(%edi)
	movb	%dh,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%dh,4(%edi)
	movb	%dh,5(%edi)
	movb	%bl,6(%edi)
	movb	%bl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm77:
	movb	%dh,(%edi)
	movb	%dh,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%dh,4(%edi)
	movb	%dh,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm78:
	movb	%dh,(%edi)
	movb	%dh,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%bl,4(%edi)
	movb	%bl,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm79:
	movb	%dh,(%edi)
	movb	%dh,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%bl,4(%edi)
	movb	%bl,5(%edi)
	movb	%dh,6(%edi)
	movb	%dh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm7A:
	movb	%dh,(%edi)
	movb	%dh,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%bl,4(%edi)
	movb	%bl,5(%edi)
	movb	%bl,6(%edi)
	movb	%bl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm7B:
	movb	%dh,(%edi)
	movb	%dh,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%bl,4(%edi)
	movb	%bl,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm7C:
	movb	%dh,(%edi)
	movb	%dh,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm7D:
	movb	%dh,(%edi)
	movb	%dh,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%dh,6(%edi)
	movb	%dh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm7E:
	movb	%dh,(%edi)
	movb	%dh,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%bl,6(%edi)
	movb	%bl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm7F:
	movb	%dh,(%edi)
	movb	%dh,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm80:
	movb	%bl,(%edi)
	movb	%bl,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm81:
	movb	%bl,(%edi)
	movb	%bl,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%dh,6(%edi)
	movb	%dh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm82:
	movb	%bl,(%edi)
	movb	%bl,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%bl,6(%edi)
	movb	%bl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm83:
	movb	%bl,(%edi)
	movb	%bl,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm84:
	movb	%bl,(%edi)
	movb	%bl,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%dh,4(%edi)
	movb	%dh,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm85:
	movb	%bl,(%edi)
	movb	%bl,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%dh,4(%edi)
	movb	%dh,5(%edi)
	movb	%dh,6(%edi)
	movb	%dh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm86:
	movb	%bl,(%edi)
	movb	%bl,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%dh,4(%edi)
	movb	%dh,5(%edi)
	movb	%bl,6(%edi)
	movb	%bl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm87:
	movb	%bl,(%edi)
	movb	%bl,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%dh,4(%edi)
	movb	%dh,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm88:
	movb	%bl,(%edi)
	movb	%bl,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%bl,4(%edi)
	movb	%bl,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm89:
	movb	%bl,(%edi)
	movb	%bl,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%bl,4(%edi)
	movb	%bl,5(%edi)
	movb	%dh,6(%edi)
	movb	%dh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm8A:
	movb	%bl,(%edi)
	movb	%bl,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%bl,4(%edi)
	movb	%bl,5(%edi)
	movb	%bl,6(%edi)
	movb	%bl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm8B:
	movb	%bl,(%edi)
	movb	%bl,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%bl,4(%edi)
	movb	%bl,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm8C:
	movb	%bl,(%edi)
	movb	%bl,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm8D:
	movb	%bl,(%edi)
	movb	%bl,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%dh,6(%edi)
	movb	%dh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm8E:
	movb	%bl,(%edi)
	movb	%bl,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%bl,6(%edi)
	movb	%bl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm8F:
	movb	%bl,(%edi)
	movb	%bl,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm90:
	movb	%bl,(%edi)
	movb	%bl,1(%edi)
	movb	%dh,2(%edi)
	movb	%dh,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm91:
	movb	%bl,(%edi)
	movb	%bl,1(%edi)
	movb	%dh,2(%edi)
	movb	%dh,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%dh,6(%edi)
	movb	%dh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm92:
	movb	%bl,(%edi)
	movb	%bl,1(%edi)
	movb	%dh,2(%edi)
	movb	%dh,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%bl,6(%edi)
	movb	%bl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm93:
	movb	%bl,(%edi)
	movb	%bl,1(%edi)
	movb	%dh,2(%edi)
	movb	%dh,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm94:
	movb	%bl,(%edi)
	movb	%bl,1(%edi)
	movb	%dh,2(%edi)
	movb	%dh,3(%edi)
	movb	%dh,4(%edi)
	movb	%dh,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm95:
	movb	%bl,(%edi)
	movb	%bl,1(%edi)
	movb	%dh,2(%edi)
	movb	%dh,3(%edi)
	movb	%dh,4(%edi)
	movb	%dh,5(%edi)
	movb	%dh,6(%edi)
	movb	%dh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm96:
	movb	%bl,(%edi)
	movb	%bl,1(%edi)
	movb	%dh,2(%edi)
	movb	%dh,3(%edi)
	movb	%dh,4(%edi)
	movb	%dh,5(%edi)
	movb	%bl,6(%edi)
	movb	%bl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm97:
	movb	%bl,(%edi)
	movb	%bl,1(%edi)
	movb	%dh,2(%edi)
	movb	%dh,3(%edi)
	movb	%dh,4(%edi)
	movb	%dh,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm98:
	movb	%bl,(%edi)
	movb	%bl,1(%edi)
	movb	%dh,2(%edi)
	movb	%dh,3(%edi)
	movb	%bl,4(%edi)
	movb	%bl,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm99:
	movb	%bl,(%edi)
	movb	%bl,1(%edi)
	movb	%dh,2(%edi)
	movb	%dh,3(%edi)
	movb	%bl,4(%edi)
	movb	%bl,5(%edi)
	movb	%dh,6(%edi)
	movb	%dh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm9A:
	movb	%bl,(%edi)
	movb	%bl,1(%edi)
	movb	%dh,2(%edi)
	movb	%dh,3(%edi)
	movb	%bl,4(%edi)
	movb	%bl,5(%edi)
	movb	%bl,6(%edi)
	movb	%bl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm9B:
	movb	%bl,(%edi)
	movb	%bl,1(%edi)
	movb	%dh,2(%edi)
	movb	%dh,3(%edi)
	movb	%bl,4(%edi)
	movb	%bl,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm9C:
	movb	%bl,(%edi)
	movb	%bl,1(%edi)
	movb	%dh,2(%edi)
	movb	%dh,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm9D:
	movb	%bl,(%edi)
	movb	%bl,1(%edi)
	movb	%dh,2(%edi)
	movb	%dh,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%dh,6(%edi)
	movb	%dh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm9E:
	movb	%bl,(%edi)
	movb	%bl,1(%edi)
	movb	%dh,2(%edi)
	movb	%dh,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%bl,6(%edi)
	movb	%bl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXm9F:
	movb	%bl,(%edi)
	movb	%bl,1(%edi)
	movb	%dh,2(%edi)
	movb	%dh,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXmA0:
	movb	%bl,(%edi)
	movb	%bl,1(%edi)
	movb	%bl,2(%edi)
	movb	%bl,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXmA1:
	movb	%bl,(%edi)
	movb	%bl,1(%edi)
	movb	%bl,2(%edi)
	movb	%bl,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%dh,6(%edi)
	movb	%dh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXmA2:
	movb	%bl,(%edi)
	movb	%bl,1(%edi)
	movb	%bl,2(%edi)
	movb	%bl,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%bl,6(%edi)
	movb	%bl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXmA3:
	movb	%bl,(%edi)
	movb	%bl,1(%edi)
	movb	%bl,2(%edi)
	movb	%bl,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXmA4:
	movb	%bl,(%edi)
	movb	%bl,1(%edi)
	movb	%bl,2(%edi)
	movb	%bl,3(%edi)
	movb	%dh,4(%edi)
	movb	%dh,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXmA5:
	movb	%bl,(%edi)
	movb	%bl,1(%edi)
	movb	%bl,2(%edi)
	movb	%bl,3(%edi)
	movb	%dh,4(%edi)
	movb	%dh,5(%edi)
	movb	%dh,6(%edi)
	movb	%dh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXmA6:
	movb	%bl,(%edi)
	movb	%bl,1(%edi)
	movb	%bl,2(%edi)
	movb	%bl,3(%edi)
	movb	%dh,4(%edi)
	movb	%dh,5(%edi)
	movb	%bl,6(%edi)
	movb	%bl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXmA7:
	movb	%bl,(%edi)
	movb	%bl,1(%edi)
	movb	%bl,2(%edi)
	movb	%bl,3(%edi)
	movb	%dh,4(%edi)
	movb	%dh,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXmA8:
	movb	%bl,(%edi)
	movb	%bl,1(%edi)
	movb	%bl,2(%edi)
	movb	%bl,3(%edi)
	movb	%bl,4(%edi)
	movb	%bl,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXmA9:
	movb	%bl,(%edi)
	movb	%bl,1(%edi)
	movb	%bl,2(%edi)
	movb	%bl,3(%edi)
	movb	%bl,4(%edi)
	movb	%bl,5(%edi)
	movb	%dh,6(%edi)
	movb	%dh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXmAA:
	movb	%bl,(%edi)
	movb	%bl,1(%edi)
	movb	%bl,2(%edi)
	movb	%bl,3(%edi)
	movb	%bl,4(%edi)
	movb	%bl,5(%edi)
	movb	%bl,6(%edi)
	movb	%bl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXmAB:
	movb	%bl,(%edi)
	movb	%bl,1(%edi)
	movb	%bl,2(%edi)
	movb	%bl,3(%edi)
	movb	%bl,4(%edi)
	movb	%bl,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXmAC:
	movb	%bl,(%edi)
	movb	%bl,1(%edi)
	movb	%bl,2(%edi)
	movb	%bl,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXmAD:
	movb	%bl,(%edi)
	movb	%bl,1(%edi)
	movb	%bl,2(%edi)
	movb	%bl,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%dh,6(%edi)
	movb	%dh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXmAE:
	movb	%bl,(%edi)
	movb	%bl,1(%edi)
	movb	%bl,2(%edi)
	movb	%bl,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%bl,6(%edi)
	movb	%bl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXmAF:
	movb	%bl,(%edi)
	movb	%bl,1(%edi)
	movb	%bl,2(%edi)
	movb	%bl,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXmB0:
	movb	%bl,(%edi)
	movb	%bl,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXmB1:
	movb	%bl,(%edi)
	movb	%bl,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%dh,6(%edi)
	movb	%dh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXmB2:
	movb	%bl,(%edi)
	movb	%bl,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%bl,6(%edi)
	movb	%bl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXmB3:
	movb	%bl,(%edi)
	movb	%bl,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXmB4:
	movb	%bl,(%edi)
	movb	%bl,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%dh,4(%edi)
	movb	%dh,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXmB5:
	movb	%bl,(%edi)
	movb	%bl,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%dh,4(%edi)
	movb	%dh,5(%edi)
	movb	%dh,6(%edi)
	movb	%dh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXmB6:
	movb	%bl,(%edi)
	movb	%bl,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%dh,4(%edi)
	movb	%dh,5(%edi)
	movb	%bl,6(%edi)
	movb	%bl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXmB7:
	movb	%bl,(%edi)
	movb	%bl,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%dh,4(%edi)
	movb	%dh,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXmB8:
	movb	%bl,(%edi)
	movb	%bl,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%bl,4(%edi)
	movb	%bl,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXmB9:
	movb	%bl,(%edi)
	movb	%bl,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%bl,4(%edi)
	movb	%bl,5(%edi)
	movb	%dh,6(%edi)
	movb	%dh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXmBA:
	movb	%bl,(%edi)
	movb	%bl,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%bl,4(%edi)
	movb	%bl,5(%edi)
	movb	%bl,6(%edi)
	movb	%bl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXmBB:
	movb	%bl,(%edi)
	movb	%bl,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%bl,4(%edi)
	movb	%bl,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXmBC:
	movb	%bl,(%edi)
	movb	%bl,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXmBD:
	movb	%bl,(%edi)
	movb	%bl,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%dh,6(%edi)
	movb	%dh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXmBE:
	movb	%bl,(%edi)
	movb	%bl,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%bl,6(%edi)
	movb	%bl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXmBF:
	movb	%bl,(%edi)
	movb	%bl,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXmC0:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXmC1:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%dh,6(%edi)
	movb	%dh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXmC2:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%bl,6(%edi)
	movb	%bl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXmC3:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXmC4:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%dh,4(%edi)
	movb	%dh,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXmC5:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%dh,4(%edi)
	movb	%dh,5(%edi)
	movb	%dh,6(%edi)
	movb	%dh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXmC6:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%dh,4(%edi)
	movb	%dh,5(%edi)
	movb	%bl,6(%edi)
	movb	%bl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXmC7:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%dh,4(%edi)
	movb	%dh,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXmC8:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%bl,4(%edi)
	movb	%bl,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXmC9:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%bl,4(%edi)
	movb	%bl,5(%edi)
	movb	%dh,6(%edi)
	movb	%dh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXmCA:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%bl,4(%edi)
	movb	%bl,5(%edi)
	movb	%bl,6(%edi)
	movb	%bl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXmCB:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%bl,4(%edi)
	movb	%bl,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXmCC:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXmCD:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%dh,6(%edi)
	movb	%dh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXmCE:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%bl,6(%edi)
	movb	%bl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXmCF:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%dl,2(%edi)
	movb	%dl,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXmD0:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%dh,2(%edi)
	movb	%dh,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXmD1:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%dh,2(%edi)
	movb	%dh,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%dh,6(%edi)
	movb	%dh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXmD2:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%dh,2(%edi)
	movb	%dh,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%bl,6(%edi)
	movb	%bl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXmD3:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%dh,2(%edi)
	movb	%dh,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXmD4:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%dh,2(%edi)
	movb	%dh,3(%edi)
	movb	%dh,4(%edi)
	movb	%dh,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXmD5:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%dh,2(%edi)
	movb	%dh,3(%edi)
	movb	%dh,4(%edi)
	movb	%dh,5(%edi)
	movb	%dh,6(%edi)
	movb	%dh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXmD6:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%dh,2(%edi)
	movb	%dh,3(%edi)
	movb	%dh,4(%edi)
	movb	%dh,5(%edi)
	movb	%bl,6(%edi)
	movb	%bl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXmD7:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%dh,2(%edi)
	movb	%dh,3(%edi)
	movb	%dh,4(%edi)
	movb	%dh,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXmD8:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%dh,2(%edi)
	movb	%dh,3(%edi)
	movb	%bl,4(%edi)
	movb	%bl,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXmD9:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%dh,2(%edi)
	movb	%dh,3(%edi)
	movb	%bl,4(%edi)
	movb	%bl,5(%edi)
	movb	%dh,6(%edi)
	movb	%dh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXmDA:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%dh,2(%edi)
	movb	%dh,3(%edi)
	movb	%bl,4(%edi)
	movb	%bl,5(%edi)
	movb	%bl,6(%edi)
	movb	%bl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXmDB:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%dh,2(%edi)
	movb	%dh,3(%edi)
	movb	%bl,4(%edi)
	movb	%bl,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXmDC:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%dh,2(%edi)
	movb	%dh,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXmDD:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%dh,2(%edi)
	movb	%dh,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%dh,6(%edi)
	movb	%dh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXmDE:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%dh,2(%edi)
	movb	%dh,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%bl,6(%edi)
	movb	%bl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXmDF:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%dh,2(%edi)
	movb	%dh,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXmE0:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%bl,2(%edi)
	movb	%bl,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXmE1:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%bl,2(%edi)
	movb	%bl,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%dh,6(%edi)
	movb	%dh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXmE2:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%bl,2(%edi)
	movb	%bl,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%bl,6(%edi)
	movb	%bl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXmE3:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%bl,2(%edi)
	movb	%bl,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXmE4:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%bl,2(%edi)
	movb	%bl,3(%edi)
	movb	%dh,4(%edi)
	movb	%dh,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXmE5:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%bl,2(%edi)
	movb	%bl,3(%edi)
	movb	%dh,4(%edi)
	movb	%dh,5(%edi)
	movb	%dh,6(%edi)
	movb	%dh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXmE6:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%bl,2(%edi)
	movb	%bl,3(%edi)
	movb	%dh,4(%edi)
	movb	%dh,5(%edi)
	movb	%bl,6(%edi)
	movb	%bl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXmE7:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%bl,2(%edi)
	movb	%bl,3(%edi)
	movb	%dh,4(%edi)
	movb	%dh,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXmE8:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%bl,2(%edi)
	movb	%bl,3(%edi)
	movb	%bl,4(%edi)
	movb	%bl,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXmE9:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%bl,2(%edi)
	movb	%bl,3(%edi)
	movb	%bl,4(%edi)
	movb	%bl,5(%edi)
	movb	%dh,6(%edi)
	movb	%dh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXmEA:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%bl,2(%edi)
	movb	%bl,3(%edi)
	movb	%bl,4(%edi)
	movb	%bl,5(%edi)
	movb	%bl,6(%edi)
	movb	%bl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXmEB:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%bl,2(%edi)
	movb	%bl,3(%edi)
	movb	%bl,4(%edi)
	movb	%bl,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXmEC:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%bl,2(%edi)
	movb	%bl,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXmED:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%bl,2(%edi)
	movb	%bl,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%dh,6(%edi)
	movb	%dh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXmEE:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%bl,2(%edi)
	movb	%bl,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%bl,6(%edi)
	movb	%bl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXmEF:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%bl,2(%edi)
	movb	%bl,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXmF0:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXmF1:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%dh,6(%edi)
	movb	%dh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXmF2:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%bl,6(%edi)
	movb	%bl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXmF3:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%dl,4(%edi)
	movb	%dl,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXmF4:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%dh,4(%edi)
	movb	%dh,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXmF5:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%dh,4(%edi)
	movb	%dh,5(%edi)
	movb	%dh,6(%edi)
	movb	%dh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXmF6:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%dh,4(%edi)
	movb	%dh,5(%edi)
	movb	%bl,6(%edi)
	movb	%bl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXmF7:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%dh,4(%edi)
	movb	%dh,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXmF8:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%bl,4(%edi)
	movb	%bl,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXmF9:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%bl,4(%edi)
	movb	%bl,5(%edi)
	movb	%dh,6(%edi)
	movb	%dh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXmFA:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%bl,4(%edi)
	movb	%bl,5(%edi)
	movb	%bl,6(%edi)
	movb	%bl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXmFB:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%bl,4(%edi)
	movb	%bl,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXmFC:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%dl,6(%edi)
	movb	%dl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXmFD:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%dh,6(%edi)
	movb	%dh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXmFE:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%bl,6(%edi)
	movb	%bl,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LXmFF:
	movb	%bh,(%edi)
	movb	%bh,1(%edi)
	movb	%bh,2(%edi)
	movb	%bh,3(%edi)
	movb	%bh,4(%edi)
	movb	%bh,5(%edi)
	movb	%bh,6(%edi)
	movb	%bh,7(%edi)
	addl	$8,%edi
	incl	%ebp
	cmpl	$39,%ebp
	jle	LC1
	jmp	LC2
	.align  ALSIZE64
LC2:
	popl	%ebx
	popl	%esi
	popl	%edi
	popl	%ebp
	ret
