/*
**	The C64 emulator
**
**	Copyright 1996 by ALE.
**	written by Lutz Sammer.
**
**	Mid level interface c64 -> 1541.
**-----------------------------------------------------------------------------
** $Id: iec.c,v 1.1 1996/06/19 00:01:40 johns Exp root $
** $Log: iec.c,v $
** Revision 1.1  1996/06/19 00:01:40  johns
** Initial revision
**
**-----------------------------------------------------------------------------
*/

#include "c64.h"
#include "6502.h"

#include <stdio.h>

#define noIEC_HARD
#define noIEC_EMULATE
#define noIEC_DEBUG

/*---------------------------------------------------------------------------*/

/*
**	PRA: Description
**	7:	Serial bus data input
**	6:	Serial bus clock pulse input
**	5:	Serial bus data output
**	4:	Serial bus clock pulse output
**	3:	Serial bus ATN signal output
**	2:	RS-232 Data output
**	1-0:	VIC Bank select
*/
#define	SIEC_DAT_I	0x80
#define	SIEC_CLK_I	0x40
#define	SIEC_DAT_O	0x20
#define	SIEC_CLK_O	0x10
#define	SIEC_ATN_O	0x08

#ifdef IEC_HARD	/* { */

/*
**	WARNING WARNING WARNING WARNING WARNING WARNING WARNING WARNING
**
**	This is a serial port emulation:
**	which uses a 1541 connected to printer port.
**	This works on my old computers i386 and i486/33!
**	For newer computer (more speed) this must be rewritten.
*/

#if 0
Printer port doco:

DATA:	Base+0
	Out	D7-D0	Printer data
	In	D7-D0	data or input (sometimes)
STAT:	Base+1
		7   6   5   4   3   2   1   0
	In	!11 10  12  13  15  --  --  --	Pin connector
CTRL:	Base+2
		7   6   5   4   3   2   1   0  
	In      --  --  --  Irq !17 16  !14 !1	Pin connector
	Out	--  --  --  Irq !17 16  !14 !1
		Irq out enable
		Irq in  status
#endif

#define LP0_BASE (0x378)		/* Main parallel port */
#define LP1_BASE (0x3BC)		/* Monochrome card parallel port */
#define LP2_BASE (0x278)		/* Second parallel port */

#define LP_BASE LP2_BASE
#define LP_DATA (LP_BASE)
#define LP_STAT (LP_BASE+1)
#define LP_CTRL (LP_BASE+2)

/* SIEC uses Lp control port */
#define LP_DAT	1			/* !Data	Bit-0 Pin-1 */
#define LP_CLK	2			/* !Clock	Bit-1 Pin-14 */
#define LP_RST	4			/*  Reset	Bit-2 Pin-16 */
#define LP_ATN	8			/* !Atn		Bit-3 Pin-17 */

/*
**	Reset connected 1541.
*/
void ResetSIEC(void)
{
    outb(LP_CTRL,0xE0);
    sleep(1);
}

#ifdef 0
static int SIECIN()
{
    unsigned char u;
    unsigned char a;
    int i;

    for( u=i=0; i<8; ++i ) {
	while( !((a=inb(LP_CTRL))&LP_CLK) )
	    ;
	if( !(a&LP_DAT) )
	    u|=0x80;
	u>>=1;
	while( ((a=inb(LP_CTRL))&LP_CLK) )
	    ;
    }
    return u;
}
#endif


/*
**	IEC read serial port trap.
*/
int IEC_ReadPortTrap(void)
{
    int a;
    int r;

    r=0;
    a=inb(LP_CTRL);
    if( a&LP_DAT )
	r|=SIEC_DAT_I;
    if( a&LP_CLK )
	r|=SIEC_CLK_I;
    return r;
}

/*
**	IEC write serial port trap.
*/
void IEC_WritePortTrap(int val)
{
    int a;

    a=0xE4;
    if( val&SIEC_ATN_O )
	a|=LP_ATN;
    if( val&SIEC_CLK_O )
	a|=LP_CLK;
    if( val&SIEC_DAT_O )
	a|=LP_DAT;
    outb(LP_CTRL,a);
}

#endif	/* } IEC_HARD */

/*---------------------------------------------------------------------------*/

#ifdef IEC_EMULATE	/* { */

static int ReadPortVal=SIEC_DAT_I;
static int TimeOut;
static int Pulse;

/*
**	IEC read serial port trap.
*/
int IEC_ReadPortTrap(void)
{
    if( TimeOut && !--TimeOut ) {
	printf("Timeout\n");
	ReadPortVal|=SIEC_DAT_I;
	Pulse=10;
    }
    if( Pulse && !--Pulse ) {
	printf("Pulse\n");
	ReadPortVal&=~SIEC_DAT_I;
    }

    return ReadPortVal;
}

/*
**	IEC write serial port trap.
*/
void IEC_WritePortTrap(int val)
{
    static int old;
    static int state;
    static int count;
    static int temp;

    val&=(SIEC_DAT_O|SIEC_CLK_O|SIEC_ATN_O);
    if( val!=old ) {
	old=val;
#if 0
	printf("C64:  %08d: %s%s%s $%04X\n",Cycle,
	    (C64OldOut&SIEC_ATN_O) ? "___ " : "ATN ",
	    (C64OldOut&SIEC_DAT_O) ? "___ " : "DAT ",
	    (C64OldOut&SIEC_CLK_O) ? "___ " : "CLK ",
	    GlobalRegPC
	);
#endif

	switch( state ) {
	    case 0:			/* initial */
		if( (val&(SIEC_DAT_O|SIEC_CLK_O))==(SIEC_DAT_O|SIEC_CLK_O) ) {
		    printf("Start\n");
		    ReadPortVal&=~SIEC_DAT_I;
		    TimeOut=10;
		    state=1;
		}
		break;
	    case 1:			/* sync */
		if( !(val&SIEC_CLK_O) ) {
		    printf("Sync-1\n");
		    TimeOut=0;
		    Pulse=0;
		    ReadPortVal&=~SIEC_DAT_I;
		    count=8;
		    temp=0;
		    state=2;
		}
		break;
	    case 2:			/* trans-high */
		if( (val&SIEC_CLK_O) ) {
		    temp>>=1;
		    if( val&SIEC_DAT_O ) {
			temp|=0x80;
		    }
		    --count;
		    state=3;
		}
		break;
	    case 3:			/* trans-low */
		if( !(val&SIEC_CLK_O) ) {
		    state=2;
		    if( !count ) {
			printf("END-BYTE %02X\n",temp);
			state=0;
			if( temp==0x3F ) {
			    state=4;
			}
			ReadPortVal|=SIEC_DAT_I;
		    }
		}
		break;
	    case 4:			/* unlisten */
		if( (val&~SIEC_ATN_O)==(SIEC_DAT_O|SIEC_CLK_O) ) {
		    printf("unlisten\n");
		    state=5;
		}
		break;
	    case 5:			/* unlisten */
		if( !(val&~SIEC_ATN_O)==(SIEC_DAT_O|SIEC_CLK_O) ) {
		    printf("unlisten\n");
		    state=0;
		}
		break;
	}
    }
}

#endif	/* } IEC_EMULATE */

/*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*/

#ifdef IEC_DEBUG	/* { */

/*
**	IEC read serial port trap.
*/
int IEC_ReadPortTrap(void)
{
    printf("IEC-PORT read at $%04X\n",GlobalRegPC);
    return 0;
}

/*
**	IEC write serial port trap.
*/
void IEC_WritePortTrap(int val)
{
    printf("IEC-PORT write at $%04X\n",GlobalRegPC);
}

#endif	/* } IEC_DEBUG */

/*---------------------------------------------------------------------------*/

#if !defined(IEC_HARD) && !defined(REAL1541) \
	&& !defined(IEC_EMULATE) && !defined(IEC_DEBUG)	/* { */

/*
**	IEC read serial port trap.
*/
int IEC_ReadPortTrap(void)
{
    return 0;
}

/*
**	IEC write serial port trap.
*/
void IEC_WritePortTrap(int val)
{
}

#endif	/* } !IEC_HARD && !REAL1541 && !IEC_EMULATE && !IEC_DEBUG */
