/*
 *	The C64 emulator
 *
 *	Copyright 1992,1996 by ALE.
 *	written by Lutz Sammer.
 *
 *	6502/6510 Emulation Headerfile
 *-----------------------------------------------------------------------------
 * $Id: 6502.h,v 1.7 1996/05/23 02:26:08 root Exp root $
 * $Log: 6502.h,v $
 * Revision 1.7  1996/05/23 02:26:08  root
 * New IRQ handling writen.
 *
 * Revision 1.6  1996/04/08 16:25:44  johns
 * Commented, Cleaned up
 *
 * Revision 1.5  1994/06/02  14:56:27  johns
 * version 1.07 ci
 *
 * Revision 1.4  1992/07/28  19:47:42  johns
 * Change of 6502 register names.
 *
 * Revision 1.1  1992/07/11  17:57:22  johns
 * Initial revision
 *
 *-----------------------------------------------------------------------------
 */

#ifndef __6502_H__	/* { */
#define __6502_H__

/*
**	Processor instructions
*/
enum Instructions {
	BRK,	ORA_IX,	ILL02,	ILL03,	ILL04,	ORA_D,	ASL_D,	ILL07,
	PHP,	ORA_IM,	ASL,	ILL0B,	ILL0C,	ORA_A,	ASL_A,	ILL0F,

	BPL,	ORA_IY,	ILL12,	ILL13,	ILL14,	ORA_DX,	ASL_DX,	ILL17,
	CLC,	ORA_AY,	ILL1A,	ILL1B,	ILL1C,	ORA_AX,	ASL_AX,	ILL1F,

	JSR,	AND_IX,	ILL22,	ILL23,	BIT_D,	AND_D,	ROL_D,	ILL27,
	PLP,	AND_IM,	ROL,	ILL2B,	BIT_A,	AND_A,	ROL_A,	ILL2F,

	BMI,	AND_IY,	ILL32,	ILL33,	ILL34,	AND_DX,	ROL_DX,	ILL37,
	SEC,	AND_AY,	ILL3A,	ILL3B,	ILL3C,	AND_AX,	ROL_AX,	ILL3F,

	RTI,	EOR_IX,	ILL42,	ILL43,	ILL44,	EOR_D,	LSR_D,	ILL47,
	PHA,	EOR_IM,	LSR,	ILL4B,	JMP_A,	EOR_A,	LSR_A,	ILL4F,

	BVC,	EOR_IY,	ILL52,	ILL53,	ILL54,	EOR_DX,	LSR_DX,	ILL57,
	CLI,	EOR_AY,	ILL5A,	ILL5B,	ILL5C,	EOR_AX,	LSR_AX,	ILL5F,

	RTS,	ADC_IX,	ILL62,	ILL63,	ILL64,	ADC_D,	ROR_D,	ILL67,
	PLA,	ADC_IM,	ROR,	ILL6B,	JMP_AI,	ADC_A,	ROR_A,	ILL6F,

	BVS,	ADC_IY,	ILL72,	ILL73,	ILL74,	ADC_DX,	ROR_DX,	ILL77,
	SEI,	ADC_AY,	ILL7A,	ILL7B,	ILL7C,	ADC_AX,	ROR_AX,	ILL7F,

	ILL80,	STA_IX,	ILL82,	ILL83,	STY_D,	STA_D,	STX_D,	ILL87,
	DEY,	ILL89,	TXA,	ILL8B,	STY_A,	STA_A,	STX_A,	ILL8F,

	BCC,	STA_IY,	ILL92,	ILL93,	STY_DX,	STA_DX,	STX_DY,	ILL97,
	TYA,	STA_AY,	TXS,	ILL9B,	ILL9C,	STA_AX,	ILL9E,	ILL9F,

	LDY_IM,	LDA_IX,	LDX_IM,	ILLA3,	LDY_D,	LDA_D,	LDX_D,	ILLA7,
	TAY,	LDA_IM,	TAX,	ILLAB,	LDY_A,	LDA_A,	LDX_A,	ILLAF,

	BCS,	LDA_IY,	ILLB2,	ILLB3,	LDY_DX,	LDA_DX,	LDX_DY,	ILLB7,
	CLV,	LDA_AY,	TSX,	ILLBB,	LDY_AX,	LDA_AX,	LDX_AY,	ILLBF,

	CPY_IM,	CMP_IX,	ILLC2,	ILLC3,	CPY_D,	CMP_D,	DEC_D,	ILLC7,
	INY,	CMP_IM,	DEX,	ILLCB,	CPY_A,	CMP_A,	DEC_A,	ILLCF,

	BNE,	CMP_IY,	ILLD2,	ILLD3,	ILLD4,	CMP_DX,	DEC_DX,	ILLD7,
	CLD,	CMP_AY,	ILLDA,	ILLDB,	ILLDC,	CMP_AX,	DEC_AX,	ILLDF,

	CPX_IM,	SBC_IX,	ILLE2,	ILLE3,	CPX_D,	SBC_D,	INC_D,	ILLE7,
	INX,	SBC_IM,	NOP,	ILLEB,	CPX_A,	SBC_A,	INC_A,	ILLEF,

	BEQ,	SBC_IY,	ILLF2,	ILLF3,	ILLF4,	SBC_DX,	INC_DX,	ILLF7,
	SED,	SBC_AY,	ILLFA,	ILLFB,	ILLFC,	SBC_AX,	INC_AX,	ILLFF
};

/*
**	Processor flags
*/
#define FLAG_CARRY	1
#define FLAG_ZERO	2
#define FLAG_INTERRUPT	4
#define FLAG_DECIMAL	8
#define FLAG_BREAK	16
#define FLAG_UNDEFINED	32
#define FLAG_OVERFLOW	64
#define FLAG_NEGATIVE	128

/*
**	Processor vectors
*/
#define NMI_VECTOR 0xFFFA
#define RST_VECTOR 0xFFFC
#define IRQ_VECTOR 0xFFFE

/*
**	C emulated byte register.
**		This is used to avoid byte -> long conversions.
*/
union reg6502 {
    unsigned char	Byte[4];	/* ENDIAN Low significant byte !! */
    unsigned		Int;
};

/*
**	LowByte:	access low byte of an integer.
*/
#ifdef BIG_ENDIAN
#   define LowByte(v)	((v).Byte[3])
#endif
#ifdef LITTLE_ENDIAN
#   define LowByte(v)	((v).Byte[0])
#endif

/*
**	Integer:	access byte register as integer.
*/
#define Integer(v)	((v).Int)

/*
**	Processor registers
*/
extern	union reg6502	GlobalRegA;
extern	union reg6502	GlobalRegX;
extern	union reg6502	GlobalRegY;
extern	union reg6502	GlobalRegP;
extern	union reg6502	GlobalRegS;
extern	unsigned	GlobalRegPC;

/*
**	Hardware emulation
*/
extern	int		IrqLine;		/* Interupt line state */
extern	int		IrqFlag;		/* Interupt flag */
extern	unsigned	Cycle;			/* Current 6502 cycle */
extern	unsigned	Action;			/* Next processor action */
#ifdef NEW_ACTION
extern	unsigned	HwAction;		/* Next hardware action */
#endif
extern	void		(*ActionFunction)(void);/* Hardware action function */

/*-----------------------------------------------------------------------------
 *	Stack (0x100-0x1FF) access:
 *---------------------------------------------------------------------------*/

/*
**	Read word from stack used by monitor and disassembler.
*/
#define RWStack(x) \
    (Ram[0x100+((x)&0xFF)]|(Ram[0x100+(((x)+1)&0xFF)]<<8))

/*
**	Push a byte on processor stack.
*/
#define PushB(x) \
    do {						\
	Ram[0x100+Integer(RegS)]=(x); LowByte(RegS)--;	\
    } while( 0 )

/*
**	Pop a byte from processor stack.
*/
#define PopB(x) \
    (++LowByte(RegS), (x)=Ram[0x100+Integer(RegS)])

/*
**	Push a word on processor stack.
*/
#define PushW(x) \
    do {						\
	PushB((x)>>8); PushB((x)&0xFF);			\
    } while( 0 )

/*
**	Pop a word from processor stack.
*/
#define PopW(x)	\
    do {						\
	register unsigned __w;				\
	++LowByte(RegS);				\
	__w=Ram[0x100+Integer(RegS)];			\
	++LowByte(RegS);				\
	__w|=Ram[0x100+Integer(RegS)]<<8;		\
	(x)=__w;					\
    } while( 0 )

#endif	/* } !__6502_H__ */
