#!/bin/sh
# $id: $
###############################################################################

X11=false
X11_16=false
SVGALIB=false
GO32=false
AOUTX11=true
AOUTX11_16=true
AOUTSVGALIB=true

###############################################################################
cd src
###############################################################################
echo "X11" $X11

if $X11
then
MAKE_LIBS='LIBS=-L/usr/X11R6/lib -lXext -lX11'
make clean
make "$MAKE_LIBS" "DEFINES=-DPC_ANALOG_JOY -DX11 -DCOLORMAP16 -DSID_SPEAKER" 
mv c64 c64-x11-sp

make clean
make "$MAKE_LIBS" "DEFINES=-DPC_ANALOG_JOY -DX11 -DCOLORMAP16 -DSID_OPL3" 
mv c64 c64-x11-o3

make clean
make "$MAKE_LIBS" "DEFINES=-DPC_ANALOG_JOY -DX11 -DCOLORMAP16 -DSID_DSP" 
mv c64 c64-x11-dsp

make clean
make "$MAKE_LIBS" "DEFINES=-DPC_ANALOG_JOY -DX11 -DCOLORMAP16 -DSID_SPEAKER -DOVERSCAN" 
mv c64 c64-x11-os-sp

make clean
make "$MAKE_LIBS" "DEFINES=-DPC_ANALOG_JOY -DX11 -DCOLORMAP16 -DSID_OPL3 -DOVERSCAN" 
mv c64 c64-x11-os-o3

make clean
make "$MAKE_LIBS" "DEFINES=-DPC_ANALOG_JOY -DX11 -DCOLORMAP16 -DSID_DSP -DOVERSCAN" 
mv c64 c64-x11-os-dsp

fi

###############################################################################
echo "X11-16" $X11_16

if $X11_16
then
MAKE_LIBS='LIBS=-L/usr/X11R6/lib -lXext -lX11'
make clean
make "$MAKE_LIBS" "DEFINES=-DPC_ANALOG_JOY -DX11 -DCOLORMAP16bpp -DSID_SPEAKER" 
mv c64 c64-x16-sp

make clean
make "$MAKE_LIBS" "DEFINES=-DPC_ANALOG_JOY -DX11 -DCOLORMAP16bpp -DSID_OPL3" 
mv c64 c64-x16-o3

make clean
make "$MAKE_LIBS" "DEFINES=-DPC_ANALOG_JOY -DX11 -DCOLORMAP16bpp -DSID_DSP" 
mv c64 c64-x16-dsp

make clean
make "$MAKE_LIBS" "DEFINES=-DPC_ANALOG_JOY -DX11 -DCOLORMAP16bpp -DSID_SPEAKER -DOVERSCAN" 
mv c64 c64-x16-os-sp

make clean
make "$MAKE_LIBS" "DEFINES=-DPC_ANALOG_JOY -DX11 -DCOLORMAP16bpp -DSID_OPL3 -DOVERSCAN" 
mv c64 c64-x16-os-o3

make clean
make "$MAKE_LIBS" "DEFINES=-DPC_ANALOG_JOY -DX11 -DCOLORMAP16bpp -DSID_DSP -DOVERSCAN" 
mv c64 c64-x16-os-dsp

fi

###############################################################################
echo "SVGALIB" $SVGALIB

if $SVGALIB
then

MAKE_LIBS='LIBS=-lvga'
make clean
make "$MAKE_LIBS" "DEFINES=-DPC_ANALOG_JOY -DSVGALIB -DSID_SPEAKER"
mv c64 c64-svga-sp

make clean
make "$MAKE_LIBS" "DEFINES=-DPC_ANALOG_JOY -DSVGALIB -DSID_OPL3" 
mv c64 c64-svga-o3

make clean
make "$MAKE_LIBS" "DEFINES=-DPC_ANALOG_JOY -DSVGALIB -DSID_DSP" 
mv c64 c64-svga-dsp

make clean
make "$MAKE_LIBS" "DEFINES=-DPC_ANALOG_JOY -DSVGALIB -DSID_SPEAKER -DOVERSCAN" 
mv c64 c64-svga-os-sp

make clean
make "$MAKE_LIBS" "DEFINES=-DPC_ANALOG_JOY -DSVGALIB -DSID_OPL3 -DOVERSCAN" 
mv c64 c64-svga-os-o3

make clean
make "$MAKE_LIBS" "DEFINES=-DPC_ANALOG_JOY -DSVGALIB -DSID_DSP -DOVERSCAN" 
mv c64 c64-svga-os-dsp

fi

###############################################################################
echo "GO32" $GO32

if $GO32
then
make clean
make -f Makefile.dos "DEFINES=-DPC_ANALOG_JOY -DSID_SPEAKER"
mv c64 c64.dos-sp

make clean
make -f Makefile.dos "DEFINES=-DPC_ANALOG_JOY -DSID_OPL3" 
mv c64 c64.dos-o3

make clean
make -f Makefile.dos "DEFINES=-DPC_ANALOG_JOY -DSID_DSP" 
mv c64 c64.dos-dsp

make clean
make -f Makefile.dos "DEFINES=-DPC_ANALOG_JOY -DSID_SPEAKER -DOVERSCAN" 
mv c64 c64.dos-os-sp

make clean
make -f Makefile.dos "DEFINES=-DPC_ANALOG_JOY -DSID_OPL3 -DOVERSCAN" 
mv c64 c64.dos-os-o3

make clean
make -f Makefile.dos "DEFINES=-DPC_ANALOG_JOY -DSID_DSP -DOVERSCAN" 
mv c64 c64.dos-os-dsp

fi

###############################################################################
echo "A-OUT X11" $AOUTX11

if $AOUTX11
then
MAKE_LIBS='LIBS=-L/usr/X11R6/lib -lXext -lX11'
make clean
make -f Makefile.aout "$MAKE_LIBS" "DEFINES=-DPC_ANALOG_JOY -DX11 -DCOLORMAP16 -DSID_SPEAKER" 
mv c64 c64.aout-x11-sp

make clean
make -f Makefile.aout "$MAKE_LIBS" "DEFINES=-DPC_ANALOG_JOY -DX11 -DCOLORMAP16 -DSID_OPL3" 
mv c64 c64.aout-x11-o3

make clean
make -f Makefile.aout "$MAKE_LIBS" "DEFINES=-DPC_ANALOG_JOY -DX11 -DCOLORMAP16 -DSID_DSP" 
mv c64 c64.aout-x11-dsp

make clean
make -f Makefile.aout "$MAKE_LIBS" "DEFINES=-DPC_ANALOG_JOY -DX11 -DCOLORMAP16 -DSID_SPEAKER -DOVERSCAN" 
mv c64 c64.aout-x11-os-sp

make clean
make -f Makefile.aout "$MAKE_LIBS" "DEFINES=-DPC_ANALOG_JOY -DX11 -DCOLORMAP16 -DSID_OPL3 -DOVERSCAN" 
mv c64 c64.aout-x11-os-o3

make clean
make -f Makefile.aout "$MAKE_LIBS" "DEFINES=-DPC_ANALOG_JOY -DX11 -DCOLORMAP16 -DSID_DSP -DOVERSCAN" 
mv c64 c64.aout-x11-os-dsp

fi

###############################################################################
echo "AOUTX11-16" $AOUTX11_16

if $AOUTX11_16
then
MAKE_LIBS='LIBS=-L/usr/X11R6/lib -lXext -lX11'
make clean
make -f Makefile.aout "$MAKE_LIBS" "DEFINES=-DPC_ANALOG_JOY -DX11 -DCOLORMAP16bpp -DSID_SPEAKER" 
mv c64 c64.aout-x16-sp

make clean
make -f Makefile.aout "$MAKE_LIBS" "DEFINES=-DPC_ANALOG_JOY -DX11 -DCOLORMAP16bpp -DSID_OPL3" 
mv c64 c64.aout-x16-o3

make clean
make -f Makefile.aout "$MAKE_LIBS" "DEFINES=-DPC_ANALOG_JOY -DX11 -DCOLORMAP16bpp -DSID_DSP" 
mv c64 c64.aout-x16-dsp

make clean
make -f Makefile.aout "$MAKE_LIBS" "DEFINES=-DPC_ANALOG_JOY -DX11 -DCOLORMAP16bpp -DSID_SPEAKER -DOVERSCAN" 
mv c64 c64.aout-x16-os-sp

make clean
make -f Makefile.aout "$MAKE_LIBS" "DEFINES=-DPC_ANALOG_JOY -DX11 -DCOLORMAP16bpp -DSID_OPL3 -DOVERSCAN" 
mv c64 c64.aout-x16-os-o3

make clean
make -f Makefile.aout "$MAKE_LIBS" "DEFINES=-DPC_ANALOG_JOY -DX11 -DCOLORMAP16bpp -DSID_DSP -DOVERSCAN" 
mv c64 c64.aout-x16-os-dsp

fi

###############################################################################
echo "AOUT SVGALIB" $AOUTSVGALIB

if $AOUTSVGALIB
then

MAKE_LIBS='LIBS=-lvga'
make clean
make -f Makefile.aout "$MAKE_LIBS" "DEFINES=-DPC_ANALOG_JOY -DSVGALIB -DSID_SPEAKER"
mv c64 c64.aout-svga-sp

make clean
make -f Makefile.aout "$MAKE_LIBS" "DEFINES=-DPC_ANALOG_JOY -DSVGALIB -DSID_OPL3" 
mv c64 c64.aout-svga-o3

make clean
make -f Makefile.aout "$MAKE_LIBS" "DEFINES=-DPC_ANALOG_JOY -DSVGALIB -DSID_DSP" 
mv c64 c64.aout-svga-dsp

make clean
make -f Makefile.aout "$MAKE_LIBS" "DEFINES=-DPC_ANALOG_JOY -DSVGALIB -DSID_SPEAKER -DOVERSCAN" 
mv c64 c64.aout-svga-os-sp

make clean
make -f Makefile.aout "$MAKE_LIBS" "DEFINES=-DPC_ANALOG_JOY -DSVGALIB -DSID_OPL3 -DOVERSCAN" 
mv c64 c64.aout-svga-os-o3

make clean
make -f Makefile.aout "$MAKE_LIBS" "DEFINES=-DPC_ANALOG_JOY -DSVGALIB -DSID_DSP -DOVERSCAN" 
mv c64 c64.aout-svga-os-dsp

fi

###############################################################################
cd ..
