///////////////////////////////////////////////////////////////////////////////
//
// BasicCPU.cxx
//
//   This is the abstract base class for all microprocessors
//
//
// BSVC "A Microprocessor Simulation Framework"
// Copyright (c) 1993
// By: Bradford W. Mott
// May 7,1996
//
///////////////////////////////////////////////////////////////////////////////
// $Id: BasicCPU.cxx,v 1.1 1996/08/02 14:49:17 bwmott Exp $
///////////////////////////////////////////////////////////////////////////////

#include "BasicCPU.hxx"

///////////////////////////////////////////////////////////////////////////////
// Constructor
///////////////////////////////////////////////////////////////////////////////
BasicCPU::BasicCPU(const char* name, int granularity, 
    vector<AddressSpace*>& addressSpaces,
    const char* traceRecordFormat,
    const char* defaultTraceRecordEntries)
    : myAddressSpaces(addressSpaces),
      myName(name),
      myGranularity(granularity),
      myExecutionTraceRecord(traceRecordFormat),
      myDefaultExecutionTraceEntries(defaultTraceRecordEntries)
{
}

///////////////////////////////////////////////////////////////////////////////
// Destructor
///////////////////////////////////////////////////////////////////////////////
BasicCPU::~BasicCPU()
{
}

