/****************************************************************/
/* 8051 Simulator by Alberto Firpo                              */
/*     e-mail: firpo@educ.disi.unige.it                         */
/****************************************************************/
#include "sim8051.h"

static unsigned char * tab_sfr[0x80] = {
"P0",	"SP",	"DPL",	"DPH",	NULL,	NULL,	NULL,	"PCON",
"TCON",	"TMOD",	"TL0",	"TL1",	"TH0",	"TH1",	NULL,	NULL,
"P1",	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,
"SCON",	"SBUF",	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,
"P2",	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,
"IE",	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,
"P3",	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,
"IP",	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,
NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,
#ifdef SIM8052
"T2CON",	NULL,	"RCAP2L",	"RCAP2H",	"TL2",	"TH2",	NULL,	NULL, 
#else
NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,
#endif
"PSW",	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,
NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,
"ACC",	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,
NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,
"B",	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,
NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL
};

/*
  Return: NULL if no name is forseen
          <name> of the SFR Location
*/
unsigned char * get_sfr_name(INT8 Daddr)
{
	if (Daddr >= 0x80)
		return (tab_sfr[(Daddr-0x80)]);
	else
		return NULL;
}
