#################################################################
# Start of definition for generating code for Disassembling
# 8051 Simulator by Alberto Firpo
#     e-mail: firpo@educ.disi.unige.it
#################################################################
BEGIN {
 DEBUG = 0
 # initialization
 hex_code = 0
 bytes = 0
 if (DEBUG)
   printf("Generating code for the following 8051 Instructions:\n")
 # file definitions
 Cfile = "instTab.c"
 f_init = "__f_init"
 f_dis = "__f_dis"
 f_sim = "__f_sim"
 f_ext = "__f_ext"
 # Header for f_init
 printf("\n/* Array initialization */\n") > f_init
 printf("void init_instTab(void)\n{\n") > f_init
 printf("  def_instr[0xA5].dis_fun = dis_RESERVED;\n") > f_init
 printf("  def_instr[0xA5].sim_fun = sim_RESERVED;\n") > f_init
 printf("  def_instr[0xA5].num_of_byte = 1;\n") > f_init
 printf("  def_instr[0xA5].num_of_cicles = 0;\n") > f_init
 # Header for f_dis
 printf("\n/* Disassembling functions */\n") > f_dis
 printf("static void dis_RESERVED(INT16 addr)\n{\n") > f_dis
 printf("   dis_print(\"RESERVED\");\n}\n\n") > f_dis
 printf("static void dis_okMOV_DIR_DIR(INT16 addr)\n{\n") > f_dis
 printf("   dis_print(\"MOV\");\n") > f_dis
 printf("   dis_printchar(' ');\n") > f_dis
 printf("   dis_printDirect(CMEM[addr+2]);\n") > f_dis
 printf("   dis_printchar(',');\n") > f_dis
 printf("   dis_printDirect(CMEM[addr+1]);\n}\n\n") > f_dis
 # Header for f_sim
 printf("\n/* Simulating functions */\n") > f_sim
 printf("static void sim_RESERVED(INT16 addr)\n{\n}\n\n") > f_sim
 # Header for f_ext
 printf("\n/* External Simulation functions */\n") > f_ext
}
END {
 # end of f_init
 printf("  def_instr[0xA5].dis_fun = dis_RESERVED;\n") > f_init
 printf("  def_instr[0x85].dis_fun = dis_okMOV_DIR_DIR;\n") > f_init
 printf("};\n\n") > f_init
 # end of f_dis
 printf("\n") > f_dis
 # end of f_sim
 printf("\n") > f_sim
 # end of f_ext
 printf("\n") > f_ext
 # concatenate to create C file
 printf("/****************************************************************/\n") > Cfile
 printf("/* 8051 Simulator by Alberto Firpo                              */\n") > Cfile
 printf("/*     e-mail: firpo@educ.disi.unige.it                         */\n") > Cfile
 printf("/****************************************************************/\n") > Cfile
 printf("#include \"sim8051.h\"\n") > Cfile
 printf("#include \"mem8051.h\"\n") > Cfile
 printf("#include \"int8051.h\"\n") > Cfile
 printf("#include \"dis_io.h\"\n") > Cfile
 printf("#include \"sim_io.h\"\n") > Cfile
 printf("\n") > Cfile
 printf("/* extern declaration useb by do_step function */\n") > Cfile
 printf("extern void LCALL(INT16);\n") > Cfile
 printf("\n") > Cfile
 printf("struct def_instr_t {\n") > Cfile
 printf("  void (*dis_fun)(INT16);\n") > Cfile
 printf("  void (*sim_fun)(INT16);\n") > Cfile
 printf("  int num_of_byte;\n") > Cfile
 printf("  int num_of_cicles;\n") > Cfile
 printf("};\n\n") > Cfile
 printf("static struct def_instr_t def_instr[256];\n\n") > Cfile
 printf("INT16 do_disassembling(INT16 addr, unsigned char * str)\n{\n") > Cfile
 printf("   INT8 i;\n") > Cfile
 printf("   dis_start(str);\n") > Cfile
 printf("   dis_printADDRESS(addr);\n") > Cfile
 printf("   dis_printchar(' ');\n") > Cfile
 printf("   for(i=0; i<def_instr[CMEM[addr]].num_of_byte; i++)\n") > Cfile
 printf("   {\n") > Cfile
 printf("      dis_printINT8(CMEM[addr+i],NO_H);\n") > Cfile
 printf("      dis_printchar(' ');\n") > Cfile
 printf("   }\n") > Cfile
 printf("   dis_printchar('\t');\n") > Cfile
 printf("   def_instr[CMEM[addr]].dis_fun(addr);\n") > Cfile
 printf("   dis_end();\n") > Cfile
 printf("   return addr+def_instr[CMEM[addr]].num_of_byte;\n}\n\n") > Cfile
 printf("void do_step(void)\n{\n") > Cfile
 printf("   register INT16 addr;\n") > Cfile
 printf("   sim_clear();\n") > Cfile
 printf("   if( addr = checkInterrupt() )\n") > Cfile
 printf("   {\n") > Cfile
 printf("      LCALL(addr);\n") > Cfile
 printf("      CYCLES += 2;\n") > Cfile
 printf("   }\n") > Cfile
 printf("   else\n") > Cfile
 printf("   {\n") > Cfile
 printf("      if( readDirect(PCON) & 0x1 )\n") > Cfile
 printf("         CYCLES += 1;\n") > Cfile
 printf("      else\n") > Cfile
 printf("      {\n") > Cfile
 printf("         addr = PC;\n") > Cfile
 printf("         PC += def_instr[CMEM[addr]].num_of_byte;\n") > Cfile
 printf("         def_instr[CMEM[addr]].sim_fun(addr);\n") > Cfile
 printf("         CYCLES += def_instr[CMEM[addr]].num_of_cicles;\n") > Cfile
 printf("      }\n") > Cfile
 printf("   }\n") > Cfile
 printf("   if (sim_iserror())\n") > Cfile
 printf("   {\n") > Cfile
 printf("      sim_notify_at(addr);\n") > Cfile
 printf("   }\n") > Cfile
 printf("}\n\n") > Cfile
 system("cat "f_ext" >> "Cfile)
 system("cat "f_dis" >> "Cfile)
 system("cat "f_sim" >> "Cfile)
 system("cat "f_init" >> "Cfile)
 system("/bin/rm -f "f_init)
 system("/bin/rm -f "f_dis)
 system("/bin/rm -f "f_sim)
 system("/bin/rm -f "f_ext)
}

# main of script
{
   if ($1 ~ /^;/)  { }
   else if ($1 !~ /^[01P]/) { print "ERROR in input:"$0 }
   else if ($4 != "RESERVED") { 
      calc_hex_code($1) 
      gen_array()
      gen_dis_fun()
      gen_sim_fun()
   }
}

function calc_hex_code(s)
{
   gsub("P","0",s)
   gsub("R","0",s)
   gsub("I","0",s)
   hex_code = 0
   while (length(s))
   {
     hex_code *= 2
     if ( index(s,"1") == 1 )
        hex_code++
     s = substr(s,2)
   }
}

function gen_array()
{
        gen_array_item()
        if (index($1,"I"))
	{
	   hex_code++; gen_array_item()
	}
	else if (index($1,"R"))
	{
	   hex_code++; gen_array_item()
	   hex_code++; gen_array_item()
	   hex_code++; gen_array_item()
	   hex_code++; gen_array_item()
	   hex_code++; gen_array_item()
	   hex_code++; gen_array_item()
	   hex_code++; gen_array_item()
	}
	else if (index($1,"P"))
	{
	   hex_code += 32; gen_array_item()
	   hex_code += 32; gen_array_item()
	   hex_code += 32; gen_array_item()
	   hex_code += 32; gen_array_item()
	   hex_code += 32; gen_array_item()
	   hex_code += 32; gen_array_item()
	   hex_code += 32; gen_array_item()
	}
}

function gen_array_item()
{
	if (DEBUG)
       	   printf("Code: 0x%X %s\n",hex_code,$0)
        printf("  def_instr[0x%X].dis_fun = dis_%s",hex_code,$4) > f_init
        args = 5
        bytes = 1
	while (args <= NF)
        {
           get_f_name(args,f_init)
           args++
        }
        printf(";\n") > f_init
        printf("  def_instr[0x%X].sim_fun = sim_%s",hex_code,$4) > f_init
        args = 5
        bytes = 1
	while (args <= NF)
        {
           get_f_name(args,f_init)
           args++
        }
        printf(";\n") > f_init
        printf("  def_instr[0x%X].num_of_byte = %d;\n",hex_code, bytes) > f_init
        printf("  def_instr[0x%X].num_of_cicles = %d;\n",hex_code, $2) > f_init
}

function gen_dis_fun()
{
        printf("static void dis_%s",$4) > f_dis
        args = 5
        bytes = 1
	while (args <= NF)
        {
           get_f_name(args,f_dis)
           args++
        }
        printf("(INT16 addr)\n") > f_dis
        printf("{\n") > f_dis
        printf("   dis_print(\"%s\");\n",$4) > f_dis
        args = 5
        bytes = 1
	while (args <= NF)
        {
           printf("   dis_printchar(\'%s\');\n",(args == 5)? " ":",") > f_dis
           gen_dis(args)
           args++
        }
        printf("}\n\n") > f_dis
}

function gen_dis(arg)
{
  if ( $arg == "A" ) { printf("   dis_print(\"A\");\n") > f_dis }
  else if ( $arg == "Paddr" ) { bytes++; printf("   dis_printADDRESS(getPaddr(addr));\n") > f_dis }
  else if ( $arg == "Rn" ) { printf("   dis_printchar(\'R\');\n   dis_printchar('0'+getReg(addr));\n") > f_dis }
  else if ( $arg == "Daddr" ) { bytes++; printf("   dis_printDirect(CMEM[addr+%d]);\n",bytes-1) > f_dis }
  else if ( $arg == "@Rn" ) { printf("   dis_print(\"@R\");\n   dis_printchar(\'0\'+(CMEM[addr] & 0x1));\n") > f_dis }
  else if ( $arg == "#data" ) { bytes++; printf("   dis_printchar(\'#\');\n   dis_printINT8(CMEM[addr+%d],WITH_H);\n",bytes-1) > f_dis }
  else if ( $arg == "Baddr" ) { bytes++; printf("   dis_printBit(CMEM[addr+%d]);\n",bytes-1) > f_dis }
  else if ( $arg == "NBaddr" ) { bytes++; printf("   dis_printchar(\'/\');\n   dis_printBit(CMEM[addr+%d]);\n",bytes-1) > f_dis }
  else if ( $arg == "Raddr" ) { bytes++; printf("   dis_printADDRESS(addr+%d+(SINT8)CMEM[addr+%d]);\n",bytes,bytes-1) > f_dis }
  else if ( $arg == "Caddr" ) { bytes+=2; printf("   dis_printADDRESS((CMEM[addr+%d]<<8)+CMEM[addr+%d]);\n",bytes-2,bytes-1) > f_dis }
  else if ( $arg == "#data16" ) { bytes+=2; printf("   dis_printchar(\'#\');\n   dis_printINT16((CMEM[addr+%d]<<8)+CMEM[addr+%d],WITH_H);\n",bytes-2,bytes-1) > f_dis }
  else if ( $arg == "@DPTR" ) { printf("   dis_print(\"@DPTR\");\n") > f_dis }
  else if ( $arg == "DPTR" ) { printf("   dis_print(\"DPTR\");\n") > f_dis }
  else if ( $arg == "@A+DPTR" ) { printf("   dis_print(\"@A+DPTR\");\n") > f_dis }
  else if ( $arg == "@A+PC" ) { printf("   dis_print(\"@A+PC\");\n") > f_dis }
  else if ( $arg == "AB" ) { printf("   dis_print(\"AB\");\n") > f_dis }
  else if ( $arg == "C" ) { printf("   dis_print(\"C\");\n") > f_dis }
  else printf(" INVALID_ARGS for gen_dis: %s",$arg)
}

function get_f_name(arg,file)
{
  if ( $arg == "A" ) { printf("_A") > file }
  else if ( $arg == "Paddr" ) { bytes++; printf("_PADDR") > file }
  else if ( $arg == "Rn" ) { printf("_REG") > file }
  else if ( $arg == "Daddr" ) { bytes++; printf("_DIR") > file }
  else if ( $arg == "@Rn" ) { printf("_INDIR") > file }
  else if ( $arg == "#data" ) { bytes++; printf("_IMM") > file }
  else if ( $arg == "Baddr" ) { bytes++; printf("_BADDR") > file }
  else if ( $arg == "NBaddr" ) { bytes++; printf("_NBADDR") > file }
  else if ( $arg == "Raddr" ) { bytes++; printf("_RADDR") > file }
  else if ( $arg == "Caddr" ) { bytes+=2; printf("_CADDR") > file }
  else if ( $arg == "#data16" ) { bytes+=2; printf("_IMM16") > file }
  else if ( $arg == "@DPTR" ) { printf("_ATDPTR") > file }
  else if ( $arg == "DPTR" ) { printf("_DPTR") > file }
  else if ( $arg == "@A+DPTR" ) { printf("_ATADPTR") > file }
  else if ( $arg == "@A+PC" ) { printf("_ATAPC") > file }
  else if ( $arg == "AB" ) { printf("_AB") > file }
  else if ( $arg == "C" ) { printf("_C") > file }
  else printf(" INVALID_ARGS for get_f_name: %s",$arg)
}

function get_f_type(arg,file)
{
  if ( $arg == "A" ) { printf("INT8") > file }
  else if ( $arg == "Paddr" ) { printf("INT16") > file }
  else if ( $arg == "Rn" ) { printf("INT8") > file }
  else if ( $arg == "Daddr" ) { printf("INT8") > file }
  else if ( $arg == "@Rn" ) { printf("INT8") > file }
  else if ( $arg == "#data" ) { printf("INT8") > file }
  else if ( $arg == "Baddr" ) { printf("BIT") > file }
  else if ( $arg == "NBaddr" ) { printf("BIT") > file }
  else if ( $arg == "Raddr" ) { printf("SINT8") > file }
  else if ( $arg == "Caddr" ) { printf("INT16") > file }
  else if ( $arg == "#data16" ) { printf("INT16") > file }
  else if ( $arg == "@DPTR" ) { printf("INT8") > file }
  else if ( $arg == "DPTR" ) { printf("INT16") > file }
  else if ( $arg == "@A+DPTR" ) { printf("INT16") > file }
  else if ( $arg == "@A+PC" ) { printf("INT16") > file }
  else if ( $arg == "AB" ) { printf("INT16") > file }
  else if ( $arg == "C" ) { printf("BIT") > file }
  else printf(" INVALID_ARGS for get_f_type: %s",$arg)
}
function gen_sim_name(file)
{
        printf("void sim_%s",$4) > file
        args = 5
        bytes = 1
	while (args <= NF)
        {
           get_f_name(args,file)
           args++
        }
        printf("(INT16 addr)") > file
}

function gen_sim_fun()
{
   if ($3 == "-")
   {
	printf("extern ") > f_ext
	gen_sim_name(f_ext)
	printf(";\n") > f_ext
   }
   else
   {
	# generate extern for user provided function
	# Note: several extern declarations can appear in generated file.
	if ( ( $4 !~ "MOV" ) && ( $4 != "DEC" ) && ( $4 != "INC" ) )
	{
		printf("extern ") > f_ext
		if ( $3 ~ "^_" )
			printf("void %s",substr($3,2)) > f_ext
		else
		{
			get_f_type(5,f_ext) 
			printf(" %s",$3) > f_ext
		}
        	args = 5
		while (args <= NF)
        	{
	           printf("%s",(args == 5)? "(":",") > f_ext
	           get_f_type(args,f_ext)
	           args++
	        }
		printf(");\n") > f_ext
	}
	# generate code to call user provided function
        printf("static void sim_%s",$4) > f_sim
        args = 5
        bytes = 1
	while (args <= NF)
        {
           get_f_name(args,f_sim)
           args++
        }
        printf("(INT16 addr)\n") > f_sim
        printf("{\n") > f_sim
	# call user def. fun. with resolved parameters
	close_par = 0
	bytes = 1  
	if ( $3 ~ "^_" )
		sub("_","",$3)
	else
		gen_assign(5)
	if ( ( $4 !~ "MOV" ) && ( $4 != "DEC" ) && ( $4 != "INC" ) )
	{
        	printf("   %s",$3) > f_sim
	        args = 5
	        bytes = 1  
		while (args <= NF)
	        {
	           printf("%s",(args == 5)? "(":",") > f_sim
	           resolve_prm(args)
	           args++
	        }
	}
	else
	{
		if ( $4 ~ "MOV" )
			resolve_prm(6)
		else
		{
			bytes--
			resolve_prm(5)
		}
		close_par = 0
		if ( $4 == "INC")
			printf("+1") > f_sim
		if ( $4 == "DEC")
			printf("-1") > f_sim
	}
	printf(")%s;\n}\n\n",(close_par)? ")": "") > f_sim
   }
}

function resolve_prm(arg)
{
  if ( $arg == "A" ) { printf("readDirect(ACC)") > f_sim }
  else if ( $arg == "Paddr" ) { bytes++; printf("getPaddr(addr)") > f_sim }
  else if ( $arg == "Rn" ) { printf("readReg(getReg(addr))") > f_sim }
  else if ( $arg == "Daddr" ) { bytes++; printf("readDirect(CMEM[addr+%d])",bytes-1) > f_sim }
  else if ( $arg == "@Rn" ) { printf("readIndirect(readReg(CMEM[addr] & 0x1))") > f_sim }
  else if ( $arg == "#data" ) { bytes++; printf("CMEM[addr+%d]",bytes-1) > f_sim }
  else if ( $arg == "Baddr" ) { bytes++; printf("readBit(CMEM[addr+%d])",bytes-1) > f_sim }
  else if ( $arg == "NBaddr" ) { bytes++; printf("((readBit(CMEM[addr+%d]))?0:1)",bytes-1) > f_sim }
  else if ( $arg == "Raddr" ) { bytes++; printf("(SINT8)CMEM[addr+%d]",bytes-1) > f_sim }
  else if ( $arg == "Caddr" ) { bytes+=2; printf("buildINT16(CMEM[addr+%d],CMEM[addr+%d])",bytes-2,bytes-1) > f_sim }
  else if ( $arg == "#data16" ) { bytes+=2; printf("buildINT16(CMEM[addr+%d],CMEM[addr+%d])",bytes-2,bytes-1) > f_sim }
  else if ( $arg == "@DPTR" ) { printf("readExtRam(readDPTR())") > f_sim }
  else if ( $arg == "DPTR" ) { printf("readDPTR()") > f_sim }
  else if ( $arg == "@A+DPTR" ) { printf("CMEM[readDirect(ACC)+buildINT16(readDirect(DPH),readDirect(DPL))]") > f_sim }
  else if ( $arg == "@A+PC" ) { printf("CMEM[readDirect(ACC)+PC]") > f_sim }
  else if ( $arg == "AB" ) { printf("buildINT16(readDirect(ACC),readDirect(B_REG))") > f_sim }
  else if ( $arg == "C" ) { printf("readBit(CARRY)") > f_sim }
  else printf(" INVALID_ARGS for resolve_prm: %s",$arg)
}

#in case of assign update the bytes variable
function gen_assign(arg)
{
  close_par = 1;
  if ( $arg == "A" ) { printf("   writeDirect(ACC,") > f_sim }
  else if ( $arg == "Paddr" ) { close_par = 0 }
  else if ( $arg == "Rn" ) { printf("   writeReg(getReg(addr),") > f_sim }
  else if ( $arg == "Daddr" ) { bytes++; printf("   writeDirect(CMEM[addr+1],") > f_sim }
  else if ( $arg == "@Rn" ) { printf("   writeIndirect(readReg(CMEM[addr] & 0x1),") > f_sim }
  else if ( $arg == "#data" ) { close_par = 0 }
  else if ( $arg == "Baddr" ) { bytes++; printf("   writeBit(CMEM[addr+1],") > f_sim }
  else if ( $arg == "NBaddr" ) { close_par = 0 }
  else if ( $arg == "Raddr" ) { close_par = 0 }
  else if ( $arg == "Caddr" ) { close_par = 0 }
  else if ( $arg == "#data16" ) { close_par = 0 }
  else if ( $arg == "@DPTR" ) { printf("   writeExtRam(readDPTR(),") > f_sim }
  else if ( $arg == "DPTR" ) { printf("   writeDPTR(") > f_sim } 
  else if ( $arg == "@A+DPTR" ) { close_par = 0 }
  else if ( $arg == "@A+PC" ) { close_par = 0 }
  else if ( $arg == "AB" ) { close_par = 0 }
  else if ( $arg == "C" ) { printf("   writeBit(CARRY,") > f_sim }
  else printf(" INVALID_ARGS for gen_assign: %s",$arg)
}

