/****************************************************************/
/* 8051 Simulator by Alberto Firpo                              */
/*     e-mail: firpo@educ.disi.unige.it                         */
/****************************************************************/
#include <stdio.h>
#include "sim8051.h"
#include "mem8051.h"
#include "int8051.h"
#include "sim_io.h"

static char * pSimErrMsg = NULL;
static FILE * simttyi = stdin;
static FILE * simttyo = stdout;
static FILE * simttye = stderr;

void sim_io_assign(FILE * Sin, FILE * Sout, FILE * Serr)
{
	simttyi = Sin;
	simttyo = Sout;
	simttye = Serr;
}

void sim_clear(void)
{
	pSimErrMsg = NULL;
}

int sim_iserror(void)
{
	return (int)pSimErrMsg;
}

void sim_error(char * p)
{
	pSimErrMsg = p;
}

void sim_notify_at(INT16 addr)
{
	fprintf(simttye, "WARNING: %s at address %Xh\n",pSimErrMsg, addr);
}

void sim_print_status(void)
{
	INT8 i;
#ifdef SIM8052
	fprintf(simttyo," PC ACC B  R0 R1 R2 R3 R4 R5 R6 R7 DPTR SP    PSW       2S1100PEND  CYCLES\n");
#else
	fprintf(simttyo," PC ACC B  R0 R1 R2 R3 R4 R5 R6 R7 DPTR SP    PSW       -S1100PEND  CYCLES\n");
#endif
	fprintf(simttyo,"%.4X %.2X %.2X ",PC,readDirect(ACC), readDirect(B_REG));
	for (i=0; i<8; i++)
		fprintf(simttyo,"%.2X ",readReg(i)); 
	fprintf(simttyo,"%.4X %.2X %s %s  %ld\n",readDPTR(), readDirect(SP), sim_expand_PSW(), getIntPending(), CYCLES);
	sim_print_instr(PC);
}

void sim_putchar(char c)
{
	fprintf(simttyo,"%c", c);
}

void sim_print(char * msg)
{
	fprintf(simttyo,"%s", msg);
}

void sim_print_n(char * msg)
{
	fprintf(simttyo,"%s\n", msg);
}

void sim_print_instr(INT16 addr)
{
	char s[80];
	do_disassembling(addr, s);
	fprintf(simttyo,"%s\n",s);
}
