/****************************************************************/
/* 8051 Simulator by Alberto Firpo                              */
/*     e-mail: firpo@educ.disi.unige.it                         */
/****************************************************************/
#include <stdio.h>
#include "sim8051.h"
#include "mem8051.h"

static FILE * exe;

static int read_int(unsigned char * s, int n)
{
  long int val;
  unsigned char save;
  save = s[n];
  s[n] = '\0';
  val = strtol(s, NULL, 16);
  s[n] = save;
  return val;
}

/**********************************************************
 Return values: NULL = Load Terminated Correctly
                <string> = Literaly Error Description when errno is 0
		"see errno" = use perror to get error description		
**********************************************************/
unsigned char * load_intel(unsigned char * filename)
{
	unsigned char line[256+13];
	int rval;
	INT8 count,checksum,type;
	INT16 address;
	exe = fopen(filename, "r");
	if (exe == NULL)
		return "see errno";
	while (1)
	{
		line[0] = '\0';
		rval = fscanf(exe,"%s",line);
		if (rval == EOF)
		{
			if (type == 1)
				return NULL;
			else
				return("Unexpected End Of File");
		}
		if ( (line[0] != ':') || (strlen(line) < 11) )
			return("Invalid Intel record");
		count = read_int(&line[1],2);
		checksum = count;
		if  (strlen(line) < 11+2*count) 
			return("Too Small record");
		address = read_int(&line[3],4);
		checksum += (address & 0xff);
		checksum += ((address & 0xff00) >> 8);
		type = read_int(&line[7],2);
		checksum += type;
		if ( type > 0x1 )
			return("Invalid Record Type");
		checksum += read_int(&line[9+2*count],2);
		for ( ; count>0; count--)
		{
			CMEM[address+count-1] = read_int(&line[9+count*2-2],2);
			checksum += CMEM[address+count-1];
		}
		if (checksum)
			return("Checksum Error");
	}
}

