/****************************************************************/
/* 8051 Simulator by Alberto Firpo                              */
/*     e-mail: firpo@educ.disi.unige.it                         */
/****************************************************************/
#include <stdio.h>
#include "sim8051.h"
#include "dis_io.h"

static unsigned char * pString = NULL;

void dis_start(char * str)
{
	if ( pString )
		fprintf(stderr,"ERROR in disassembling I/O call\n");
	pString = str;
}

void dis_end(void)
{
	pString = NULL;
}

void dis_print(char * s)
{
	pString += sprintf(pString,"%s",s);
}

void dis_printchar(char c)
{
	pString += sprintf(pString,"%c",c);
}

void dis_printINT8(INT8 n,INT8 with_h)
{
	if (with_h)
		pString += sprintf(pString,"%.2Xh",n);
	else
		pString += sprintf(pString,"%.2X",n);
}

void dis_printDirect(INT8 n)
{
	unsigned char * s = get_sfr_name(n);
	if ( s )
		pString += sprintf(pString,"%s",s);
	else
		pString += sprintf(pString,"%.2Xh",n);
}

void dis_printINT16(INT16 n,INT8 with_h)
{
	if (with_h)
		pString += sprintf(pString,"%.4Xh",n);
	else
		pString += sprintf(pString,"%.4X",n);
}

void dis_printBit(INT8 n)
{
	unsigned char * s = NULL;
	if (n>=0x80)
	{
		if ( s = get_sfr_name(n & 0xf8) )
			pString += sprintf(pString,"%s",s);
		else
			pString += sprintf(pString,"%.2Xh",n & 0xf8);
	}
	else
		pString += sprintf(pString,"%.2Xh",0x20+(n>>3));
	pString += sprintf(pString,".%d", n & 0x7);
}

void dis_printADDRESS(INT16 n)
{
	char * sym;
	sym = getSymbol(n);
	if (sym == NULL)
		pString += sprintf(pString,"%.4Xh",n);
	else
	{
		pString += sprintf(pString,"%s (%.4Xh)",sym,n);
	}
}

