
%{
#include "mem8051.h"
#include "ser8051.h"
#include "int8051.h"
#define YY_BREAK  prompt(); break;

extern void make_steps(int n);
extern void make_disassemble();
extern void make_dump(char type);
extern void make_patch(char type,unsigned char * saddr, INT8 val);
extern int set_addr(char type, unsigned char * saddr);
void help(void);
void printOnOff(int val);
%}

DECNUMBER [[:digit:]]+
HEXBYTE [[:xdigit:]]{1,2}
ADDRESS .+

%%

^!.+			system(yytext+1);

go(" "+{ADDRESS})?	{
			  if (yyleng>2)
				if ( ! str2Address(yytext+3, &PC) )
				{
					YY_BREAK
				}
			  make_steps(-1);
			  disass_addr = PC;  /* exit on break */
		  	}

s			|
step			{
			  make_steps(1);
			  disass_addr = PC;
		  	}
s" "+{DECNUMBER}	|
step" "+{DECNUMBER}	{
			  make_steps(atoi(yytext+(*(yytext+1)==' ' ? 2:5)));
			  disass_addr = PC;
		  	}

load" ".+		load(yytext+5);

sload" ".+		loadSymb(yytext+6);

ser_tty" ".+		ser_open(yytext+8,yytext+8);

dr			sim_print_status();

reset			{
			  resetSFR();
			  CYCLES = 0;
			  sim_print_status();
			  disass_addr = PC;
		  	}

l			|
list			make_disassemble();
l" "+{ADDRESS}		|
list" "+{ADDRESS}	{
			  if ( str2Address(yytext+(*(yytext+1)==' ' ? 2:5),
			  	&disass_addr) )
				make_disassemble();
		  	}

d(c|x)(" "+{ADDRESS})?	{
			  if (yyleng>2)
				if ( ! set_addr(*(yytext+1), yytext+3 ))
				{
					YY_BREAK
				}
			  make_dump(*(yytext+1));
		  	}

d(d|i)(" "+{HEXBYTE})?	{
			  if (yyleng>2)
				if ( ! set_addr(*(yytext+1), yytext+3 ))
				{
					YY_BREAK
				}
			  make_dump(*(yytext+1));
		  	}

p(c|x)" "+{ADDRESS}" "+{HEXBYTE}	{
			  make_patch(*(yytext+1),
			     yytext+3,
			     strtol(yytext+yyleng-2, (char **)NULL, 16));
		  	}

p(d|i)" "+{HEXBYTE}" "+{HEXBYTE}	{
			  make_patch(*(yytext+1),
			     yytext+3,
			     strtol(yytext+yyleng-2, (char **)NULL, 16));
		  	}

break" "+{ADDRESS}      set_breakpoint(yytext+6);

delete" "+[0123456789*]           {
				if ( *(yytext+yyleng-1) == '*' )
				     del_breakpoint(0xff);
				else
				     del_breakpoint(*(yytext+yyleng-1) - '0');
			}

blist                list_breakpoint();

set" "+sms" "+(0|1)	singleMemSpace = *(yytext+yyleng-1) - '0';

ser_show_hex" "+(0|1)	serShowHex = *(yytext+yyleng-1) - '0';

ser_real_speed" "+(0|1)	serRealSpeed = *(yytext+yyleng-1) - '0';

trace_int" "+(0|1)	intShowService = *(yytext+yyleng-1) - '0';

show" "+conf		{
			  sim_print("Configuration:\n");
			  sim_print(" Single Memory Space:");
			  printOnOff(singleMemSpace);
			  sim_print(" Serial Show Hex:");
			  printOnOff(serShowHex);
			  sim_print(" Serial Real Speed:");
			  printOnOff(serRealSpeed);
			  sim_print(" Interrupt Trace:");
			  printOnOff(intShowService);
			}

quit			exit(0);

"?"			|
help			help();

^(" ")*\n               /* ignore */
\n			break;  /*ignore but without prompt */

<<EOF>>			/* ^d is ignored */

.+			sim_print("Invalid Command\n");

%%

void printOnOff(int val)
{
	sim_print("  ");
	if (val)
		sim_print_n("ON");
	else
		sim_print_n("OFF");
}

void help(void)
{
	copyright();
	sim_print("go [address]		start execution from address (default = PC)\n");
	sim_print("s[tep] [n]		execute n instructions (default n=1)\n");
	sim_print("load <file>		load in memory an Intel(c) format executable\n");
	sim_print("sload <file>		load the symbol table\n");
	sim_print("l[ist] [address]	disassemble from address specified\n");
	sim_print("dr			display registers values\n");
	sim_print("dc|dx [address]		dump the code|external area at address specified\n");
	sim_print("dd|di [address]		dump the data|internal area at address specified\n");
	sim_print("pc|px address val	patch the code|external area at address specified\n");
	sim_print("pd|pi address val	patch the data|internal area at address specified\n");
	sim_print("break address		define a breakpoint at address\n");
	sim_print("delete n|*		delete a breakpoint\n");
	sim_print("blist			list breakpoints\n");
	sim_print("ser_tty <file>		assign the simulated serial device to the specified file\n");
	sim_print("set sms 0|1		set Single Memory Space\n");
	sim_print("ser_show_hex 0|1	display hex instead chars on the simulated serial device\n");
	sim_print("ser_real_speed 0|1	simulate the busy time during tx/rx from serial device\n");
	sim_print("trace_int 0|1		display each served interrupt\n");
	sim_print("show conf		display configuration\n");
	sim_print("reset			reset cpu to power-on condition\n");
	sim_print("!<command>		execute shell <command>\n");
	sim_print("quit			exit from simulator\n");
}

