/****************************************************************/
/* 8051 Simulator by Alberto Firpo                              */
/*     e-mail: firpo@educ.disi.unige.it                         */
/****************************************************************/
#include "sim8051.h"
#include "mem8051.h"

INT16 getPaddr(INT16 addr)
{
	INT16 val;
	val = CMEM[addr] & 0xe0;
	val <<= 3;
	val |= ((addr+2) & 0xf800);
	val |= CMEM[addr+1];
	return val;
}

INT8 getReg(INT16 addr)
{
	return(CMEM[addr] & 0x07);
}

BIT isParityOdd(INT8 val)
{
	INT8 bitCount=0;
	while (val)
	{
		bitCount += (val & 0x1);
		val = val >> 1;
	}
	return bitCount & 0x1;
}

INT16 buildINT16(INT8 b1, INT8 b2)
{
        return (b1<<8)+b2;
}

