/****************************************************************/
/* 8051 Simulator by Alberto Firpo                              */
/*     e-mail: firpo@educ.disi.unige.it                         */
/****************************************************************/
#include "mem8051.h"

INT8 ANL(INT8 dst,INT8 src)
{
	return dst&src;
}

void sim_CLR_A(INT16 addr)
{
	writeDirect(ACC,0);
}

INT8 CPLA(INT8 a)
{
	return ~a;
}

INT8 ORL(INT8 dst,INT8 src)
{
	return dst|src;
}

void sim_RL_A(INT16 addr)
{
	register INT8 a = readDirect(ACC);
	writeDirect(ACC, (a << 1) | ((a & 0x80) ? 1 : 0));
}


void sim_RLC_A(INT16 addr)
{
	register INT8 a = readDirect(ACC);
	register BIT c = readBit(CARRY);
	writeBit(CARRY, (a & 0x80) ? 1 : 0);
	writeDirect(ACC, (a<<1) | c);
}


void sim_RR_A(INT16 addr)
{
	register INT8 a = readDirect(ACC);
	writeDirect(ACC, (a >> 1) | ((a & 0x1) ? 0x80 : 0));
	writeDirect(ACC, readDirect(ACC) >> 1);
}


void sim_RRC_A(INT16 addr)
{
	register INT8 a = readDirect(ACC);
	register BIT c = readBit(CARRY);
	writeBit(CARRY, (a & 0x1) );
	writeDirect(ACC, (a>>1) | (c ? 0x80 : 0));
}

INT8 XRL(INT8 dst,INT8 src)
{
	return dst^src;
}
