/****************************************************************/
/* 8051 Simulator by Alberto Firpo                              */
/*     e-mail: firpo@educ.disi.unige.it                         */
/****************************************************************/
#include "mem8051.h"

void sim_MOV_DIR_DIR(INT16 addr)
{
   writeDirect(CMEM[addr+2],readDirect(CMEM[addr+1]));
}

void sim_MOVX_A_INDIR(INT16 addr)
{
	writeDirect(ACC, readExtRam(buildINT16( readDirect(P0), readIndirect(readReg(CMEM[addr] & 0x1)))));
}


void sim_MOVX_INDIR_A(INT16 addr)
{
	writeExtRam( buildINT16( readDirect(P0), readIndirect(readReg(CMEM[addr] & 0x1))), readDirect(ACC));
}

void sim_POP_DIR(INT16 addr)
{
	writeDirect(CMEM[addr+1], popINT8() );
}


void sim_PUSH_DIR(INT16 addr)
{
	pushINT8( readDirect(CMEM[addr+1]) );
}


INT8 SWAPA(register INT8 a)
{
	return (a << 4) | (a >> 4);
}


void sim_XCH_A_REG(INT16 addr)
{
	INT8 a=readDirect(ACC);
	writeDirect(ACC, readReg(getReg(addr)));
	writeReg(getReg(addr), a);
}


void sim_XCH_A_DIR(INT16 addr)
{
	INT8 a=readDirect(ACC);
	writeDirect(ACC, readDirect(CMEM[addr+1]));
	writeDirect(CMEM[addr+1], a);
}


void sim_XCH_A_INDIR(INT16 addr)
{
	INT8 a=readDirect(ACC);
	writeDirect(ACC, readIndirect(readReg(CMEM[addr] & 0x1)));
	writeIndirect( readReg(CMEM[addr] & 0x1), a);
}


void sim_XCHD_A_INDIR(INT16 addr)
{
	INT8 a=readDirect(ACC);
	INT8 r=readIndirect(readReg(CMEM[addr] & 0x1));
	writeIndirect( readReg(CMEM[addr] & 0x1), (r & 0xf0) | (a & 0xf));
	writeDirect(ACC, (a & 0xf0) | (r & 0xf));
}


