/****************************************************************/
/* 8051 Simulator by Alberto Firpo                              */
/*     e-mail: firpo@educ.disi.unige.it                         */
/****************************************************************/
#include "mem8051.h"
#include "int8051.h"
#include "sim_io.h"

void sim_ACALL_PADDR(INT16 addr)
{
	pushPC();
	PC &= 0xf800;  /* Reset PC10-0 */
	PC |= getPaddr(addr);    /* PC10-0 <- page address */
}

void sim_AJMP_PADDR(INT16 addr)
{
	PC &= 0xf800;  /* Reset PC10-0 */
	PC |= getPaddr(addr);    /* PC10-0 <- page address */
}

void CJNE(register INT8 Ist, register INT8 IInd, SINT8 rel)
{
	if (Ist != IInd)
		PC = PC + rel;
	if (Ist < IInd)
		writeBit(CARRY,1);
	else
		writeBit(CARRY,0);
}

INT8 DJNZ(INT8 arg, SINT8 rel)
{
	if (--arg != 0)
		PC += rel;
	return arg;
}

void JB(BIT bit, SINT8 rel)
{
	if (bit == 1)
		PC += rel;
}

void sim_JBC_BADDR_RADDR(INT16 addr)
{
	if (readBit(CMEM[addr+1]) == 1)
	{
		writeBit(CMEM[addr+1],0);
		PC += (SINT8)CMEM[addr+2];
	}
}

void JC(SINT8 rel)
{
	if (readBit(CARRY) == 1)
		PC += rel;
}

void JMPADP(INT16 addr)	/* JMP @A+DPTR */
{
	PC = addr;
}

void JNB(BIT bit, SINT8 rel)
{
	if (bit == 0)
		PC += rel;
}

void JNC(SINT8 rel)
{
	if (readBit(CARRY) == 0)
		PC += rel;
}

void JNZ(SINT8 rel)
{
	if (readDirect(ACC) != 0)
		PC += rel;
}

void JZ(SINT8 rel)
{
	if (readDirect(ACC) == 0)
		PC += rel;
}

void LCALL(INT16 addr)
{
	pushPC();
	PC = addr;
}

void LJMP(INT16 addr)
{
	PC = addr;
}

void sim_NOP(INT16 addr)
{
}

void sim_RET(INT16 addr)
{
	popPC();
}


void sim_RETI(INT16 addr)
{
	popPC();
	delayInterrupt();
	if ( ! terminateISR() )
		sim_error("RETI outside Interrupt Routine");
}


void SJMP(SINT8 rel)
{
	PC += rel;
}


