/****************************************************************/
/* 8051 Simulator by Alberto Firpo                              */
/*     e-mail: firpo@educ.disi.unige.it                         */
/****************************************************************/
#include "mem8051.h"

BIT ANLC(BIT c,BIT src)
{
	return c&src;
}

void sim_CLR_C(INT16 addr)
{
	writeBit(CARRY,0);
}


void sim_CLR_BADDR(INT16 addr)
{
	writeBit(CMEM[addr+1],0);
}

BIT CPLBit(BIT b)
{
	return b ? 0:1;
}

BIT MOVCB(BIT c, BIT bit)
{
	return bit;
}

BIT MOVBC(BIT bit, BIT c)
{
	return c;
}

BIT ORLC(BIT c,BIT src)
{
	return c|src;
}

void sim_SETB_C(INT16 addr)
{
	writeBit(CARRY, 1);
}


INT8 sim_SETB_BADDR(INT16 addr)
{
	writeBit(CMEM[addr+1], 1);
}

