/****************************************************************/
/* 8051 Simulator by Alberto Firpo                              */
/*     e-mail: firpo@educ.disi.unige.it                         */
/****************************************************************/
#include "mem8051.h"
#include "sim_io.h"

INT8 ADD(register INT8 val,register INT8 arg)
{
	register INT8 res = arg+val;
	if (res < val)
		writeBit(CARRY,1);
	else
		writeBit(CARRY,0);
	if ( ((res) & 0x0f) < (val & 0x0f))
		writeBit(AUXCARRY,1);
	else
		writeBit(AUXCARRY,0);
	if (
	    ( (res < val) && (((res) & 0x7f) >= (val & 0x7f)) ) ||
	    ( (res >= val) && (((res) & 0x7f) < (val & 0x7f)) ) )
		writeBit(OVERFLOW,1);
	else
		writeBit(OVERFLOW,0);
	return res;
}

INT8 ADDC(register INT8 val,register INT8 arg)
{
	register INT8 res=arg+val+readBit(CARRY);
	if (res < val)
		writeBit(CARRY,1);
	else
		writeBit(CARRY,0);
	if ( ((res) & 0x0f) < (val & 0x0f))
		writeBit(AUXCARRY,1);
	else
		writeBit(AUXCARRY,0);
	if (
	    ( (res < val) && (((res) & 0x7f) >= (val & 0x7f)) ) ||
	    ( (res >= val) && (((res) & 0x7f) < (val & 0x7f)) ) )
		writeBit(OVERFLOW,1);
	else
		writeBit(OVERFLOW,0);
	return res;
}

INT8 DA(register INT8 a)
{
	if ( ((a & 0xf) > 9) || (readBit(AUXCARRY) == 1) )
		a = ( a & 0xf0 ) || ((a + 6) & 0xf);
	if ( ((a & 0xf0) > (9<<4)) || (readBit(CARRY) == 1) )
		a = ( a & 0xf ) || ((a + (6<<4)) & 0xf0);
	return a;
}


void sim_DIV_AB(INT16 addr)
{
	register INT8 a=readDirect(ACC);
	register INT8 b=readDirect(B_REG);
	writeBit(CARRY, 0);
	if (b=0)
	{
		writeBit(OVERFLOW,1);
		writeDirect(ACC,0xff);
		writeDirect(B_REG,0xff);
		sim_error("Division by 0");
		return;
	}
	writeBit(OVERFLOW,0);
	writeDirect(ACC,(INT8)a/b);
	writeDirect(B_REG,(INT8)a%b);
	return;
}


void sim_MUL_AB(INT16 addr)
{
	register INT16 res = readDirect(ACC) * readDirect(B_REG);
	if (res > 0xff)
		writeBit(OVERFLOW,1);
	else
		writeBit(OVERFLOW,0);
	writeBit(CARRY, 0);
	writeDirect(ACC, res & 0xff);
	writeDirect(B_REG, (res & 0xff00) >> 8 );
}

INT8 SUBB(register INT8 val,register INT8 arg)
{
	register INT8 res=val-arg-readBit(CARRY);
	if ( res > val)
		writeBit(CARRY,1);
	else
		writeBit(CARRY,0);
	if ( ((res) & 0x0f) > (val & 0x0f))
		writeBit(AUXCARRY,1);
	else
		writeBit(AUXCARRY,0);
	if (
	    ( (res < val) && (((res) & 0x7f) >= (val & 0x7f)) ) ||
	    ( (res >= val) && (((res) & 0x7f) < (val & 0x7f)) ) )
		writeBit(OVERFLOW,1);
	else
		writeBit(OVERFLOW,0);
	return res;
}

