/****************************************************************/
/* 8051 Simulator by Alberto Firpo                              */
/*     e-mail: firpo@educ.disi.unige.it                         */
/****************************************************************/
#ifndef _SIM8051_H_
#define _SIM8051_H_

#ifndef NULL
#define NULL (void*)0
#endif

typedef unsigned char INT8;
typedef signed char SINT8;
typedef unsigned short INT16;
typedef unsigned long INT32;
typedef INT8 BIT;	/* 0 or 1 */

extern void init_instTab(void);
extern INT16 do_disassembling(INT16 addr, unsigned char * str);
extern void do_step(void);
extern unsigned char * get_sfr_name(INT8 Daddr);

extern unsigned char * load_intel(unsigned char * filename);

extern BIT isParityOdd(INT8 val);

extern INT16 getPaddr(INT16);
extern INT8 getReg(INT16);
extern INT16 buildINT16(INT8, INT8);

extern unsigned long CYCLES;

#define LINES_FOR_DUMPS	10
#define BYTES_FOR_DUMP_LINE	16

extern INT16 disass_addr;   /* used also for code dump */
extern INT16 external_addr;
extern INT8 direct_addr;
extern INT8 indirect_addr;

#endif
