/****************************************************************/
/* 8051 Simulator by Alberto Firpo                              */
/*     e-mail: firpo@educ.disi.unige.it                         */
/****************************************************************/
#ifndef _MEM8051_H_
#define _MEM8051_H_

#include "sim8051.h"

/* Program Counter */
extern INT16 PC;

/* Program Memory 64K bytes */
extern INT8 CMEM[0x10000];

/* Flags for Single Memory Space ( /PSEN & /RD ) */
extern int singleMemSpace;

/* Defines for SFR locations */
#define B_REG 0xf0
#define ACC 0xe0
#define PSW 0xd0
#ifdef SIM8052
#define T2CON 0xc8
#define RCAP2L 0xca
#define RCAP2H 0xcb
#define TL2 0xcc
#define TH2 0xcd
#endif
#define IP 0xb8
#define P3 0xb0
#define IE 0xa8
#define P2 0xa0
#define SCON 0x98
#define SBUF 0x99
#define P1 0x90
#define TCON 0x88
#define TMOD 0x89
#define TL0 0x8a
#define TL1 0x8b
#define TH0 0x8c
#define TH1 0x8d
#define P0 0x80
#define SP 0x81
#define DPL 0x82
#define DPH 0x83
#define PCON 0x87

/* Defines for PSW bits */
#define CARRY PSW+7
#define AUXCARRY PSW+6
#define OVERFLOW PSW+2
#define PARITY PSW+0

/* Interface Functions for Data Memory Access */
extern void resetSFR(void);

extern INT8 readDirect(INT8 Daddr);
extern void writeDirect(INT8 Daddr, INT8 val);

extern INT8 readIndirect(INT8 Iaddr);
extern void writeIndirect(INT8 Iaddr, INT8 val);

extern INT8 readExtRam(INT16 addr);
extern void writeExtRam(INT16 addr, INT8 val);

extern BIT readBit(INT8 Baddr);
extern void writeBit(INT8 Baddr, BIT bit);

extern INT8 readReg(INT8 reg);
extern void writeReg(INT8 reg, INT8 val);

extern INT16 readDPTR(void);
extern void writeDPTR(INT16 val);

extern void pushINT8(INT8 val);
extern INT8 popINT8(void);
extern void pushPC(void);
extern void popPC(void);

extern char * sim_expand_PSW(void);
#endif
