/****************************************************************/
/* 8051 Simulator by Alberto Firpo                              */
/*     e-mail: firpo@educ.disi.unige.it                         */
/****************************************************************/
#ifndef _INT8051_H_
#define _INT8051_H_

#include "sim8051.h"

/* Flags to display when interrupts are served */
extern int intShowService; 

/* Defines for Interrupt Sources */
#define INT_T2 0x20
#define INT_SERIAL 0x10
#define INT_TIMER1 0x8
#define INT_EXT1 0x4
#define INT_TIMER0 0x2
#define INT_EXT0 0x1

/* interface */
extern void resetInterrupt(void);
extern void gen_int(INT8 interrupt);
extern void clear_int(INT8 interrupt);
extern char * getIntPending(void);

/* Returns: 1 = ok; 0 = Warning you are not inside a ISR */
extern int terminateISR(void);

/* used by RETI and access to IE or IP to delay interrupt */
extern void delayInterrupt(void);

/* returns 0 i NO interrupt request; otherwise the ISR begin address */
extern INT16 checkInterrupt(void);

#endif
