/* syncd.c -- Sync Daemon.  Makes sure your disk is safe in case of crashes.
 * By: Steve Conley.  [c]1998 Serpentine Network Industries
 ***************************************************************************
 * This software is availible under the conditions of the GNU Public License
 */

/* System includes */
#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>


int	main(int argc,char** argv,char** envp){
	int	sleeptime; /* Time to sleep between sync's */

	if(argc > 1){ /* Do we have an arguement?  If so, check to see if */
		if(isdigit(argv[1][0])) /* it is an int */
			sleeptime=atoi(argv[1]); /* If so, use it */
		else{ /* Otherwise, trash it */
			printf("Syntax: %s [optional: seconds to sleep between sync commands]\n",argv[0]);
			return (int) 0;
		}
	}else{ /* Otherwise, use a default value */
		sleeptime=60*5; /* 5 minutes */
	}
	close(0); /* Close stdin, stdout, stderr */
	close(1);
	close(2);
	if(!fork()){ /* Detach process from shell */
		while(1){ /* Run as a daemon, sync'ing and sleeping */
			sync();
			sleep(sleeptime);
		}
	}
	return (int) 0; /* Kill off the shell command */
}
