/*
 *       switchd.c   monitor keyboard and switch to a vc on inactivity.
 *
 *       Copyright (c) 1996 by Ervin Walter <00edwalter@bsuvc.bsu.edu>
 *
 *       This program is free software; you can redistribute it and/or
 *       modify it under the terms of the GNU General Public License
 *       as published by the Free Software Foundation; either version
 *       2 of the License, or (at your option) any later version.
 *
 */

#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <stdlib.h>
#include <fcntl.h>
#include <sys/vt.h>
#include <linux/tty.h>

#define VERSION "0.1"

void usage(int stat)
{
   fprintf(stderr,
      "switchd version " VERSION "\n"
      "Usage: switchd inactivity_delay monitor_interval target_vt\n");
   exit (stat);
}

void main (int argc, char **argv)
{
	long oldkbdcount, currkbdcount, currtime=0;
	int delaybetween, delaytime, active=0, pid;
	FILE *intfp;
	char line[80], kbdnumstr[10];

	int fd;
	int vtno     = -1;

	if (argc != 4)
		usage(1);

	vtno = (int) atol(argv[3]);

	if (vtno <= 0 || vtno > MAX_NR_CONSOLES)
		usage(2);

	delaytime = atoi(argv[1]);
	delaybetween = atoi(argv[2]);

	if (geteuid() && getuid())
	{
		fprintf(stderr, "switchd: must be root.\n");
		exit(3);
	}

        if ((fd = open("/dev/console",O_WRONLY)) < 0) {
                perror("switchd: Can't open /dev/console\n");
                exit(4);
	}
	
	if ((pid = fork()) < 0)
        {
                perror("Couldn't fork() daemon process");
                exit(5);
	}
        else
		if (pid != 0)
			exit(0);

        /* From here on out, it's daemon all the way... */

        setsid();
        chdir("/");
        umask(0);
        close(STDIN_FILENO);
        close(STDOUT_FILENO);
        close(STDERR_FILENO);

	while(1) 
	{
		if ((intfp = fopen("/proc/interrupts", "r")) != NULL)
		{
			while (fgets(line, 80, intfp) != NULL)
			{
				if (strstr(line, "keyboard") != NULL)
				{
					strncpy(kbdnumstr, &line[3], 9);
					kbdnumstr[9] = '\0';
					currkbdcount = atoi(kbdnumstr);
					if (currkbdcount == oldkbdcount) 
					{
						currtime += delaybetween;
					}
					else
					{
						currtime = 0;
						active = 0;
					}
					if ((currtime >= delaytime) && !active) 
					{
						active = 1;
						if (ioctl(fd, VT_ACTIVATE, vtno) < 0) 
						{
							close(fd);
							exit(6);
						}
						(void) ioctl(fd, VT_WAITACTIVE, vtno);
					}
					oldkbdcount = currkbdcount;
				}
			}
		fclose(intfp);
		}
	usleep(delaybetween*1000000);
	}
}

