/*
 *  Project     : sendkey
 *  Version     : 0.9
 *  Description : A daemon to send key trought a fifo file.
 *		  Put text or keycodes in some tty input buffer.
 *		  You may have to be root if the tty is not
 *                your controlling tty.
 *
 *  Copyright (C) 1998 Luca Montecchiani <m.luca@usa.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/*****************************************************************************
include section
******************************************************************************/
#include <stdio.h>
#include <fcntl.h>
#include <stdlib.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/time.h>
#include <unistd.h>
#include <linux/kd.h>

/*****************************************************************************
define section
******************************************************************************/
#define TRUE            1               // true  ;-)
#define FALSE           0               // false :-(

/*****************************************************************************
function declarations
******************************************************************************/
int 	main(int argc, char **argv) ;
void 	Error(int no,int severe);
void 	Loop();
int 	send_char(char *s);
int 	get_kbd_mode();
int 	set_kbmode(int mode);
void 	Test();
int 	fixdelay(int p,int set);
void 	LeggiFifo();
int 	fd_select(int max_time);
int 	getfd();

/*****************************************************************************
variables declarations
******************************************************************************/
int 	fine,res,fpin,run,cfd,i;
char 	car;
static 	fd_set rr,ww,xx;

/*****************************************************************************
main function of sendeky.c
******************************************************************************/
int main(int argc, char **argv) 
{
if ( argc != 2 ) 
	{
	fprintf(stderr, "\nsendkey 0.9 - Copyright (C) 1998 Luca Montecchiani <m.luca@usa.net>\n\nuse: sendkey <file fifo>\n\n");
	exit(1);
	}

if ( ( strcmp(argv[1],"test") == 0 ) || ( strcmp(argv[1],"TEST") == 0 ) )
	{
	Test();
	exit(0);
	}
else	{
	char *buf = (char *) malloc(512);
	/* remove the file */
	remove(argv[1]);
	/* open fifo file */
	sprintf(buf,"/bin/mknod %s p >/dev/null 2>/dev/null",argv[1]);
	system(buf);
	free(buf);
	fpin = open(argv[1],O_RDONLY | O_NDELAY);
	Loop();
	/* close fifo file */
	close(fpin);
	}
/* remove the file */
remove(argv[1]);
fprintf(stdout, "sendkey killed...\n");
exit(0);
}

/*****************************************************************************
Error function
******************************************************************************/
void Error(int no,int severe)
{
if ( severe == 1 )
	exit(no);
}

/*****************************************************************************
main loop cicle
******************************************************************************/
void Loop()
{
run = TRUE;
while ( run ) 
	{
	FD_ZERO(&rr);
	FD_ZERO(&ww);
	FD_ZERO(&xx);
	FD_SET(fpin,&rr);
	fixdelay(fpin,1);
	if ( fd_select(60) == -1 )
		continue;

	if ( FD_ISSET(fpin,&rr) )
		LeggiFifo();
	}
fixdelay(fpin,0);
close(fpin);
}

/*****************************************************************************
send a char to the current tty
******************************************************************************/
int send_char(char *s)
{
/* current tty determinations */
cfd = getfd();
if ( cfd < 0 ) 
	{
	fprintf(stderr, "sti: could not open tty\n");
	exit(1);
	}
if ( ioctl(cfd,TIOCSTI,s) ) 
	{
	perror("TIOCSTI");
	fprintf(stderr, "sti: TIOCSTI ioctl failed\n");
	return (1);
	}
return (0);
}

/*****************************************************************************
get the status of keyboard ( K_XLATE,K_UNICODE,K_RAW,K_MEDIUMRAW )
******************************************************************************/
int get_kbd_mode()
{
int mode = -1;
if ( ioctl(cfd, KDGKBMODE, &mode) )
	return(-1);
else	return(mode);
}

/*****************************************************************************
set the status of keyboard ( K_XLATE,K_UNICODE,K_RAW,K_MEDIUMRAW )
******************************************************************************/
int set_kbmode(int mode)
{
if ( ioctl(cfd, KDSKBMODE, mode) ) 
	{
	perror("kbd_mode: error setting keyboard mode\n");
	return(1);
	}
return(0);
}

/*****************************************************************************
test routine
******************************************************************************/
void Test()
{
char 	raw[] = "\x2e\xae\x17\x97\x1e\x9e\x18\x98";
char 	ascii[] = "test";
int 	mode;
i = 0;
/* current tty determinations */
cfd = getfd();
if ( cfd < 0 ) 
	{
	fprintf(stderr, "sti: could not open tty\n");
	exit(1);
	}

mode = get_kbd_mode();

if ( mode == -1 )
	{
	fprintf(stderr, "sintax: sendkey <file fifo>\n");
	exit(1);
	}

if ( mode == K_XLATE )
	{
	while ( ascii[i] != 0 )
		{
		send_char(&ascii[i]);
		i++;
		}
	}

if ( mode == K_RAW )
	{
	while ( raw[i] != 0 )
		{
		send_char(&raw[i]);
		i++;
		}
	}
}

/*****************************************************************************
fixdelay function
******************************************************************************/
int fixdelay(int p,int set)
{
int risp;
risp = fcntl(p,F_GETFL,0);
switch (set)
	{
	case 1:
		if ((risp & O_NDELAY) != O_NDELAY )
		risp=fcntl(p,F_SETFL,risp | O_NDELAY);
		break;
	default :
		if ((risp & O_NDELAY) == O_NDELAY )
		risp=fcntl(p,F_SETFL,risp & ~(O_NDELAY));
		break;
	}
risp=fcntl(p,F_GETFL,0);
return(risp);
}

/*****************************************************************************
Read one or more character from fifo file
******************************************************************************/
void LeggiFifo()
{
while ( read(fpin,&car,1) > 0 )
	{
	// fprintf(stdout,"File fifo : %c : Val %d \r\n",car,car);
	if ( car == 7 ) /* this will exit program */
		run = FALSE;
	else	send_char(&car);
	}
}

/*****************************************************************************
sd_select function
******************************************************************************/
int fd_select(int max_time)
{
struct timeval tv;
tv.tv_sec   = max_time;
tv.tv_usec  = 0;
return(select(64,&rr,&ww,&xx,(struct timeval *) &tv));
}

/*****************************************************************************
getfd : Get an fd for use with kbd/console ioctls.
******************************************************************************/
int getfd() 
{
return(open("/dev/console", O_RDONLY));
}
