#include <limits.h>

#define LOGNAME "runpiped"	  /* The name which will appear in syslog messages from the daemon */

#ifndef FALSE
#define FALSE (0)
#endif
#ifndef TRUE
#define TRUE (1)
#endif

#define MAXMESSLEN 20000     /* The maximum length of a command + arguments to be run on the pipe
				should not be bigger than a signed int   */

#define HIBITMASK 0x80    /* Use this to quote blanks in passed arguments */

#define FSEP ' '          /* Field separator */
#define MANYFSEP "  "     /* Two instances of the field separator */

#define MAXMSGLEN 100			  /* Longest text expected in reply, not including path names */

#define RESPONSELEN (MAXPATHLEN + MAXPATHLEN + MAXMSGLEN)

#define READ 'r'	  /* Single character flags use in the messages system */
#define WRITE 'w'
#define READWRITE 'b'
#define DELETE 'd'
#define LISTTAB 't'

#define BLANK ' '
#define BLANKSTR " "

#define NULLDEV "/dev/null"	/* Send messages there */

#define BADUSAGE 1

#define PING   "Daemon listening?"	      /* Strings to check for running daemon */
#define PONG   "Yes, daemon listening."

#define DAEMON 1
#define CLIENT 2

int ismypipe(const char *filename, uid_t myuid);
int ismysocket(const char *filename, uid_t myuid);
int ismydir(const char *filename, uid_t myuid);
void gensockpath(char *socketpath, int calledby);
