#! /bin/bash
# This is the file /etc/init.d/rclink2file.sh to create a configuration
# file for r2d2
#
# Author: Winfried Trmper <winni@xpilot.org>
#
# 28.07.96 v0.4


cat <<EOF
# This file was automatically generated by $0. You can use your
# favourite editor or "./update-rc.d" to modify it.
#
# Format:
# <sort> <off-> <on-levels>     <command>
EOF

(cat <<EOF
05	-	0		/etc/init.d/halt
05	-	1		/etc/init.d/single
05	-	6		/etc/init.d/reboot
EOF
for script in /etc/init.d/*
do
    filename=${script#/etc/init.d/}
    case $filename in
	halt | single| reboot | modules | *dist | *orig | skeleton | urandom | rc | README | boot | functions | network | powerfail)
	    continue
	    ;;
    esac
    STOP=","; START=","
    for i in 0 1 2 3 4 5 6
    do
	if [ -f /etc/rc$i.d/K??$filename ]
	then
	    for j in /etc/rc$i.d/K[0-9][0-9]$filename; do
		number=$j
	    done
	    number=${number#/etc/rc$i.d/K}
	    number=${number%$filename}
	    let number=100-$number
	    STOP="$STOP$i,"
	fi
    done
    for i in 0 1 2 3 4 5 6
    do
	if [ -f /etc/rc$i.d/S??$filename ]
	then
	    for  j in /etc/rc$i.d/S[0-9][0-9]$filename; do
		number=$j
	    done
	    number=${number#/etc/rc$i.d/S}
	    number=${number%$filename}

	    START="$START$i,"
	fi
    done
    echo -e "$number\t$STOP\t$START\t\t$script"
done) | \
sed -e "s	,		-	g" \
    -e "s,		g" \
    -e "s	,	g" |\
sort -n
echo "# THE LAST LINE IS NEVER READ!"
