#! /bin/bash
# This is the file /etc/r2d2/rclink2file.sh to create a configuration
# file for r2d2
#
# Author: Winfried Trmper <winni@xpilot.org>
#
# 28.07.96 v0.4


cat <<EOF
# This file was automatically generated by $0. You can use your
# favourite editor or "./update-rc.d" to modify it.
#
# Please note that all commands specified in runlevel B must be on the root-fs.
#

$path   -       -       /etc/r2d2:/etc/init.d:/etc/rc.d/init.d:/sbin/init.d

# Format:
# sort  off-  on-levels command
# -----------------------------

EOF

(for PREFIX in /sbin/init.d /etc/init.d /etc/rc.d/init.d
do
    [ -f $PREFIX/halt ] && break
done

cd $PREFIX
for script in *[^~]
do
    filename=${script#$PREFIX}
    case $filename in
	halt | single| reboot | modules | *dist | *orig | skeleton | urandom | rc | README | boot | functions | network | powerfail)
	    continue
	    ;;
    esac
    STOP=","; START=","
    for i in 0 1 2 3 4 5 6
    do
	if [ -f /etc/rc$i.d/K??$filename ]
	then
	    for j in /etc/rc$i.d/K[0-9][0-9]$filename; do
		number=$j
	    done
	    number=${number#/etc/rc$i.d/K}
	    number=${number%$filename}
	    let number=100-$number
	    STOP="$STOP$i,"
	fi
    done
    for i in 0 1 2 3 4 5 6
    do
	if [ -f /etc/rc$i.d/S??$filename ]
	then
	    for  j in /etc/rc$i.d/S[0-9][0-9]$filename; do
		number=$j
	    done
	    number=${number#/etc/rc$i.d/S}
	    number=${number%$filename}

	    START="$START$i,"
	fi
    done
    echo -e "${number}0\t$STOP\t$START\t\t$script"
done
cat <<EOF
05	-	6		reboot
05	-	1		single
05	-	0		halt
EOF
) | \
sed -e "s	,		-	g" \
    -e "s,		g" \
    -e "s	,	g" \
| sort -rn
echo "# The last line of this file is never read - don't remove it"


