/*
 * Routines for daemon, killproc, killall5, pidof, and runlevel.
 *
 * Version:     1.9 05-Aug-1999 Fink
 *
 * Copyright 1994,95 Werner Fink, 1996-98 S.u.S.E. GmbH Fuerth, Germany.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Author:    Werner Fink <werner@suse.de>, 1994-1998
 *
 * 1998/09/29 Werner Fink: Add kernel thread handling.
 * 1999/02/24 Werner Fink: Add xread to avoid EINTR
 * 1999/08/05 Werner Fink: environment, move some inlined into libint.c
 */

#include <stdlib.h>
#include <stdio.h>
#include <dirent.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/wait.h>
#include <utmp.h>
#include <pwd.h>
#include <string.h>
#include <unistd.h>
#include <fcntl.h>
#include <signal.h>
#include <syslog.h>
#include <errno.h>
#include <stdarg.h>
#include <ctype.h>

#define LOG_OPTIONS	(LOG_ODELAY|LOG_CONS)

#define PIDOF   0x0001
#define DAEMON  0x0002
#define KILL    0x0004
#define KTHREAD 0x0008
#define NZOMBIE 0x0010

#define  MAXENV  20
#define  CMDLLEN 22		/* The string length of /proc/12345/cmdline\0\0 + 1 */
#ifdef _PATH_VARRUN
# define DEFPIDDIR _PATH_VARRUN
#else
# define DEFPIDDIR "/var/run/"
#endif
#define  DEFPIDEXT ".pid"
#define  DEFPIDLEN 14		/* The string length of /var/run/.pid + 1 */

extern char **environ;
extern char     * newenvp[];
extern unsigned   newenvc;

extern char * we_are;
extern unsigned short stopped;
extern pid_t p_pid, p_sid, p_ppid;

/* Declare */
extern void getproc();
extern int  pidof  (const char * fullname, const unsigned short flag);
extern int  verify_pidfile (const char * pid_file, const char * fullname,
			    const unsigned short flag);
extern int  check_pids (const char * fullname, const unsigned short flag);
extern void nsyslog(int pri, char *fmt, ...);

/* Feature */
extern char *sys_signame [];
extern char *sys_sigalias[];
extern void init_signames();

extern int signame_to_signum (const char *sig);

/* Used in killproc.c only once to list the signal names */
extern inline void list_signames(void)
{
    int n, l;

    init_signames();
    for (n = 1, l = 0; n < NSIG+1; n++) {
	if (sys_signame [n]) {
	    printf("%2d) SIG%-9s", n, sys_signame [n]);
	    l++;
	}
	if (sys_sigalias[n]) {
	    printf("%2d) SIG%-9s", n, sys_sigalias[n]);
	    l++;
	}
	if (!(l % 4))
	    putc('\n', stdout);
    }
    if (l % 4)
	putc('\n', stdout);
}

typedef struct _proc_
{
    pid_t pid;			/* Process ID.             */
    pid_t sid;			/* Session ID.             */
    struct _proc_ *next;	/* Pointer to next struct. */
    struct _proc_ *prev;	/* Pointer to previous st. */
} PROC;

extern PROC * remember;

/* Inlined functions: just like macros */

extern inline void *xmalloc(const size_t bytes)
{
    void *p = malloc(bytes);

    if (p == (void*)0) {
	if (stopped) kill(-1, SIGCONT);
	nsyslog(LOG_ERR,"out of memory\n");
	exit(1);
    }
    return p;
}

extern inline char * base_name ( const char * full )
{
    char *basename = strrchr(full, '/');

    if (basename == (char *)0)
	basename = (char *)full;
    else
	basename++;

    return basename;
}

extern inline char * swap_name ( const char * base )
{
    size_t len = strlen(base) + 2 + 1;
    char *swap = (char*)xmalloc(len);

    bzero(swap,len);
    return strcat(strcat(strcpy(swap,"("),base),")");
}

extern inline char * exe_entry ( char *buf, const char *d_name )
{
    bzero(buf,sizeof(buf));
    return strcat(strcat(strcpy(buf,"/proc/"),d_name),"/exe");
}

extern inline char * stat_entry ( char *buf, const char *d_name )
{
    bzero(buf,sizeof(buf));
    return strcat(strcat(strcpy(buf,"/proc/"),d_name),"/stat");
}

extern inline char * env_entry ( char *buf, const char *d_name )
{
    bzero(buf,sizeof(buf));
    return strcat(strcat(strcpy(buf,"/proc/"),d_name),"/environ");
}

extern inline char * cmd_entry ( char *buf, const char *d_name )
{
    bzero(buf,sizeof(buf));
    return strcat(strcat(strcpy(buf,"/proc/"),d_name),"/cmdline");
}

extern inline char * pid_entry ( char *buf, const char *pid )
{
    bzero(buf,sizeof(buf));
    return strcat(strcpy(buf,"/proc/"),pid);
}

extern void addnewenv ( const char * name, const char * entry );
extern char ** runlevel(const char *file);

/* Used in startproc only once to overwrite the environment */
extern inline void set_newenv(const char * fullname)
{
    char *tmp;
    char buf[_POSIX_PATH_MAX + 1];

/*
 *  Default environment for a daemon:
 *  PATH=..., HOME=..., SHELL=...
 *  We need control environment:
 *  DAEMON=fullname, PREVLEVEL=..., RUNLEVEL=...
 */
    if ( (tmp = getenv("HOME")) != (char*)0 )
	addnewenv("HOME",tmp);
    else
	addnewenv("HOME","/");

    if ( (tmp = getenv("PATH")) != (char*)0 )
	addnewenv("PATH",tmp);
    else
	addnewenv("PATH","/usr/bin:/usr/sbin:/bin:/sbin");

    if ( (tmp = getenv("SHELL")) != (char*)0 )
	addnewenv("SHELL",tmp);
    else
	addnewenv("SHELL","/bin/sh");

    if ( (tmp = getenv("RUNLEVEL")) != (char*)0 )
	addnewenv("RUNLEVEL",tmp);

    if ( (tmp = getenv("PREVLEVEL")) != (char*)0 )
	addnewenv("PREVLEVEL",tmp);
    else {
	char ** tmp = runlevel((char*)0);
	addnewenv("PREVLEVEL",tmp[0]);
	addnewenv("RUNLEVEL", tmp[1]);
    }

    environ = (char**)newenvp; /* Make new environment active */

    (void)snprintf(buf, _POSIX_PATH_MAX, "%s",fullname);
    addnewenv("DAEMON",buf);

    return;
}

/* Used in startproc only once to extend the environment */
extern inline void set_environ(const char * fullname)
{
    char *tmp;
    char buf[_POSIX_PATH_MAX + 1];

    if ( (tmp = getenv("RUNLEVEL")) != (char*)0 )
	setenv("RUNLEVEL",tmp,1);
    if ( (tmp = getenv("PREVLEVEL")) != (char*)0 )
	setenv("PREVLEVEL",tmp,1);
    else {
	char ** tmp = runlevel((char*)0);
	setenv("PREVLEVEL",tmp[0],1);
	setenv("RUNLEVEL", tmp[1],1);
    }

    (void)snprintf(buf, _POSIX_PATH_MAX, "%s",fullname);
    setenv("DAEMON",buf,1);
    return;
}

/* Add a task to our remember list */
extern inline void do_list(const pid_t pid, const pid_t sid)
{
    PROC * p = (PROC*)xmalloc(sizeof(PROC));
    /* bzero(p,sizeof(PROC)); currently not used */
    p ->pid = pid;
    p ->sid = sid;
    if (remember)
	remember->prev = p;
    p->next = remember;
    p->prev = (PROC*)0;
    remember = p;

    return;
}

/* libinit.h ends here */
