#ifndef INIT_IPC_SYSV_INITCONNECTION_HH
#define INIT_IPC_SYSV_INITCONNECTION_HH

#include <string.h>

#include <init_ipc/sysvq.hh>

namespace init_ipc
{
  namespace sysvq 
  {
    class InitConnection : public init_ipc::InitConnection
    {
      connect_ans my_ans;
      int my_qid;
    public:
      InitConnection(int qid,id_t id,pid_t sid):init_ipc::InitConnection(sid),my_qid(qid)
      {
	my_ans.mtype = version;
	my_ans.msg_id = id;
	my_ans.total_payload = 0;
      }
      
      virtual void success() 
      {
	my_ans.status = connect_ans::successful;
	answer();
      }
      
      virtual void failure() 
      {
	my_ans.status = connect_ans::failed;
	answer();
      }
      
      virtual void deliver(const char* payload, size_t length)
      {
	my_ans.status = connect_ans::successful;

	if(!length){
	  my_ans.total_payload = 0;
	  answer();
	}
	
	while(length){
	  size_t l = length;
	  my_ans.total_payload = length;

	  if(l>sizeof(my_ans.payload))
	    l=sizeof(my_ans.payload);
	    
	  length-=l;
	    
	  memcpy(my_ans.payload,payload,l);
	  answer();
	  payload+=l;
	}
      }
    protected:
      void answer()
      {
	if(msgsnd(my_qid,&my_ans,sizeof(my_ans) - sizeof(long),IPC_NOWAIT) == -1){
	  say(_("problem returning message"));
	}
      }
    }
    ;
  }
}


#endif
