#ifndef INIT_IPC_SYSVQ
#define INIT_IPC_SYSVQ

#include <sys/types.h>
#include <sys/ipc.h>

#include "init_ipc.hh"

namespace init_ipc
{
  namespace sysvq 
  {
    typedef unsigned id_t;
    
    const long version = 2;
    key_t queue_key();

    // Keep these structures small, as the default queue size is only
    // about 8192 bytes
    struct connect_req
    {
      long mtype;
      id_t msg_id;
      key_t q_key;
    enum command_t {
      invalid,
      start_service,
      stop_service,
      forget_service,
      list_services,
      respawn,
      forget_respawn
    }command;
      char name[256];
      pid_t sid;
    }
    ;
    struct connect_ans
    {
      long mtype;
      id_t msg_id;
      enum {
	successful,
	failed
      }
      status;
      size_t total_payload;
      char payload[2048];
    }
    ;
  }
}


#endif
