#ifndef INIT_IPC_USER_HH
#define INIT_IPC_USER_HH

#include <string>

#include <string.h>
#include <stdio.h>

#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/msg.h>
#include <unistd.h>
#include <errno.h>

#include "init_ipc/sysvq.hh"
#include "need/error.hh"

namespace init_ipc
{
  class User
  {
    int my_ans_qid;
    key_t my_ans_q_key;
    int my_req_qid;

  public:
    User():my_ans_qid(-1),my_req_qid(-1),my_ans_q_key(0)
    {
    }
    ~User()
    {
      close();
    }
    
    bool open()
    {
      if(my_ans_qid!=-1||my_req_qid!=!-1)
	close();

      my_req_qid = msgget(sysvq::queue_key(),0);
      if(my_req_qid==-1){
	error(_("could not open SysV queue to init: ") << strerror(errno) );
	return false;
      }

      int tries = 10;
      my_ans_q_key = rand();
      for(key_t k=my_ans_q_key+1;k!=my_ans_q_key;k++){
	my_ans_qid = msgget(k,IPC_CREAT|IPC_EXCL|0700);
	if(my_ans_qid!=-1){
	  my_ans_q_key = k;
	  goto got_queue;
	}
	if(errno == EEXIST)
	  continue;
	if(errno == ENOSPC && --tries){
	  sleep(1);  // FIXME: should we try to raise the number of queues?
	  continue;
	}
	  
	error(_("could not open SysV queue for callback: ") << strerror(errno) );
	return false;
      }
      error(_("could not find an unused SysV queue for callback: ") << strerror(errno));
      return false;
      
    got_queue:
      return true;
    }
    bool start_service(const std::string&name)
    {
      return do_service(name,sysvq::connect_req::start_service);
    }
    
    bool forget_service(const std::string&name)
    {
      return do_service(name,sysvq::connect_req::forget_service);
    }
    
    bool stop_service(const std::string&name)
    {
      return do_service(name,sysvq::connect_req::stop_service);
    }
    bool forget_respawn(const std::string&id)
    {
      return do_service(id,sysvq::connect_req::forget_respawn);
    }
    
    bool respawn(const char*id,const char**args)
    {
      sysvq::connect_req req;
      init_req(req);
      req.command = sysvq::connect_req::respawn;
      unsigned length = sizeof req.name;
      char*end = req.name+length;
      char*p=req.name;
      try{
	append(p,id,end);
	if(*args)
	  append(p,*args,end);
	for(const char**i=args;*i;i++)
	  append(p,*i,end);
	append(p,"",end);
      }
      catch(Overrun){
	error(_("respawn request too long"));
	return false;
      }
      return submit(req);
    }
    
    char*list_services()
    {
      char*ret=0;
      char*str=0;
      ret = 0;
      sysvq::connect_req req;
      init_req(req);
      req.command = sysvq::connect_req::list_services;

      if(msgsnd(my_req_qid,&req,sizeof(req) - sizeof(req.mtype),0) == -1){
	perror("bulk msgsnd");
	return false;
      }
      sysvq::connect_ans ans;
      for(;;){
	if(msgrcv(my_ans_qid,&ans,sizeof(ans) - sizeof(ans.mtype),0,0)==-1){
	  perror("bulk msgrcv");
	  return false;
	}
	if(ans.status != sysvq::connect_ans::successful){
	  error(_("init reported failure on reply SysV queue"));
	  if(ret)delete ret;
	  return false;
	}
	
	if(!str)
	  str = ret = new char[ans.total_payload+1];
	  
	size_t s = ans.total_payload;
	if(s<=sizeof(ans.payload)){
	  memcpy(str,ans.payload,s);
	  str[s]=0;
	  return ret;
	}
	memcpy(str,ans.payload,sizeof ans.payload);
	  
	str+=sizeof ans.payload;
      }
    }
    
    
    bool close()
    {
      my_req_qid = -1;
      if(my_ans_qid!=-1){
	if(msgctl (my_ans_qid, IPC_RMID, NULL) != -1)
	  my_ans_qid = -1;
	else {
	  error(_("could not remove SysV queue"));
	  return false;
	}
      }
      return true;
    }

  protected:
    bool do_service(const std::string&name,sysvq::connect_req::command_t command)
    {
      sysvq::connect_req req;
      if(name.size()>sizeof req.name){
	error(_("name too long: ") << name);
	return false;
      }
      init_req(req);
      strcpy(req.name,name.c_str());
      
      req.command = command;

      return submit(req);
      
    }

    bool submit(sysvq::connect_req&req)
    {
      if(msgsnd(my_req_qid,&req,sizeof(req) - sizeof(req.mtype),0) == -1){
	perror("msgsnd");
	return false;
      }
      sysvq::connect_ans ans;
      if(msgrcv(my_ans_qid,&ans,sizeof(ans) - sizeof(ans.mtype),0,0)==-1){
	perror("msgrcv");
	return false;
      }
      return ans.status == sysvq::connect_ans::successful;
    }
    
    
    void init_req(sysvq::connect_req&req);

    class Overrun
    {
    }
    ;
    
    void append(char*&p,const char*tail,char*end)
    {
      for(;*tail;tail++,p++){
	if(p>=end)
	  throw Overrun();
	*p=*tail;
      }
      *p++=0;
    }
  }
  
  ;
  
}


#endif
