#ifndef INIT_IPC_INITCONNECTION_HH
#define INIT_IPC_INITCONNECTION_HH

#include <sys/types.h>

#include "init/ServiceStarter.hh"
#include "init/ServiceNotification.hh"
#include "init/Service.hh"
#include "init/Respawner.hh"

#include "init/bootstrap.hh"

namespace init_ipc
{
  
class InitConnection 
{
  class Callback : public ServiceNotification
  {
    Service::Status my_good,my_bad;
    class InitConnection*my_conn;
  public:
    Callback(InitConnection*c,Service::Status good, Service::Status bad):my_conn(c),my_good(good),my_bad(bad)
    {
    }
    bool event(class Service*,enum Service::Status status)
    {
      if(status==my_good)
	{
	  my_conn->success();
	  return true;
	}
      if(status == my_bad || status == Service::destroyed ){
	my_conn->failure();
	return true;
      }
      return false;
    }
    ~Callback()
    {
      delete my_conn;
    }
  };
  pid_t my_sid;
public:
  typedef std::list<std::string> Vec;

  void respawn(const Vec&v)
  {
    Vec::const_iterator i = v.begin();
    if(i==v.end()){
      failure();
      delete this;
      return;
    }
    std::string id = *i;
    if(++i==v.end()){
      debug((_("respawn request too short")));
      failure();
      delete this;
      return;
    }
    Respawner* r=global_processtab.get_respawner(id);
    if(r){
      r->clear_name();
    }
    else
      r=new Respawner(id);
    r->set_bin(*i);
    for(i++;i!=v.end();i++)
      r->add_arg(*i);

    r->start();
    
    success();
    delete this;
    return;
  }

  void forget_respawn(const std::string& id)
  {
    Respawner*r=global_processtab.get_respawner(id);
    if(!r){
      say(_("respawning process \"%s\" does not exist"),id.c_str());
      failure();
      delete this;
      return;
    }
    r->stop();
    delete r;
    success();
    delete this;
    return;
  }
  
  
  virtual void success() = 0;
  virtual void failure() = 0;
  virtual void deliver(const char* payload, size_t length) = 0;
  InitConnection(pid_t sid):my_sid(sid)
  {
  }
  
  virtual ~InitConnection()
  {
  }
  
  void start_service(const std::string& name)
  {
    Service*s;
    Process*p = global_processtab.get_process(my_sid);
    Service*parent=0;
    if(p){
      debug((_("service that requested \"%s\" is known"),name.c_str()));
      ServiceStarter*starter= dynamic_cast<ServiceStarter*>(p);
      if(starter)
	parent = starter->get_service();
      if(parent)
	debug((_("service \"%s\" needs service \"%s\""),parent->get_name().c_str(),name.c_str()));
    }
    if((s=global_processtab.get_service(name))){
      if(parent){
	s->add_dependant(parent);
	parent->add_dependency(s);
      }
      
      if(s->is_successful()){
	success();
	delete this;
	return;
      }
      
      if(!s->is_starting()){
	failure();
	delete this;
	return;
      }
    }
    else {
      s=new Service(name);
      if(parent){
	s->add_dependant(parent);
	parent->add_dependency(s);
      }
      global_inittab.start_service(s);
    }
    s->add_watcher(new Callback(this,Service::successful,Service::startup_failed));
  }
  void stop_service(std::string name)
  {
    Service*s=global_processtab.get_service(name);
    if(s){
      if(s->is_failed()||s->is_starting()){ //TODO FIXME
	failure();
	delete this;
	return;
      }
    
      s->add_watcher(new Callback(this,Service::finished,Service::shutdown_failed));
    
      if(s->is_successful())
	global_inittab.stop_service(s);
    }
    else {
      failure();
      delete this;
    }
  }

  void forget_service(std::string name)
  {
    Service*s=global_processtab.get_service(name);
    if(s) delete s;
    success();
    delete this;
  }
  void list_services()
  {
    std::string list = global_processtab.list_services();
    size_t s = list.length();
    deliver(list.c_str(),s);
    delete this;
  }
}
 ;
}

#endif
