#ifndef INIT_IPC_INIT_HH
#define INIT_IPC_INIT_HH

#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/msg.h>

#include "sysvq.hh"

namespace init_ipc 
{
  class Init 
  {
    int my_qid;
  public:
    Init() : my_qid(-1)
    {
    }
    ~Init() 
    {
      close();
    }
    
    bool open()
    {
      if(my_qid!=-1)
	close();
      
      my_qid = msgget(sysvq::queue_key(),IPC_CREAT|0700);
      if(my_qid==-1)
	return false;
      return true;
    }
    void handle_connect();
    
    bool close()
    {
      if(my_qid==-1)return true;
      if(msgctl (my_qid, IPC_RMID, NULL) == -1) return false;
      my_qid = -1;
      return true;
    }
  }
  ;
}

#endif
