#include <exception>

# include <sys/types.h>
# include <sys/ipc.h>
# include <sys/msg.h>
#include <errno.h>

#include "init/PermitSignals.hh"
#include "init/bootstrap.hh"
#include "init/Inittab.hh"
#include "init/ServiceNotification.hh"
#include "init/Service.hh"

#include "InitConnection.hh"
#include "sysvq/InitConnection.hh"

#include "Init.hh"
#include "sysvq.hh"

using namespace init_ipc;


class BadName 
{
}
;

inline static void good_name(struct sysvq::connect_req& req)
{
  const char*end = req.name+sizeof(req.name)-1;
  for(const char*i=req.name;i<=end;i++)
    if(!*i)return;
    
  say(_("corrupt request: name too long")); /* the name was too long to fit */
  throw BadName();
}
inline static InitConnection::Vec req2vec(struct sysvq::connect_req& req)
{
  InitConnection::Vec vec;
  const char*end = req.name+sizeof(req.name)-1;
  char*last=req.name;
  
  for(char*i=req.name;i<=end;i++)
    {
      if(!*i){
	vec.push_back(last);
	last = i+1;
	if(!*last)return vec;
      }
    }
  say(_("bad respawn request on SysV queue"));
  return vec;
}

static void handle_req(struct sysvq::connect_req& req)
{
  int reply_q = msgget(req.q_key,0);
  if(reply_q == -1){
    say(_("could not open reply queue"));
    return;
  }
  InitConnection* c = new sysvq::InitConnection(reply_q,req.msg_id,req.sid);
  debug((_("reply queue opened")));
  
  try{
    switch(req.command){
    case sysvq::connect_req::start_service:
      good_name(req);
      c->start_service(req.name);
      return;
    case  sysvq::connect_req::stop_service:
      good_name(req);
      c->stop_service(req.name);
      return;
    case  sysvq::connect_req::forget_service:
      good_name(req);
      c->forget_service(req.name);
      return;
    case sysvq::connect_req::respawn:
      {
	InitConnection::Vec v=req2vec(req);
	if(!v.empty())
	  c->respawn(v);
	else
	  say(_("badly formatted respawn request on SysV queue"));
	return;
      }
    case sysvq::connect_req::forget_respawn:
      good_name(req);
      c->forget_respawn(req.name);
      return;
    case  sysvq::connect_req::list_services:
      c->list_services();
      return;
    default:
      say(_("unknown command on SysV queue"));
    }
  }
  catch(BadName){
  }
  c->failure();
  delete c;
}
  
void Init::handle_connect()
{
  ssize_t length;
  struct sysvq::connect_req req;
  
  {
    PermitSignals ps;
    length = msgrcv(my_qid,&req,sizeof req - sizeof req.mtype,0,MSG_NOERROR);
  }
  
  if(length == -1)
    {
      if(errno==EAGAIN || errno==EINTR)
	return;
      if(errno==EIDRM)
	{
	  say(_("SysV init queue destroyed, recreating"));
	  my_qid=-1;
	  open();
	  handle_connect();
	}
      say(_("error receiving message on SysV message queue"));
      yield(5);/*wait for a while to avoid eating all CPU */
      return;
    }

  if(req.mtype != sysvq::version){
    say(_("bad message type on queue: mismatched versions?"));
    return ;
  }

  debug((_("received message on SysV queue")));

  handle_req(req);
}



