#ifndef SIMPLEIO_HH
#define SIMPLEIO_HH

#include <unistd.h>
#include <fcntl.h>

#include "bootstrap.hh"

namespace simpleio
{
  inline bool write(int fd,const char*string,size_t length)
  {
    int r;
    for(size_t point=0;point<length;point+=r){
      r=::write(fd,string+point,length);
      if(r==-1)return false;
    }
    return true;
  }
  inline bool read(int fd,char*string,size_t length)
  {
    int r;
    for(;length;string+=r,length-=r){
      r=::read(fd,string,length);
      if(r==-1)return false;
    }
    return true;
  }
  
  inline bool read_line(int fd,char*&line,char term='\n')
  {
    int size = 10;
    line = (char*)malloc(size+1);
    if(!line){
      say(_("out of memory allocating IO buffer"));
      return false;
    }
    int index=0;
    while(::read(fd,line+index,1)>0){
      if(index==size)
	{
	  size*=2;
	  line = (char*)realloc((void*)line,size+1);
	  if(!line){
	    say(_("out of memory reading line"));
	    return false;
	  }
	}
      if(line[index]==term){
	line[index]=0;
	return true;
      }
      index++;
    }
    xfree(line);
    if(index!=0)
      say(_("unterminated line"));
    return false;
  }
  
}

#endif
