#ifndef BOOTSTRAP_HH
#define BOOTSTRAP_HH
#include <stdlib.h>
#include <sys/types.h>
#include <signal.h>
#include <string.h>
#include <stdio.h>

#include "nls.hh"

/* #define debug(x) say x */
#define debug(x)

extern void panic(const char*f,...);
extern void say(const char*f,...);
extern void fprintb(int fd,const char*f,...);  /* simple printf for FDs */
extern void fputsb(int fd, const char*s);/* simple fputs for FDs */
  
extern void*xmalloc(size_t s);

extern char*xstrdup(const char*s);
template<class T>
static inline void xfree(T*&ptr)
{
  free((void*)ptr);
  ptr=0;
}
extern void init_terminal();
extern int open_console(int flags);
extern void do_exec(const char*bin,char*const*args)  __attribute__ ((__noreturn__));

extern void clear_signals();
extern void yield(int seconds=1);
extern void init_gettext();

#endif
