#ifndef SYNCPROCESS_HH
#define SYNCPROCESS_HH

#include <string>

#include <sys/wait.h>
#include <string.h>
#include <signal.h>

#include "Process.hh"
#include "bootstrap.hh"
#include "PermitSignals.hh"

class SyncProcess : public Process 
{
  
public:
  enum Status { starting, successful, failed 
  }
  ;
private:
  std::string my_name;
  Status my_status;
public:
  SyncProcess(const std::string&name,pid_t p):Process(p),my_name(name),
						 my_status(starting)
  {
  }
  bool died(int status)
  {
    if(WIFEXITED(status) && !WEXITSTATUS(status)){
      my_status = successful;
    }
    
    else{
      if(WIFSIGNALED(status)){
	say(_("\"%s\" was killed: status is \"%s\""),my_name.c_str(),sys_siglist[WTERMSIG(status)]);
      }
      else if(!WIFEXITED(status)){
	say(_("\"%s\" did not terminate normally"),my_name.c_str());
      }
      else {
	say(_("\"%s\" returned failure"),my_name.c_str());
      }
      my_status = failed;
    }

    return false;
  }
  bool is_successful()const
  {
    return my_status == successful;
  }
  bool is_finished()const
  {
    return my_status != starting;
  }
  void wait()
  {
    PermitSignals ps;
    while(!is_finished())
      pause();
  }
};

#endif

