#ifndef SERVICEHELPER_HH
#define SERVICEHELPER_HH

#include "Service.hh"
#include "Process.hh"

class ServiceHelper:public Process
{
  class Service*my_service;
  Service::Status my_success;
  Service::Status my_failure;

public:
  ServiceHelper(pid_t p,Service*s,Service::Status good,Service::Status bad)
    : Process(p),my_service(s),my_success(good),my_failure(bad)
  {
  }
  bool died(int status)
  {
    if(WIFEXITED(status))
      {
	if(!WEXITSTATUS(status)) {
	  my_service->helper_finished(my_success);
	  return true;
	}
	else {
	  say(_("%s of service \"%s\" returned failure"),my_service->strstatus(),my_service->get_name().c_str());
	}
      }
    else if(WIFSIGNALED(status))
      {
	say(_("%s of service \"%s\" got hit with a signal"),my_service->strstatus(),my_service->get_name().c_str());
      }
    else if(WIFSTOPPED(status))
      {
	say(_("%s of service \"%s\" has been stopped"),my_service->strstatus(),my_service->get_name().c_str());
      }
    else {
      say(_("something strange happened to %s of service \"%s\""),my_service->strstatus(),my_service->get_name().c_str());
    }
    my_service->helper_finished(my_failure);
    
    return true;
  }
  Service*get_service()
  {
    return my_service;
  }
  
}
;
  
  
#endif
