#include "Service.hh"

#include "ServiceStopper.hh"
#include "ServiceStarter.hh"
#include "ProcessTab.hh"
#include "ServiceNotification.hh"
#include "Inittab.hh"
#include "bootstrap.hh"

Service::Service(const std::string&n):my_status(unstarted),my_helper(0)
  {
    my_name = n;
    debug((_("service \"%s\" (%x) created"),n.c_str(),this));
    global_processtab.add_service(n,this);
  }

Service::~Service()
  {
    debug((_("service \"%s\" (%x) destroyed"),get_name().c_str(),this));
    
    new_status(destroyed);
    for(my_dependencies_type::iterator i=my_dependencies.begin();i!=my_dependencies.end();i++){
      (*i)->del_dependant(this);
    }
    for(my_dependants_type::iterator i=my_dependants.begin();i!=my_dependants.end();i++){
      (*i)->del_dependency(this);
    }
    
  for(my_watchers_type::iterator i=my_watchers.begin();i!=my_watchers.end();i++){
    delete *i;
  }
  my_dependencies.clear();
  my_dependants.clear();
  my_watchers.clear();
  
  if(my_helper){
    delete my_helper;
    my_helper = 0;
  }
  global_processtab.remove_service(my_name,this);
  }

unsigned Service::stop_dependants()
{
  unsigned d=0;
  if(my_status == successful){
    new_status(finishing);    
  }

  for(my_dependants_type::iterator i=my_dependants.begin();i!=my_dependants.end();i++){
    if(global_inittab.stop_service(*i))
      d++;
  }
  return d;
}

void Service::stop(pid_t p)
{
  my_helper = new ServiceStopper(p,this);
}

void Service::start(pid_t pid)
{
  new_status(starting);
  my_helper = new ServiceStarter(pid,this);
}

void Service::do_event(Service::my_watchers_type::iterator i)
  {
    debug((_("sending callback for service \"%s\", status: %s"),my_name.c_str(),strstatus()));
    
    if((*i)->event(this,my_status)){
      debug((_("removing callback")));
      delete *i;
      my_watchers.erase(i);
    }
  }
