#ifndef PROCESSTAB_HH
#define PROCESSTAB_HH


#include <list>
#include <hash_map>
#include <map>
#include <string>

#include <sys/types.h>
#include <sys/wait.h>
#include <unistd.h>

#include "bootstrap.hh"
#include "Service.hh"

class Process;
class Service;
class Respawner;

class ProcessTab 
{
  typedef std::hash_map<pid_t,Process*> my_pidtab_type;
  my_pidtab_type my_pidtab;
  typedef std::map<std::string,Service*> my_servicetab_type;
  my_servicetab_type my_servicetab;
  typedef std::map<std::string,Respawner*> my_respawners_type;
  my_respawners_type my_respawners;
  
public:
  void wait();

  void stop_all_services();
  void respawn();
  
  void add_respawner(const std::string&id, Respawner*r)
  {
    my_respawners.insert(my_respawners_type::value_type(id,r));
  }
  void remove_respawner(Respawner*r)
  {
    for(my_respawners_type::iterator i = my_respawners.begin();
	i!=my_respawners.end();
	i++)
      if((*i).second == r){
	my_respawners.erase(i);
	return;
      }
    panic(_("removing respawner that does not exist!"));
  }
  
  void add_process(pid_t i, Process*p)
  {
    if(get_process(i)){
      panic(_("adding the same process twice"));
    }
    my_pidtab.insert(my_pidtab_type::value_type(i,p));
  }
  void add_service(std::string n,Service*s)
  {
    my_servicetab.insert(my_servicetab_type::value_type(n,s));
  }
  void remove_service(const std::string&n,Service*s)
  {
    my_servicetab_type::iterator j = my_servicetab.find(n);
    if(j==my_servicetab.end() || (*j).second != s)
      panic(_("internal service table corrupt!"));
    my_servicetab.erase(j);
  }

  void remove_process(pid_t i, Process*p)
  {
    my_pidtab_type::iterator j = my_pidtab.find(i);
    if(j==my_pidtab.end() || (*j).second != p)
      {
	return; /* this process has already died */
      }
    
    my_pidtab.erase(j);
  }
  std::string list_services()
  {
    std::string ans;

    ans = _("Name\t\tStatus\t\tDependants\n");
    
    for(my_servicetab_type::iterator i=my_servicetab.begin();i!=my_servicetab.end();i++){
      Service*s=(*i).second;
      
      ans += s->get_name();
      ans += "\t\t";
      ans += s->strstatus();
      ans += "\t\t";
      ans += s->list_dependants();
      ans += '\n';
    }
    return ans;
  }
  Respawner*get_respawner(const std::string&r)
  {
    my_respawners_type::iterator i=my_respawners.find(r);
    if(i==my_respawners.end())return 0;
    return (*i).second;
  }
  Process*get_process(pid_t p)
  {
    my_pidtab_type::iterator i=my_pidtab.find(p);
    if(i==my_pidtab.end())return 0;
    return (*i).second;
  }
  Service*get_service(const std::string&n)
  {
    my_servicetab_type::iterator i = my_servicetab.find(n);
    if(i==my_servicetab.end()){
      debug((_("nothing known about service \"%s\""),n.c_str()));
      return 0;
    }
    else
      debug((_("service \"%s\" exists and has status %s"),n.c_str(),(*i).second->strstatus()));
      
    return (*i).second;
  }
};

extern ProcessTab global_processtab;

#endif
